/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.archive;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import net.yapbam.data.GlobalData;
import net.yapbam.data.Statement;
import net.yapbam.gui.IconManager;
import net.yapbam.gui.LocalizationData;
import net.yapbam.util.ArrayUtils;

class StatementSelectionTableModel
extends AbstractTableModel
implements TableModel {
    private final int alertColumn;
    private final int accountColumn;
    private final int ignoredColumn;
    private final int statementColumn;
    private GlobalData data;
    private boolean[] ignored;
    private Statement[] selectedStatements;
    private Statement[][] statements;
    private CharSequence[] alerts;
    private boolean toArchive;

    public StatementSelectionTableModel(GlobalData data, CharSequence[] alerts) {
        this.setData(data, false);
        this.alerts = (CharSequence[])alerts.clone();
        this.alertColumn = ArrayUtils.isAllNull(alerts) ? -1 : 0;
        this.accountColumn = this.alertColumn + 1;
        this.ignoredColumn = this.accountColumn + 1;
        this.statementColumn = this.ignoredColumn + 1;
    }

    void setData(GlobalData data, boolean isArchive) {
        this.toArchive = !isArchive;
        this.data = data;
        this.statements = new Statement[data.getAccountsNumber()][];
        this.ignored = new boolean[data.getAccountsNumber()];
        for (int i = 0; i < this.statements.length; ++i) {
            this.statements[i] = Statement.getStatements(data.getAccount(i));
        }
        Arrays.fill(this.ignored, true);
        this.selectedStatements = new Statement[this.ignored.length];
        this.fireTableDataChanged();
        this.fireTableRowsUpdated(-1, -1);
    }

    @Override
    public int getRowCount() {
        return this.data.getAccountsNumber();
    }

    @Override
    public int getColumnCount() {
        return this.statementColumn + 1;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == this.alertColumn) {
            return this.alerts[rowIndex] == null ? null : IconManager.get(IconManager.Name.ALERT);
        }
        if (columnIndex == this.accountColumn) {
            return this.data.getAccount(rowIndex).getName();
        }
        if (columnIndex == this.ignoredColumn) {
            return this.ignored[rowIndex];
        }
        if (columnIndex == this.statementColumn) {
            if (!this.hasStatement(rowIndex)) {
                return new Statement(LocalizationData.get("Archive.statementSelection.nothingSelected"), 0.0);
            }
            return this.ignored[rowIndex] || this.selectedStatements[rowIndex] == null ? new Statement("-", 0.0) : this.selectedStatements[rowIndex];
        }
        return null;
    }

    boolean hasStatement(int index) {
        return this.getStatements(index).length >= 2 || this.getStatements(index)[0].getId() != null;
    }

    Statement[] getStatements(int index) {
        return this.statements[index];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == this.alertColumn) {
            return Icon.class;
        }
        if (columnIndex == this.accountColumn) {
            return String.class;
        }
        if (columnIndex == this.ignoredColumn) {
            return Boolean.class;
        }
        if (columnIndex == this.statementColumn) {
            return Statement.class;
        }
        return super.getColumnClass(columnIndex);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.hasStatement(rowIndex) && (columnIndex == this.ignoredColumn || columnIndex == this.statementColumn);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex == this.ignoredColumn) {
            this.ignored[rowIndex] = (Boolean)aValue;
        } else if (columnIndex == this.statementColumn) {
            this.selectedStatements[rowIndex] = (Statement)aValue;
            this.ignored[rowIndex] = false;
        }
        this.fireTableRowsUpdated(rowIndex, rowIndex);
    }

    @Override
    public String getColumnName(int column) {
        if (column == this.alertColumn) {
            return "";
        }
        if (column == this.accountColumn) {
            return LocalizationData.get("Transaction.account");
        }
        if (column == this.ignoredColumn) {
            return LocalizationData.get("Archive.statementSelection.ignored.title");
        }
        if (column == this.statementColumn) {
            String key = this.toArchive ? "Archive.statementSelection.until.title" : "Archive.statementSelection.from.title";
            return LocalizationData.get(key);
        }
        return super.getColumnName(column);
    }

    void setAllExported(boolean exported) {
        if (!exported) {
            Arrays.fill(this.ignored, true);
        } else {
            for (int i = 0; i < this.ignored.length; ++i) {
                this.ignored[i] = !this.hasStatement(i);
            }
        }
        this.fireTableRowsUpdated(0, this.getRowCount() - 1);
    }

    Set<String> getSelectedStatements(int index) {
        if (!this.ignored[index] && this.selectedStatements[index] != null) {
            HashSet<String> result = new HashSet<String>();
            int i = this.toArchive ? -1 : this.statements[index].length;
            int increment = this.toArchive ? 1 : -1;
            do {
                result.add(this.statements[index][i += increment].getId());
            } while (!this.statements[index][i].getId().equals(this.selectedStatements[index].getId()));
            return result;
        }
        return Collections.emptySet();
    }

    public boolean[] isSelectedAccount() {
        boolean[] result = new boolean[this.data.getAccountsNumber()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.selectedStatements[i] != null;
        }
        return result;
    }

    int getAlertColumn() {
        return this.alertColumn;
    }

    int getStatementColumn() {
        return this.statementColumn;
    }

    int getAccountColumn() {
        return this.accountColumn;
    }

    boolean hasAlert(int row) {
        return this.alerts[row] != null;
    }
}

