/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.dialogs;

import com.fathzer.jlocal.Formatter;
import com.fathzer.soft.ajlib.swing.Utils;
import com.fathzer.soft.ajlib.swing.widget.AbstractTitledPanel;
import com.fathzer.soft.ajlib.swing.widget.HTMLPane;
import java.awt.Dimension;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.URL;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import net.yapbam.gui.ErrorManager;
import net.yapbam.gui.LocalizationData;
import net.yapbam.relnotes.ReleaseNotesFormatter;
import net.yapbam.util.ApplicationContext;

public class AboutPanel
extends AbstractTitledPanel<Void> {
    private static final Dimension PREFERED_HTML_PANE_SIZE = new Dimension(640, 480);
    private static final long serialVersionUID = 1L;
    private JTabbedPane jTabbedPane = null;
    private HTMLPane relnotesPane = null;
    private HTMLPane licensePane = null;
    private HTMLPane aboutPane = null;

    public AboutPanel() {
        super(Formatter.format(LocalizationData.get("AboutDialog.Content"), "Jean-Marc Astesana (Fathzer)", ApplicationContext.getVersion(), "2018"), UIManager.getIcon("OptionPane.informationIcon"), null);
    }

    protected JComponent getJTabbedPane() {
        if (this.jTabbedPane == null) {
            this.jTabbedPane = new JTabbedPane();
            try {
                this.jTabbedPane.addTab(LocalizationData.get("AboutDialog.License.TabName"), null, this.getLicensePane(), null);
                this.jTabbedPane.addTab(LocalizationData.get("AboutDialog.RelNotes.TabName"), null, this.getRelnotesPane(), null);
                this.jTabbedPane.addTab(LocalizationData.get("AboutDialog.Contributors.TabName"), null, this.getAboutPane(), null);
            }
            catch (IOException e) {
                ErrorManager.INSTANCE.log(Utils.getOwnerWindow(this), e);
            }
        }
        return this.jTabbedPane;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HTMLPane getRelnotesPane() throws IOException {
        if (this.relnotesPane == null) {
            URL url = LocalizationData.getURL("relnotes.txt");
            BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream(), "UTF-8"));
            try {
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                ReleaseNotesFormatter releaseNotesFormatter = new ReleaseNotesFormatter();
                releaseNotesFormatter.setIgnoreNext(true);
                releaseNotesFormatter.build(reader, new BufferedWriter(new OutputStreamWriter(stream)));
                String html = stream.toString();
                this.relnotesPane = new HTMLPane(html);
            }
            finally {
                reader.close();
            }
            this.relnotesPane.setPreferredSize(PREFERED_HTML_PANE_SIZE);
        }
        return this.relnotesPane;
    }

    private HTMLPane getLicensePane() throws IOException {
        if (this.licensePane == null) {
            this.licensePane = new HTMLPane(LocalizationData.getURL("license.html"));
            this.licensePane.setPreferredSize(PREFERED_HTML_PANE_SIZE);
        }
        return this.licensePane;
    }

    @Override
    public JComponent getCenterComponent() {
        return this.getJTabbedPane();
    }

    private HTMLPane getAboutPane() throws IOException {
        if (this.aboutPane == null) {
            this.aboutPane = new HTMLPane(LocalizationData.getURL("contributors.html"));
        }
        return this.aboutPane;
    }
}

