/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.dialogs;

import com.fathzer.soft.ajlib.swing.dialog.AbstractDialog;
import java.awt.Window;
import javax.swing.JPanel;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.Preferences;
import net.yapbam.gui.dialogs.ErrorPanel;

public class ErrorDialog
extends AbstractDialog<Throwable, Boolean> {
    private static final long serialVersionUID = 1L;
    ErrorPanel panel;
    private boolean prefcanBeSaved;

    public ErrorDialog(Window parent, Throwable throwable) {
        super(parent, LocalizationData.get("ErrorManager.title"), throwable);
        this.getCancelButton().setText(LocalizationData.get("GenericButton.no"));
        this.getCancelButton().setToolTipText(LocalizationData.get("ErrorManager.report.dontSend.tootip"));
        this.getOkButton().setText(LocalizationData.get("GenericButton.yes"));
        this.getOkButton().setToolTipText(LocalizationData.get("ErrorManager.report.send.tootip"));
        this.prefcanBeSaved = Preferences.canSave();
        this.panel.setDontAskMeVisible(this.prefcanBeSaved);
        this.pack();
    }

    @Override
    protected JPanel createCenterPane() {
        this.panel = new ErrorPanel();
        return this.panel;
    }

    @Override
    protected Boolean buildResult() {
        this.setPreferences(1);
        return Boolean.TRUE;
    }

    @Override
    protected String getOkDisabledCause() {
        return null;
    }

    @Override
    protected void cancel() {
        super.cancel();
        this.setPreferences(-1);
    }

    private void setPreferences(int action) {
        if (this.prefcanBeSaved) {
            Preferences.INSTANCE.setCrashReportAction(this.panel.isDontAskMeSelected() ? action : 0);
        }
    }
}

