/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.dialogs;

import com.fathzer.soft.ajlib.swing.dialog.AbstractDialog;
import java.awt.Window;
import javax.swing.Icon;
import javax.swing.JPanel;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.dialogs.GetPasswordPanel;
import net.yapbam.gui.util.AutoUpdateOkButtonPropertyListener;

public class GetPasswordDialog
extends AbstractDialog<InitData, String> {
    private GetPasswordPanel panel;
    private boolean confirmIsRequired = false;

    public GetPasswordDialog(Window owner, String title, String question, Icon icon, String password) {
        super(owner, title, new InitData(question, icon, password));
    }

    @Override
    protected String buildResult() {
        return this.panel.getPassword();
    }

    @Override
    protected JPanel createCenterPane() {
        this.panel = new GetPasswordPanel();
        if (((InitData)this.data).password != null) {
            this.panel.setPassword(((InitData)this.data).password);
        }
        this.panel.setIcon(((InitData)this.data).icon);
        this.panel.setQuestion(((InitData)this.data).question);
        this.panel.addPropertyChangeListener("Confirmed", new AutoUpdateOkButtonPropertyListener(this));
        return this.panel;
    }

    @Override
    protected String getOkDisabledCause() {
        if (this.confirmIsRequired && !this.panel.isPasswordConfirmed()) {
            return LocalizationData.get("FilePasswordDialog.confirmIsNotOk");
        }
        return null;
    }

    public void setWarningMessage(String message) {
        this.panel.setWarningMessage(message);
        this.pack();
    }

    public String getPassword() {
        return (String)this.getResult();
    }

    public void setPasswordFieldToolTipText(String tooltip) {
        this.panel.setPasswordFieldToolTipText(tooltip);
    }

    public void setConfirmIsRequired(boolean required) {
        this.confirmIsRequired = required;
        this.panel.setConfirmIsVisible(true);
        this.pack();
    }

    static class InitData {
        private String question;
        private Icon icon;
        private String password;

        private InitData(String question, Icon icon, String password) {
            this.question = question;
            this.icon = icon;
            this.password = password;
        }
    }
}

