/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.dialogs;

import com.fathzer.soft.ajlib.swing.Utils;
import net.yapbam.data.Account;
import net.yapbam.data.Mode;
import net.yapbam.date.helpers.DateStepper;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.dialogs.ModeDialog;
import net.yapbam.gui.dialogs.ModeWidgetParams;
import net.yapbam.gui.widget.AbstractSelector;

public class ModeWidget
extends AbstractSelector<Mode, ModeWidgetParams> {
    public static final String MODE_PROPERTY = "mode";

    public ModeWidget(ModeWidgetParams data) {
        super(data);
    }

    @Override
    protected String getLabel() {
        return LocalizationData.get("TransactionDialog.mode");
    }

    @Override
    protected String getComboTip() {
        return LocalizationData.get("TransactionDialog.mode.tooltip");
    }

    @Override
    protected String getNewButtonTip() {
        return LocalizationData.get("TransactionDialog.mode.new.tooltip");
    }

    @Override
    protected String getPropertyName() {
        return MODE_PROPERTY;
    }

    @Override
    protected void populateCombo() {
        Account account;
        if (this.getParameters() != null && (account = ((ModeWidgetParams)this.getParameters()).getAccount()) != null) {
            for (int i = 0; i < account.getModesNumber(); ++i) {
                DateStepper ds;
                Mode mode = account.getMode(i);
                DateStepper dateStepper = ds = ((ModeWidgetParams)this.getParameters()).isExpense() ? mode.getExpenseVdc() : mode.getReceiptVdc();
                if (ds == null) continue;
                this.getCombo().addItem(mode);
            }
        }
    }

    @Override
    protected Object getDefaultRenderedValue(Mode mode) {
        return mode == null ? mode : (mode.equals(Mode.UNDEFINED) ? LocalizationData.get("Mode.undefined") : mode.getName());
    }

    @Override
    protected Mode createNew() {
        if (this.getParameters() != null) {
            return ModeDialog.open(((ModeWidgetParams)this.getParameters()).getGlobalData(), ((ModeWidgetParams)this.getParameters()).getAccount(), Utils.getOwnerWindow(this));
        }
        return null;
    }
}

