/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.dialogs.export;

import au.com.bytecode.opencsv.CSVReader;
import com.fathzer.soft.ajlib.utilities.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.yapbam.data.Account;
import net.yapbam.data.Category;
import net.yapbam.data.GlobalData;
import net.yapbam.data.Mode;
import net.yapbam.data.SubTransaction;
import net.yapbam.data.Transaction;
import net.yapbam.date.helpers.DateStepper;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.dialogs.export.ImportError;
import net.yapbam.gui.dialogs.export.ImporterParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Importer {
    private static final Logger LOGGER = LoggerFactory.getLogger(Importer.class);
    private File file;
    private ImporterParameters parameters;
    private Account defaultAccount;
    private CurrentTransaction current;
    private DateFormat dateFormatter;
    private int lastUsedColumnInImportedFile;
    private ParsePosition ppos = new ParsePosition(0);

    public Importer(File file, ImporterParameters parameters, GlobalData data, Account defaultAccount) {
        this.file = file;
        this.parameters = parameters;
        this.defaultAccount = defaultAccount;
        this.dateFormatter = SimpleDateFormat.getDateInstance(3, LocalizationData.getLocale());
        this.lastUsedColumnInImportedFile = -1;
        for (int i = 0; i < parameters.getImportedFileColumns().length; ++i) {
            if (parameters.getImportedFileColumns()[i] <= this.lastUsedColumnInImportedFile) continue;
            this.lastUsedColumnInImportedFile = parameters.getImportedFileColumns()[i];
        }
        ++this.lastUsedColumnInImportedFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImportError[] importFile(GlobalData data) throws IOException {
        if (data != null) {
            data.setEventsEnabled(false);
        }
        this.current = null;
        boolean accountPart = true;
        ArrayList<ImportError> errors = new ArrayList<ImportError>();
        try {
            CSVReader reader = new CSVReader((Reader)new InputStreamReader((InputStream)new FileInputStream(FileUtils.getCanonical(this.file)), this.parameters.getEncoding()), this.parameters.getColumnSeparator(), '\"', this.parameters.getIgnoredLeadingLines());
            try {
                int lineNumber = this.parameters.getIgnoredLeadingLines();
                String[] fields = reader.readNext();
                while (fields != null) {
                    ++lineNumber;
                    try {
                        accountPart = !this.importLine(data, lineNumber, fields, accountPart) && accountPart;
                    }
                    catch (ImportException e) {
                        LOGGER.trace("ImportLine reports", e);
                        errors.add(e.getError());
                    }
                    fields = reader.readNext();
                }
            }
            finally {
                try {
                    reader.close();
                    if (data != null) {
                        this.recordCurrentTransaction(data);
                    }
                }
                catch (IOException e) {
                    LOGGER.warn("Error while closing " + this.file, e);
                }
            }
        }
        finally {
            if (data != null) {
                data.setEventsEnabled(true);
            }
        }
        return errors.toArray(new ImportError[errors.size()]);
    }

    private void recordCurrentTransaction(GlobalData data) {
        if (this.current != null) {
            data.add(this.current.toTransaction());
            this.current = null;
        }
    }

    private boolean importLine(GlobalData data, int lineNumber, String[] fields, boolean accountPart) throws ImportException {
        boolean[] invalidFields = new boolean[this.lastUsedColumnInImportedFile];
        boolean hasError = false;
        int index = this.parameters.getImportedFileColumns()[4];
        double amount = 0.0;
        try {
            amount = this.parseAmount(this.getField(fields, index, ""));
        }
        catch (ParseException e) {
            invalidFields[index] = true;
            hasError = true;
        }
        index = this.parameters.getImportedFileColumns()[1];
        Date date = null;
        try {
            date = this.parseDate(this.getField(fields, index, ""));
        }
        catch (ParseException e) {
            invalidFields[index] = true;
            hasError = true;
        }
        boolean isTransaction = date != null;
        Account account = null;
        if ((isTransaction || accountPart) && !hasError) {
            index = this.parameters.getImportedFileColumns()[0];
            String accountStr = this.getField(fields, index, "");
            if (accountStr.length() == 0) {
                String string = accountStr = this.defaultAccount == null ? LocalizationData.get("ImportDialog.defaultAccount") : this.defaultAccount.getName();
            }
            if (data != null && (account = data.getAccount(accountStr)) == null) {
                account = new Account(accountStr, 0.0);
                data.add(account);
            }
        }
        if (accountPart && !isTransaction) {
            if (data != null && !hasError) {
                double initialBalance = account.getInitialBalance() + amount;
                data.setInitialBalance(account, initialBalance);
            }
            if (hasError) {
                throw new ImportException(new ImportError(lineNumber, fields, invalidFields));
            }
        } else {
            index = this.parameters.getImportedFileColumns()[2];
            String description = this.getField(fields, index, "");
            index = this.parameters.getImportedFileColumns()[8];
            Date valueDate = null;
            try {
                valueDate = this.parseDate(this.getField(fields, index, ""));
                if (valueDate == null) {
                    valueDate = date;
                }
            }
            catch (ParseException e) {
                invalidFields[index] = true;
                hasError = true;
            }
            if (hasError) {
                throw new ImportException(new ImportError(lineNumber, fields, invalidFields));
            }
            index = this.parameters.getImportedFileColumns()[5];
            String categoryName = this.getField(fields, index, "");
            Category category = Category.UNDEFINED;
            if (data != null) {
                if (categoryName.length() > 0) {
                    category = data.getCategory(categoryName);
                }
                if (category == null) {
                    category = new Category(categoryName);
                    data.add(category);
                }
            }
            if (isTransaction) {
                index = this.parameters.getImportedFileColumns()[3];
                String comment = this.getField(fields, index, "");
                index = this.parameters.getImportedFileColumns()[7];
                String number = this.getField(fields, index, null);
                index = this.parameters.getImportedFileColumns()[9];
                String statement = this.getField(fields, index, "");
                if (statement.length() == 0) {
                    statement = null;
                }
                index = this.parameters.getImportedFileColumns()[6];
                String modeName = this.getField(fields, index, "");
                Mode mode = Mode.UNDEFINED;
                if (data != null) {
                    if (modeName.length() > 0) {
                        mode = account.getMode(modeName);
                    }
                    if (mode == null) {
                        mode = new Mode(modeName, DateStepper.IMMEDIATE, DateStepper.IMMEDIATE, false);
                        data.add(account, mode);
                    }
                }
                if (data != null) {
                    this.recordCurrentTransaction(data);
                }
                this.current = new CurrentTransaction(account, description, comment, date, amount, category, mode, number, valueDate, statement);
            } else {
                this.current.subtransactions.add(new SubTransaction(amount, description, category));
            }
        }
        return isTransaction;
    }

    private String getField(String[] fields, int index, String defaultValue) {
        if (index == -1 || index >= fields.length) {
            return defaultValue;
        }
        return fields[index].trim();
    }

    private double parseAmount(String text) throws ParseException {
        char groupingSeparator;
        NumberFormat format = NumberFormat.getCurrencyInstance(LocalizationData.getLocale());
        this.customizeSymbols(format);
        if (!text.isEmpty() && text.charAt(0) == '+') {
            text = text.substring(1);
        }
        if ((groupingSeparator = ((DecimalFormat)format).getDecimalFormatSymbols().getGroupingSeparator()) == '\u00a0') {
            text = text.replace(' ', groupingSeparator);
        }
        try {
            return format.parse(text).doubleValue();
        }
        catch (ParseException e) {
            format = NumberFormat.getInstance(LocalizationData.getLocale());
            this.customizeSymbols(format);
            this.ppos.setIndex(0);
            Number parsed = format.parse(text, this.ppos);
            if (parsed == null) {
                throw new ParseException(text, this.ppos.getIndex());
            }
            double value = parsed.doubleValue();
            if (this.ppos.getIndex() < text.length()) {
                throw new ParseException(text, this.ppos.getIndex());
            }
            return value;
        }
    }

    private void customizeSymbols(NumberFormat format) {
        Character decimalSeparator = Character.valueOf(this.parameters.getDecimalSeparator());
        if (decimalSeparator != null) {
            DecimalFormatSymbols decimalFormatSymbols = ((DecimalFormat)format).getDecimalFormatSymbols();
            decimalFormatSymbols.setMonetaryDecimalSeparator(decimalSeparator.charValue());
            decimalFormatSymbols.setDecimalSeparator(decimalSeparator.charValue());
            ((DecimalFormat)format).setDecimalFormatSymbols(decimalFormatSymbols);
        }
    }

    private Date parseDate(String text) throws ParseException {
        if (text.length() == 0) {
            return null;
        }
        return this.dateFormatter.parse(text);
    }

    public File getFile() {
        return this.file;
    }

    public ImporterParameters getParameters() {
        return this.parameters;
    }

    private static class ImportException
    extends Exception {
        private final ImportError error;

        public ImportException(ImportError error) {
            this.error = error;
        }

        public ImportError getError() {
            return this.error;
        }
    }

    static class CurrentTransaction {
        Account account;
        String description;
        String comment;
        Date date;
        double amount;
        Category category;
        Mode mode;
        String number;
        Date valueDate;
        String statement;
        List<SubTransaction> subtransactions;

        public CurrentTransaction(Account account, String description, String comment, Date date, double amount, Category category, Mode mode, String number, Date valueDate, String statement) {
            this.account = account;
            this.description = description;
            this.comment = comment;
            this.date = date;
            this.amount = amount;
            this.category = category;
            this.mode = mode;
            this.number = number;
            this.valueDate = valueDate;
            this.statement = statement;
            this.subtransactions = new ArrayList<SubTransaction>();
        }

        public Transaction toTransaction() {
            return new Transaction(this.date, this.number, this.description, this.comment, this.amount, this.account, this.mode, this.category, this.valueDate, this.statement, this.subtransactions);
        }
    }
}

