/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.dialogs.preferences;

import com.fathzer.jlocal.Formatter;
import com.fathzer.soft.ajlib.swing.widget.IntegerWidget;
import com.fathzer.soft.ajlib.swing.widget.PasswordWidget;
import com.fathzer.soft.ajlib.swing.widget.TextWidget;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigInteger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.Preferences;
import net.yapbam.gui.dialogs.preferences.PreferencePanel;

public class ProxyPanel
extends PreferencePanel {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_PROXY_PORT = 3128;
    private static final int IP_PORT_MAX_VALUE = 65535;
    private JRadioButton noProxyButton = null;
    private JRadioButton proxyButton = null;
    private JPanel proxyPanel = null;
    private JLabel proxyLabel = null;
    private TextWidget proxyHostField = null;
    private JLabel proxyPortLabel = null;
    private IntegerWidget proxyPortField = null;
    private JPanel authenticationPanel = null;
    private JLabel userLabel = null;
    private TextWidget userField = null;
    private JLabel passwordLabel = null;
    private PasswordWidget passwordField = null;
    private JCheckBox showPassCheckBox = null;
    private PropertyChangeListener updateOkListener;

    public ProxyPanel() {
        this.initialize();
    }

    private void initialize() {
        this.updateOkListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ProxyPanel.this.setOkDisabledCause(ProxyPanel.this.buildOkDisabledCause());
            }
        };
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.weighty = 1.0;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.anchor = 11;
        gridBagConstraints2.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints2.gridy = 2;
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.anchor = 17;
        gridBagConstraints1.gridy = 1;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = 0;
        this.setSize(388, 282);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getNoProxyButton(), gridBagConstraints);
        this.add((Component)this.getProxyButton(), gridBagConstraints1);
        this.add((Component)this.getProxyPanel(), gridBagConstraints2);
        ButtonGroup group = new ButtonGroup();
        group.add(this.getNoProxyButton());
        group.add(this.getProxyButton());
        String host = Preferences.INSTANCE.getHttpProxyHost();
        this.getNoProxyButton().setSelected(host == null);
        this.getProxyButton().setSelected(host != null);
        this.getProxyHostField().setText(host);
        if (host != null) {
            this.getProxyPortField().setText(Integer.toString(Preferences.INSTANCE.getHttpProxyPort()));
        }
        this.getUserField().setText(Preferences.INSTANCE.getHttpProxyUser());
        this.getPasswordField().setText(Preferences.INSTANCE.getHttpProxyPassword());
    }

    private String buildOkDisabledCause() {
        if (this.getProxyButton().isSelected()) {
            if (this.getProxyHost() == null) {
                return Formatter.format(LocalizationData.get("PreferencesDialog.Network.proxyNameMissing"), this.getTitle());
            }
            if (this.getProxyHost().indexOf(58) >= 0) {
                return LocalizationData.get("PreferencesDialog.Network.invalidProxyName");
            }
            Integer port = this.getProxyPort();
            if (port == 0 || port > 65535) {
                return Formatter.format(LocalizationData.get("PreferencesDialog.Network.invalidPort"), this.getTitle(), 65535);
            }
        }
        return null;
    }

    private JRadioButton getNoProxyButton() {
        if (this.noProxyButton == null) {
            this.noProxyButton = new JRadioButton();
            this.noProxyButton.setText(LocalizationData.get("PreferencesDialog.Network.direct"));
            this.noProxyButton.setToolTipText(LocalizationData.get("PreferencesDialog.Network.direct.tooltip"));
            this.noProxyButton.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    ProxyPanel.this.setProxyEnabled(!ProxyPanel.this.getNoProxyButton().isSelected());
                    ProxyPanel.this.setOkDisabledCause(ProxyPanel.this.buildOkDisabledCause());
                }
            });
        }
        return this.noProxyButton;
    }

    private void setProxyEnabled(boolean enabled) {
        this.proxyLabel.setEnabled(enabled);
        this.proxyPortLabel.setEnabled(enabled);
        this.userLabel.setEnabled(enabled);
        this.passwordLabel.setEnabled(enabled);
        this.showPassCheckBox.setEnabled(enabled);
        this.getProxyHostField().setEnabled(enabled);
        this.getProxyPortField().setEnabled(enabled);
        this.getUserField().setEnabled(enabled);
        this.getPasswordField().setEnabled(enabled);
        Color color = enabled ? Color.BLACK : Color.GRAY;
        TitledBorder border = BorderFactory.createTitledBorder(null, LocalizationData.get("PreferencesDialog.Network.authentication"), 0, 0, null, color);
        this.getAuthenticationPanel().setBorder(border);
    }

    private JRadioButton getProxyButton() {
        if (this.proxyButton == null) {
            this.proxyButton = new JRadioButton();
            this.proxyButton.setText(LocalizationData.get("PreferencesDialog.Network.proxy.title"));
            this.proxyButton.setToolTipText(LocalizationData.get("PreferencesDialog.Network.proxy.tooltip"));
            this.proxyButton.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    ProxyPanel.this.setOkDisabledCause(ProxyPanel.this.buildOkDisabledCause());
                }
            });
        }
        return this.proxyButton;
    }

    private JPanel getProxyPanel() {
        if (this.proxyPanel == null) {
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.gridx = 0;
            gridBagConstraints7.fill = 1;
            gridBagConstraints7.gridwidth = 2;
            gridBagConstraints7.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints7.gridy = 2;
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 0;
            gridBagConstraints6.anchor = 17;
            gridBagConstraints6.gridy = 1;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.fill = 2;
            gridBagConstraints5.gridx = 1;
            gridBagConstraints5.gridy = 1;
            gridBagConstraints5.insets = new Insets(0, 5, 5, 5);
            gridBagConstraints5.weightx = 1.0;
            this.proxyPortLabel = new JLabel();
            this.proxyPortLabel.setText(LocalizationData.get("PreferencesDialog.Network.port.label"));
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.anchor = 17;
            gridBagConstraints4.gridy = 0;
            gridBagConstraints4.gridx = 0;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.fill = 2;
            gridBagConstraints3.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints3.gridx = 1;
            gridBagConstraints3.gridy = 0;
            gridBagConstraints3.weightx = 1.0;
            this.proxyLabel = new JLabel();
            this.proxyLabel.setText(LocalizationData.get("PreferencesDialog.Network.proxy.label"));
            this.proxyPanel = new JPanel();
            this.proxyPanel.setLayout(new GridBagLayout());
            this.proxyPanel.add((Component)this.proxyLabel, gridBagConstraints4);
            this.proxyPanel.add((Component)this.getProxyHostField(), gridBagConstraints3);
            this.proxyPanel.add((Component)this.proxyPortLabel, gridBagConstraints6);
            this.proxyPanel.add((Component)this.getProxyPortField(), gridBagConstraints5);
            this.proxyPanel.add((Component)this.getAuthenticationPanel(), gridBagConstraints7);
        }
        return this.proxyPanel;
    }

    private JTextField getProxyHostField() {
        if (this.proxyHostField == null) {
            this.proxyHostField = new TextWidget(10);
            this.proxyHostField.setToolTipText(LocalizationData.get("PreferencesDialog.Network.proxyField.tooltip"));
            this.proxyHostField.addPropertyChangeListener("text", this.updateOkListener);
        }
        return this.proxyHostField;
    }

    private IntegerWidget getProxyPortField() {
        if (this.proxyPortField == null) {
            this.proxyPortField = new IntegerWidget(BigInteger.ZERO, null);
            this.proxyPortField.setColumns(10);
            this.proxyPortField.setToolTipText(LocalizationData.get("PreferencesDialog.Network.port.tooltip"));
            this.proxyPortField.addPropertyChangeListener("VALUE_PROPERTY", this.updateOkListener);
        }
        return this.proxyPortField;
    }

    private JPanel getAuthenticationPanel() {
        if (this.authenticationPanel == null) {
            GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
            gridBagConstraints12.gridx = 2;
            gridBagConstraints12.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints12.gridy = 1;
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.fill = 2;
            gridBagConstraints11.gridy = 1;
            gridBagConstraints11.weightx = 1.0;
            gridBagConstraints11.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints11.gridx = 1;
            GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
            gridBagConstraints10.gridx = 0;
            gridBagConstraints10.anchor = 17;
            gridBagConstraints10.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints10.gridy = 1;
            this.passwordLabel = new JLabel();
            this.passwordLabel.setText(LocalizationData.get("PreferencesDialog.Network.password"));
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.fill = 2;
            gridBagConstraints9.gridy = 0;
            gridBagConstraints9.weightx = 1.0;
            gridBagConstraints9.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints9.gridwidth = 2;
            gridBagConstraints9.gridx = 1;
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.gridx = 0;
            gridBagConstraints8.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints8.anchor = 17;
            gridBagConstraints8.gridy = 0;
            this.userLabel = new JLabel();
            this.userLabel.setText(LocalizationData.get("PreferencesDialog.Network.user"));
            this.authenticationPanel = new JPanel();
            this.authenticationPanel.setLayout(new GridBagLayout());
            this.authenticationPanel.add((Component)this.userLabel, gridBagConstraints8);
            this.authenticationPanel.add((Component)this.getUserField(), gridBagConstraints9);
            this.authenticationPanel.add((Component)this.passwordLabel, gridBagConstraints10);
            this.authenticationPanel.add((Component)this.getPasswordField(), gridBagConstraints11);
            this.authenticationPanel.add((Component)this.getShowPassCheckBox(), gridBagConstraints12);
        }
        return this.authenticationPanel;
    }

    private JTextField getUserField() {
        if (this.userField == null) {
            this.userField = new TextWidget();
            this.userField.setToolTipText(LocalizationData.get("PreferencesDialog.Network.user.toolTip"));
            this.userField.addPropertyChangeListener("text", this.updateOkListener);
        }
        return this.userField;
    }

    private JPasswordField getPasswordField() {
        if (this.passwordField == null) {
            this.passwordField = new PasswordWidget();
            this.passwordField.setToolTipText(LocalizationData.get("PreferencesDialog.Network.password.tooltip"));
            this.passwordField.addPropertyChangeListener("text", this.updateOkListener);
        }
        return this.passwordField;
    }

    public String getProxyHost() {
        String host = this.getProxyHostField().getText().trim();
        if (!this.getProxyButton().isSelected() || host.length() == 0) {
            return null;
        }
        return host;
    }

    public Integer getProxyPort() {
        if (this.getProxyHost() == null) {
            return null;
        }
        if (this.getProxyPortField().getText().trim().length() == 0) {
            return 3128;
        }
        BigInteger port = this.getProxyPortField().getValue();
        if (port.compareTo(new BigInteger(Integer.toString(65535))) > 0) {
            return Integer.MAX_VALUE;
        }
        return port.intValue();
    }

    public String getProxyUser() {
        if (this.getProxyHost() == null) {
            return null;
        }
        String user = this.getUserField().getText().trim();
        return user.length() == 0 ? null : user;
    }

    public String getProxyPassword() {
        if (this.getProxyUser() == null) {
            return null;
        }
        String password = new String(this.getPasswordField().getPassword()).trim();
        return password.length() == 0 ? null : password;
    }

    private JCheckBox getShowPassCheckBox() {
        if (this.showPassCheckBox == null) {
            this.showPassCheckBox = new JCheckBox();
            this.showPassCheckBox.setText(LocalizationData.get("PreferencesDialog.Network.showPassword"));
            this.showPassCheckBox.setToolTipText(LocalizationData.get("PreferencesDialog.Network.showPassword.toolTip"));
            this.showPassCheckBox.addItemListener(new ItemListener(){
                char oldEcho;

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 2) {
                        ProxyPanel.this.passwordField.setEchoChar(this.oldEcho);
                    } else {
                        this.oldEcho = ProxyPanel.this.passwordField.getEchoChar();
                        ProxyPanel.this.passwordField.setEchoChar('\u0000');
                    }
                }
            });
        }
        return this.showPassCheckBox;
    }

    @Override
    public String getTitle() {
        return LocalizationData.get("PreferencesDialog.Network.title");
    }

    @Override
    public String getToolTip() {
        return LocalizationData.get("PreferencesDialog.Network.toolTip");
    }

    @Override
    public boolean updatePreferences() {
        Preferences.INSTANCE.setHttpProxy(this.getProxyHost(), this.getProxyPort(), this.getProxyUser(), this.getProxyPassword());
        return false;
    }
}

