/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.dialogs.preferences;

import com.fathzer.soft.ajlib.swing.FontUtils;
import com.fathzer.soft.ajlib.swing.Utils;
import com.fathzer.soft.ajlib.swing.widget.AbstractSelector;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.Preferences;
import net.yapbam.gui.dialogs.preferences.PreferencePanel;
import net.yapbam.gui.util.LookAndFeelUtils;
import net.yapbam.util.NullUtils;

public class ThemePanel
extends PreferencePanel {
    private static final float MAX_RATIO = 2.5f;
    private static final float MIN_RATIO = 0.75f;
    private static final long serialVersionUID = 1L;
    private String selectedLookAndFeel;
    private String oldSelectedFont;
    private JSlider fontSlider;
    private JPanel fontPanel;
    private JLabel textSampleLabel;
    private JPanel lafPanel;
    private JLabel fontSliderTitle;
    private FontSelector fontSelector;

    public ThemePanel() {
        Font defaultFont = Preferences.INSTANCE.getDefaultFont();
        this.oldSelectedFont = defaultFont == null ? null : defaultFont.getName();
        this.initialize();
    }

    private void initialize() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gbcLafPanel = new GridBagConstraints();
        gbcLafPanel.anchor = 17;
        gbcLafPanel.insets = new Insets(10, 0, 5, 0);
        gbcLafPanel.gridx = 0;
        gbcLafPanel.gridy = 0;
        this.add((Component)this.getLAFPanel(), gbcLafPanel);
        GridBagConstraints gbcFontPanel = new GridBagConstraints();
        gbcFontPanel.weightx = 1.0;
        gbcFontPanel.anchor = 18;
        gbcFontPanel.weighty = 1.0;
        gbcFontPanel.insets = new Insets(10, 0, 0, 0);
        gbcFontPanel.gridx = 0;
        gbcFontPanel.gridy = 1;
        this.add((Component)this.getFontPanel(), gbcFontPanel);
    }

    private void refreshFontPanel() {
        boolean enabled = FontUtils.isDefaultFontSupportedByLookAndFeel(this.selectedLookAndFeel);
        this.getFontSlider().setEnabled(enabled);
        this.getFontSliderTitle().setEnabled(enabled);
        this.getFontSelector().setEnabled(enabled);
        this.getTextSampleLabel().setEnabled(enabled);
        this.getFontSlider().setToolTipText(LocalizationData.get("PreferencesDialog.Theme.fontSize.tooltip." + this.getEnableSuffix(enabled)));
        this.getFontSelector().setToolTipText(LocalizationData.get("PreferencesDialog.Theme.fontSelector.tooltip." + this.getEnableSuffix(enabled)));
    }

    private String getEnableSuffix(boolean enabled) {
        return enabled ? "enabled" : "disabled";
    }

    public String getSelectedLookAndFeel() {
        return this.selectedLookAndFeel;
    }

    @Override
    public String getTitle() {
        return LocalizationData.get("PreferencesDialog.Theme.title");
    }

    @Override
    public String getToolTip() {
        return LocalizationData.get("PreferencesDialog.Theme.toolTip");
    }

    private String getSelectedFont() {
        return this.getFontSelector().isEnabled() ? (String)this.getFontSelector().get() : null;
    }

    @Override
    public boolean updatePreferences() {
        int current;
        int defaultSize;
        int old;
        boolean fontSizeChanged;
        boolean fontChanged;
        boolean lfChanged;
        boolean bl = lfChanged = !this.selectedLookAndFeel.equals(Preferences.INSTANCE.getLookAndFeel());
        if (lfChanged) {
            Preferences.INSTANCE.setLookAndFeel(this.selectedLookAndFeel);
        }
        boolean bl2 = fontChanged = !NullUtils.areEquals(this.getSelectedFont(), this.oldSelectedFont);
        if (fontChanged) {
            Preferences.INSTANCE.setDefaultFont(this.getSelectedFont());
        }
        boolean bl3 = fontSizeChanged = (old = (int)((float)(defaultSize = this.getDefaultFont().getSize()) * Preferences.INSTANCE.getFontSizeRatio())) != (current = this.getFontSlider().getValue());
        if (fontSizeChanged) {
            Preferences.INSTANCE.setFontSizeRatio((float)current / (float)defaultSize);
        }
        return lfChanged || fontSizeChanged || fontChanged;
    }

    private JSlider getFontSlider() {
        if (this.fontSlider == null) {
            Font dummy;
            Font defaultFont = dummy = this.getDefaultFont();
            int defaultSize = defaultFont.getSize();
            int min = (int)((float)defaultSize * 0.75f);
            int max = (int)(2.5f * (float)defaultSize);
            int current = this.getTextSampleLabel().getFont().getSize();
            if (current < min) {
                current = min;
            } else if (current > max) {
                current = max;
            }
            this.fontSlider = new JSlider(min, max, current);
            this.fontSlider.setMajorTickSpacing(5);
            this.fontSlider.setMinorTickSpacing(1);
            this.fontSlider.setPaintLabels(true);
            this.fontSlider.setPaintTicks(true);
            this.refreshFontPanel();
            this.fontSlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (!ThemePanel.this.fontSlider.getValueIsAdjusting()) {
                        ThemePanel.this.refreshSampleText();
                    }
                }
            });
        }
        return this.fontSlider;
    }

    private void refreshSampleText() {
        this.getTextSampleLabel().setFont(this.getDefaultFont().deriveFont((float)this.fontSlider.getValue()));
    }

    private Font getDefaultFont() {
        Font result;
        Font font = result = this.getSelectedFont() != null ? new Font(this.getSelectedFont(), 0, 12) : Preferences.INSTANCE.getDefaultFont();
        if (result == null) {
            LookAndFeel current = UIManager.getLookAndFeel();
            try {
                UIManager.setLookAndFeel(Utils.getLFClassFromName(this.selectedLookAndFeel));
                result = new JLabel().getFont();
                UIManager.setLookAndFeel(current);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    private JPanel getFontPanel() {
        if (this.fontPanel == null) {
            this.fontPanel = new JPanel();
            this.fontPanel.setBorder(BorderFactory.createTitledBorder(LocalizationData.get("PreferencesDialog.Theme.font")));
            GridBagLayout gblFontPanel = new GridBagLayout();
            this.fontPanel.setLayout(gblFontPanel);
            GridBagConstraints gbcFontSelector = new GridBagConstraints();
            gbcFontSelector.anchor = 17;
            gbcFontSelector.insets = new Insets(0, 0, 5, 0);
            gbcFontSelector.gridx = 0;
            gbcFontSelector.gridy = 0;
            this.fontPanel.add((Component)this.getFontSelector(), gbcFontSelector);
            GridBagConstraints gbcFontSliderTitle = new GridBagConstraints();
            gbcFontSliderTitle.anchor = 17;
            gbcFontSliderTitle.insets = new Insets(0, 0, 5, 0);
            gbcFontSliderTitle.gridx = 0;
            gbcFontSliderTitle.gridy = 1;
            this.fontPanel.add((Component)this.getFontSliderTitle(), gbcFontSliderTitle);
            GridBagConstraints gbcFontSlider = new GridBagConstraints();
            gbcFontSlider.insets = new Insets(0, 0, 5, 0);
            gbcFontSlider.weighty = 1.0;
            gbcFontSlider.weightx = 1.0;
            gbcFontSlider.fill = 2;
            gbcFontSlider.anchor = 18;
            gbcFontSlider.gridx = 0;
            gbcFontSlider.gridy = 2;
            this.fontPanel.add((Component)this.getFontSlider(), gbcFontSlider);
            GridBagConstraints gbcTextSampleLabel = new GridBagConstraints();
            gbcTextSampleLabel.anchor = 17;
            gbcTextSampleLabel.gridx = 0;
            gbcTextSampleLabel.gridy = 3;
            this.fontPanel.add((Component)this.getTextSampleLabel(), gbcTextSampleLabel);
        }
        return this.fontPanel;
    }

    private JLabel getTextSampleLabel() {
        if (this.textSampleLabel == null) {
            this.textSampleLabel = new JLabel(LocalizationData.get("PreferencesDialog.Theme.textSample"));
        }
        return this.textSampleLabel;
    }

    private JPanel getLAFPanel() {
        if (this.lafPanel == null) {
            this.lafPanel = new JPanel();
            this.lafPanel.setBorder(BorderFactory.createTitledBorder(LocalizationData.get("PreferencesDialog.Theme.theme")));
            String current = UIManager.getLookAndFeel().getClass().getName();
            UIManager.LookAndFeelInfo[] lfs = UIManager.getInstalledLookAndFeels();
            this.lafPanel.setLayout(new GridLayout(lfs.length, 1));
            ButtonGroup group = new ButtonGroup();
            int index = 0;
            for (int i = 0; i < lfs.length; ++i) {
                String name = lfs[i].getName();
                if (!LookAndFeelUtils.isValid(name)) continue;
                JRadioButton button = new JRadioButton(name);
                if (lfs[i].getClassName().equals(current)) {
                    button.setSelected(true);
                    this.selectedLookAndFeel = lfs[i].getName();
                }
                button.addItemListener(new LFAction(lfs[i].getName()));
                if ("nimbus".equalsIgnoreCase(lfs[i].getName())) {
                    button.setText(lfs[i].getName() + " " + LocalizationData.get("generic.recommended.with.parenthesis"));
                }
                group.add(button);
                this.lafPanel.add((Component)button, index);
                ++index;
            }
        }
        return this.lafPanel;
    }

    private JLabel getFontSliderTitle() {
        if (this.fontSliderTitle == null) {
            this.fontSliderTitle = new JLabel(LocalizationData.get("PreferencesDialog.Theme.fontSize"));
        }
        return this.fontSliderTitle;
    }

    private FontSelector getFontSelector() {
        if (this.fontSelector == null) {
            this.fontSelector = new FontSelector();
            Font defaultFont = Preferences.INSTANCE.getDefaultFont();
            if (defaultFont != null) {
                this.getFontSelector().set(defaultFont.getFontName());
            }
            this.fontSelector.addPropertyChangeListener(this.fontSelector.getPropertyName(), new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    ThemePanel.this.refreshSampleText();
                }
            });
        }
        return this.fontSelector;
    }

    private class FontSelector
    extends AbstractSelector<String, Void> {
        private static final long serialVersionUID = 1L;

        public FontSelector() {
            super(null);
        }

        @Override
        protected void populateCombo() {
            if (FontUtils.isDefaultFontSupportedByLookAndFeel(ThemePanel.this.selectedLookAndFeel)) {
                for (Font f : FontUtils.getAvailableTextFonts(this.getLocale())) {
                    this.getCombo().addItem(f.getFontName());
                }
            }
        }

        @Override
        protected String getLabel() {
            return LocalizationData.get("PreferencesDialog.Theme.fontName");
        }

        @Override
        protected String createNew() {
            return null;
        }

        @Override
        protected String getPropertyName() {
            return "SelectedFont";
        }

        @Override
        protected boolean isNewButtonVisible() {
            return false;
        }

        @Override
        protected Component getCustomizedRenderer(Component renderer, String value, int index, boolean isSelected, boolean cellHasFocus) {
            renderer.setFont(new Font(value, 0, 12));
            renderer.setEnabled(this.isEnabled());
            return renderer;
        }
    }

    private class LFAction
    implements ItemListener {
        String name;

        LFAction(String className) {
            this.name = className;
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                ThemePanel.this.selectedLookAndFeel = this.name;
                ThemePanel.this.refreshFontPanel();
            }
        }
    }
}

