/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.dialogs.preferences;

import com.fathzer.jlocal.Formatter;
import com.fathzer.soft.ajlib.swing.widget.TextWidget;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.Preferences;
import net.yapbam.gui.dialogs.preferences.EditionWizardPanel;
import net.yapbam.gui.dialogs.preferences.PreferencePanel;
import net.yapbam.gui.preferences.EditingSettings;
import net.yapbam.gui.preferences.EditionWizardSettings;

public class TransactionEditingPanel
extends PreferencePanel {
    private static final SimpleDateFormat SHORT_FORMAT = new SimpleDateFormat("yyMM", LocalizationData.getLocale());
    private static final SimpleDateFormat LONG_FORMAT = new SimpleDateFormat("MMMM yyyy", LocalizationData.getLocale());
    private JCheckBox chckbxAutoFillStatement;
    private JRadioButton rdbtnShortStyle;
    private JRadioButton rdbtnLongStyle;
    private JRadioButton rdbtnBasedOnDate;
    private JRadioButton rdbtnBasedOnValue;
    private JCheckBox chckbxAskMeOnDelete;
    private JCheckBox chckbxAlertMeIf;
    private JRadioButton rdbtnCustomized;
    private JTextField formatPatternField;
    private JLabel labelExample;
    private JRadioButton rdbtnDupDateCurrent;
    private JRadioButton rdbtnDupDateOriginal;
    private JSeparator separator2;
    private EditionWizardPanel panel2;

    public TransactionEditingPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        this.chckbxAlertMeIf = new JCheckBox(LocalizationData.get("TransactionEditingPreferencesPanel.alertIfChangeChecked"));
        this.chckbxAlertMeIf.setToolTipText(LocalizationData.get("TransactionEditingPreferencesPanel.alertIfChangeChecked.tooltip"));
        GridBagConstraints gbcChckbxAlertMeIf = new GridBagConstraints();
        gbcChckbxAlertMeIf.insets = new Insets(10, 0, 5, 0);
        gbcChckbxAlertMeIf.anchor = 17;
        gbcChckbxAlertMeIf.gridx = 0;
        gbcChckbxAlertMeIf.gridy = 0;
        this.add((Component)this.chckbxAlertMeIf, gbcChckbxAlertMeIf);
        this.chckbxAskMeOnDelete = new JCheckBox(LocalizationData.get("TransactionEditingPreferencesPanel.alertIfDelete"));
        this.chckbxAskMeOnDelete.setToolTipText(LocalizationData.get("TransactionEditingPreferencesPanel.alertIfDelete.tooltip"));
        GridBagConstraints gbcChckbxAskMeOnDelete = new GridBagConstraints();
        gbcChckbxAskMeOnDelete.anchor = 17;
        gbcChckbxAskMeOnDelete.insets = new Insets(0, 0, 5, 0);
        gbcChckbxAskMeOnDelete.gridx = 0;
        gbcChckbxAskMeOnDelete.gridy = 1;
        this.add((Component)this.chckbxAskMeOnDelete, gbcChckbxAskMeOnDelete);
        JSeparator separator = new JSeparator();
        GridBagConstraints gbcSeparator = new GridBagConstraints();
        gbcSeparator.weightx = 1.0;
        gbcSeparator.fill = 1;
        gbcSeparator.insets = new Insets(5, 50, 10, 50);
        gbcSeparator.gridx = 0;
        gbcSeparator.gridy = 2;
        this.add((Component)separator, gbcSeparator);
        JPanel panel1 = new JPanel();
        GridBagConstraints gbcPanel1 = new GridBagConstraints();
        gbcPanel1.insets = new Insets(0, 0, 5, 0);
        gbcPanel1.fill = 1;
        gbcPanel1.gridx = 0;
        gbcPanel1.gridy = 3;
        this.add((Component)panel1, gbcPanel1);
        GridBagLayout gblPanel1 = new GridBagLayout();
        panel1.setLayout(gblPanel1);
        JLabel lblWhen = new JLabel(LocalizationData.get("TransactionEditingPreferencesPanel.duplicateTransaction.title"));
        GridBagConstraints gbcLblWhen = new GridBagConstraints();
        gbcLblWhen.anchor = 17;
        gbcLblWhen.gridheight = 0;
        gbcLblWhen.insets = new Insets(0, 5, 0, 5);
        gbcLblWhen.weighty = 1.0;
        gbcLblWhen.fill = 3;
        gbcLblWhen.gridx = 0;
        gbcLblWhen.gridy = 0;
        panel1.add((Component)lblWhen, gbcLblWhen);
        this.rdbtnDupDateCurrent = new JRadioButton(LocalizationData.get("TransactionEditingPreferencesPanel.duplicateTransaction.setDateToCurrent"));
        this.rdbtnDupDateCurrent.setToolTipText(LocalizationData.get("TransactionEditingPreferencesPanel.duplicateTransaction.setDateToCurrent.tooltip"));
        GridBagConstraints gbcRdbtnDupDateCurrent = new GridBagConstraints();
        gbcRdbtnDupDateCurrent.weightx = 1.0;
        gbcRdbtnDupDateCurrent.anchor = 17;
        gbcRdbtnDupDateCurrent.gridx = 1;
        gbcRdbtnDupDateCurrent.gridy = 0;
        panel1.add((Component)this.rdbtnDupDateCurrent, gbcRdbtnDupDateCurrent);
        this.rdbtnDupDateOriginal = new JRadioButton(LocalizationData.get("TransactionEditingPreferencesPanel.duplicateTransaction.keepOriginalDate"));
        this.rdbtnDupDateOriginal.setToolTipText(LocalizationData.get("TransactionEditingPreferencesPanel.duplicateTransaction.keepOriginalDate.tooltip"));
        GridBagConstraints gbcRdbtnDupDateOriginal = new GridBagConstraints();
        gbcRdbtnDupDateOriginal.anchor = 17;
        gbcRdbtnDupDateOriginal.gridx = 1;
        gbcRdbtnDupDateOriginal.gridy = 1;
        panel1.add((Component)this.rdbtnDupDateOriginal, gbcRdbtnDupDateOriginal);
        ButtonGroup gpDuplicate = new ButtonGroup();
        gpDuplicate.add(this.rdbtnDupDateCurrent);
        gpDuplicate.add(this.rdbtnDupDateOriginal);
        JSeparator separator1 = new JSeparator();
        GridBagConstraints gbcSeparator1 = new GridBagConstraints();
        gbcSeparator1.fill = 1;
        gbcSeparator1.insets = new Insets(5, 50, 10, 50);
        gbcSeparator1.gridx = 0;
        gbcSeparator1.gridy = 4;
        this.add((Component)separator1, gbcSeparator1);
        JPanel panel = new JPanel();
        GridBagConstraints gbcPanel = new GridBagConstraints();
        gbcPanel.insets = new Insets(0, 0, 5, 0);
        gbcPanel.anchor = 18;
        gbcPanel.weightx = 1.0;
        gbcPanel.gridx = 0;
        gbcPanel.gridy = 6;
        this.add((Component)panel, gbcPanel);
        GridBagLayout gblPanel = new GridBagLayout();
        panel.setLayout(gblPanel);
        this.chckbxAutoFillStatement = new JCheckBox(LocalizationData.get("TransactionEditingPreferencesPanel.autoFillStatementId"));
        this.chckbxAutoFillStatement.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean selected = e.getStateChange() == 1;
                TransactionEditingPanel.this.rdbtnBasedOnDate.setEnabled(selected);
                TransactionEditingPanel.this.rdbtnBasedOnValue.setEnabled(selected);
                TransactionEditingPanel.this.rdbtnLongStyle.setEnabled(selected);
                TransactionEditingPanel.this.rdbtnShortStyle.setEnabled(selected);
                TransactionEditingPanel.this.rdbtnCustomized.setEnabled(selected);
                TransactionEditingPanel.this.formatPatternField.setEnabled(selected);
                TransactionEditingPanel.this.labelExample.setEnabled(selected);
                TransactionEditingPanel.this.rdbtnShortStyle.setToolTipText(selected ? LocalizationData.get("TransactionEditingPreferencesPanel.format.short.tooltip") : "");
                TransactionEditingPanel.this.rdbtnLongStyle.setToolTipText(selected ? LocalizationData.get("TransactionEditingPreferencesPanel.format.long.tooltip") : "");
                TransactionEditingPanel.this.rdbtnCustomized.setToolTipText(selected ? LocalizationData.get("TransactionEditingPreferencesPanel.format.customized.tooltip") : "");
                TransactionEditingPanel.this.formatPatternField.setToolTipText(selected ? LocalizationData.get("TransactionEditingPreferencesPanel.format.customizedField.tooltip") : "");
                TransactionEditingPanel.this.rdbtnBasedOnDate.setToolTipText(selected ? LocalizationData.get("TransactionEditingPreferencesPanel.statementBasedOnDate.tooltip") : "");
                TransactionEditingPanel.this.rdbtnBasedOnValue.setToolTipText(selected ? LocalizationData.get("TransactionEditingPreferencesPanel.statementBasedOnValueDate.tooltip") : "");
            }
        });
        GridBagConstraints gbcChckbxAutoFillStatement = new GridBagConstraints();
        gbcChckbxAutoFillStatement.insets = new Insets(0, 0, 5, 0);
        gbcChckbxAutoFillStatement.anchor = 17;
        gbcChckbxAutoFillStatement.gridx = 0;
        gbcChckbxAutoFillStatement.gridy = 5;
        this.add((Component)this.chckbxAutoFillStatement, gbcChckbxAutoFillStatement);
        this.chckbxAutoFillStatement.setToolTipText(LocalizationData.get("TransactionEditingPreferencesPanel.autoFillStatementId.tooltip"));
        ItemListener itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                TransactionEditingPanel.this.updateOkDisabledCause();
            }
        };
        this.chckbxAutoFillStatement.addItemListener(itemListener);
        JPanel panelFormat = new JPanel();
        panelFormat.setBorder(BorderFactory.createTitledBorder(null, LocalizationData.get("TransactionEditingPreferencesPanel.format.title"), 0, 0));
        GridBagConstraints gbcPanelFormat = new GridBagConstraints();
        gbcPanelFormat.anchor = 18;
        gbcPanelFormat.weightx = 1.0;
        gbcPanelFormat.insets = new Insets(0, 10, 0, 0);
        gbcPanelFormat.weighty = 1.0;
        gbcPanelFormat.gridheight = 0;
        gbcPanelFormat.gridx = 1;
        gbcPanelFormat.gridy = 0;
        panel.add((Component)panelFormat, gbcPanelFormat);
        panelFormat.setLayout(new GridBagLayout());
        Date date = this.getSampleDate();
        EditingSettings dummySettings = new EditingSettings(true, true, true, true, true, SHORT_FORMAT, new EditionWizardSettings(EditionWizardSettings.Mode.NEVER, EditionWizardSettings.Source.LAST));
        this.rdbtnShortStyle = new JRadioButton(Formatter.format(LocalizationData.get("TransactionEditingPreferencesPanel.format.short"), dummySettings.getStatementId(date)));
        this.rdbtnShortStyle.setEnabled(false);
        this.rdbtnShortStyle.addItemListener(itemListener);
        GridBagConstraints gbcRdbtnShortStyle = new GridBagConstraints();
        gbcRdbtnShortStyle.gridwidth = 0;
        gbcRdbtnShortStyle.insets = new Insets(0, 0, 5, 0);
        gbcRdbtnShortStyle.anchor = 17;
        gbcRdbtnShortStyle.gridx = 0;
        gbcRdbtnShortStyle.gridy = 0;
        panelFormat.add((Component)this.rdbtnShortStyle, gbcRdbtnShortStyle);
        dummySettings.setStatementDateFormat(LONG_FORMAT);
        this.rdbtnLongStyle = new JRadioButton(Formatter.format(LocalizationData.get("TransactionEditingPreferencesPanel.format.long"), dummySettings.getStatementId(date)));
        this.rdbtnLongStyle.setEnabled(false);
        this.rdbtnLongStyle.addItemListener(itemListener);
        GridBagConstraints gbcRdbtnLongStyle = new GridBagConstraints();
        gbcRdbtnLongStyle.gridwidth = 0;
        gbcRdbtnLongStyle.insets = new Insets(0, 0, 5, 0);
        gbcRdbtnLongStyle.anchor = 17;
        gbcRdbtnLongStyle.gridx = 0;
        gbcRdbtnLongStyle.gridy = 1;
        panelFormat.add((Component)this.rdbtnLongStyle, gbcRdbtnLongStyle);
        this.rdbtnCustomized = new JRadioButton(LocalizationData.get("TransactionEditingPreferencesPanel.format.customized"));
        this.rdbtnCustomized.setEnabled(false);
        this.rdbtnCustomized.addItemListener(itemListener);
        GridBagConstraints gbcRdbtnCustomized = new GridBagConstraints();
        gbcRdbtnCustomized.insets = new Insets(0, 0, 0, 5);
        gbcRdbtnCustomized.anchor = 17;
        gbcRdbtnCustomized.gridx = 0;
        gbcRdbtnCustomized.gridy = 2;
        panelFormat.add((Component)this.rdbtnCustomized, gbcRdbtnCustomized);
        this.rdbtnBasedOnDate = new JRadioButton(LocalizationData.get("TransactionEditingPreferencesPanel.statementBasedOnDate"));
        this.rdbtnBasedOnDate.setVerticalAlignment(1);
        this.rdbtnBasedOnDate.setEnabled(false);
        GridBagConstraints gbcRdbtnBasedOnDate = new GridBagConstraints();
        gbcRdbtnBasedOnDate.weighty = 1.0;
        gbcRdbtnBasedOnDate.fill = 1;
        gbcRdbtnBasedOnDate.insets = new Insets(0, 20, 0, 0);
        gbcRdbtnBasedOnDate.anchor = 18;
        gbcRdbtnBasedOnDate.gridx = 0;
        gbcRdbtnBasedOnDate.gridy = 1;
        panel.add((Component)this.rdbtnBasedOnDate, gbcRdbtnBasedOnDate);
        this.rdbtnBasedOnValue = new JRadioButton(LocalizationData.get("TransactionEditingPreferencesPanel.statementBasedOnValueDate"));
        this.rdbtnBasedOnValue.setVerticalAlignment(3);
        this.rdbtnBasedOnValue.setEnabled(false);
        GridBagConstraints gbcRdbtnBasedOnValue = new GridBagConstraints();
        gbcRdbtnBasedOnValue.fill = 1;
        gbcRdbtnBasedOnValue.weighty = 1.0;
        gbcRdbtnBasedOnValue.insets = new Insets(0, 20, 0, 0);
        gbcRdbtnBasedOnValue.anchor = 16;
        gbcRdbtnBasedOnValue.gridx = 0;
        gbcRdbtnBasedOnValue.gridy = 0;
        panel.add((Component)this.rdbtnBasedOnValue, gbcRdbtnBasedOnValue);
        ButtonGroup gp = new ButtonGroup();
        gp.add(this.rdbtnLongStyle);
        gp.add(this.rdbtnShortStyle);
        gp.add(this.rdbtnCustomized);
        this.formatPatternField = new TextWidget();
        this.formatPatternField.setEnabled(false);
        GridBagConstraints gbcFormatPatternField = new GridBagConstraints();
        gbcFormatPatternField.insets = new Insets(0, 0, 5, 0);
        gbcFormatPatternField.fill = 2;
        gbcFormatPatternField.gridx = 1;
        gbcFormatPatternField.gridy = 2;
        panelFormat.add((Component)this.formatPatternField, gbcFormatPatternField);
        this.formatPatternField.setColumns(10);
        this.formatPatternField.addPropertyChangeListener("text", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                TransactionEditingPanel.this.rdbtnCustomized.setSelected(true);
                TransactionEditingPanel.this.updateOkDisabledCause();
            }
        });
        this.labelExample = new JLabel(LocalizationData.get("TransactionEditingPreferencesPanel.format.customized.invalidFormat"));
        this.labelExample.setEnabled(false);
        GridBagConstraints gbcLabelExample = new GridBagConstraints();
        gbcLabelExample.insets = new Insets(0, 5, 0, 5);
        gbcLabelExample.gridx = 2;
        gbcLabelExample.gridy = 2;
        panelFormat.add((Component)this.labelExample, gbcLabelExample);
        ButtonGroup gp2 = new ButtonGroup();
        gp2.add(this.rdbtnBasedOnDate);
        gp2.add(this.rdbtnBasedOnValue);
        this.separator2 = new JSeparator();
        GridBagConstraints gbcSeparator2 = new GridBagConstraints();
        gbcSeparator2.fill = 1;
        gbcSeparator2.insets = new Insets(5, 50, 10, 50);
        gbcSeparator2.gridx = 0;
        gbcSeparator2.gridy = 7;
        this.add((Component)this.separator2, gbcSeparator2);
        this.panel2 = new EditionWizardPanel();
        GridBagConstraints gbcPanel2 = new GridBagConstraints();
        gbcPanel2.anchor = 18;
        gbcPanel2.weighty = 1.0;
        gbcPanel2.gridx = 0;
        gbcPanel2.gridy = 8;
        this.add((Component)this.panel2, gbcPanel2);
        this.initFromPreferences();
    }

    private Date getSampleDate() {
        Date date = new GregorianCalendar(new GregorianCalendar().get(1), 1, 1).getTime();
        return date;
    }

    private void updateOkDisabledCause() {
        if (!this.rdbtnCustomized.isSelected() || !this.chckbxAutoFillStatement.isSelected()) {
            this.setOkDisabledCause(null);
        } else {
            SimpleDateFormat format = null;
            try {
                format = new SimpleDateFormat(this.formatPatternField.getText(), LocalizationData.getLocale());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (format == null || format.toPattern().length() == 0) {
                this.labelExample.setText(LocalizationData.get("TransactionEditingPreferencesPanel.format.customized.invalidFormat"));
                this.setOkDisabledCause(Formatter.format(LocalizationData.get("TransactionEditingPreferencesPanel.okDisabledCauseFormat"), this.getTitle()));
            } else {
                this.labelExample.setText(Formatter.format(LocalizationData.get("TransactionEditingPreferencesPanel.format.customized.sample"), format.format(this.getSampleDate())));
                this.setOkDisabledCause(null);
            }
        }
    }

    @Override
    public String getTitle() {
        return LocalizationData.get("TransactionEditingPreferencesPanel.title");
    }

    @Override
    public String getToolTip() {
        return LocalizationData.get("TransactionEditingPreferencesPanel.tooltip");
    }

    @Override
    public boolean updatePreferences() {
        SimpleDateFormat format = null;
        SimpleDateFormat simpleDateFormat = format = this.rdbtnLongStyle.isSelected() ? LONG_FORMAT : SHORT_FORMAT;
        if (this.chckbxAutoFillStatement.isSelected() && this.rdbtnCustomized.isSelected()) {
            format = new SimpleDateFormat(this.formatPatternField.getText(), LocalizationData.getLocale());
        }
        Preferences.INSTANCE.setEditingOptions(new EditingSettings(this.chckbxAskMeOnDelete.isSelected(), this.chckbxAlertMeIf.isSelected(), this.rdbtnDupDateCurrent.isSelected(), this.chckbxAutoFillStatement.isSelected(), this.rdbtnBasedOnDate.isSelected(), format, this.panel2.getSettings()));
        return false;
    }

    private void initFromPreferences() {
        EditingSettings editOptions = Preferences.INSTANCE.getEditionSettings();
        this.chckbxAskMeOnDelete.setSelected(editOptions.isAlertOnDelete());
        this.chckbxAlertMeIf.setSelected(editOptions.isAlertOnModifyChecked());
        this.chckbxAutoFillStatement.setSelected(editOptions.isAutoFillStatement());
        (editOptions.isDuplicateTransactionDateToCurrent() ? this.rdbtnDupDateCurrent : this.rdbtnDupDateOriginal).setSelected(true);
        (editOptions.isDateBasedAutoStatement() ? this.rdbtnBasedOnDate : this.rdbtnBasedOnValue).setSelected(true);
        if (editOptions.getStatementDateFormat().equals(LONG_FORMAT)) {
            this.rdbtnLongStyle.setSelected(true);
        } else if (editOptions.getStatementDateFormat().equals(SHORT_FORMAT)) {
            this.rdbtnShortStyle.setSelected(true);
        } else {
            this.rdbtnCustomized.setSelected(true);
            this.formatPatternField.setText(editOptions.getStatementDateFormat().toPattern());
            this.updateOkDisabledCause();
        }
        this.panel2.setSettings(editOptions.getEditionWizardSettings());
    }
}

