/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.dialogs.transaction;

import net.yapbam.data.GlobalData;
import net.yapbam.data.Transaction;
import net.yapbam.gui.Preferences;
import net.yapbam.gui.dialogs.transaction.EditionWizard;
import net.yapbam.gui.preferences.EditionWizardSettings;

public class AmountWizard
extends EditionWizard<Double> {
    private Double lastAmount;
    private int lastDate = 0;
    private EditionWizardSettings.Source source;
    private boolean isReceipt;

    public AmountWizard(GlobalData data, String description, double currentAmount, boolean isReceipt) {
        super(data, description);
        EditionWizardSettings settings = Preferences.INSTANCE.getEditionSettings().getEditionWizardSettings();
        EditionWizardSettings.Mode mode = settings.getMode();
        if (EditionWizardSettings.Mode.WHEN_NULL.equals((Object)mode) && GlobalData.AMOUNT_COMPARATOR.compare(currentAmount, 0.0) != 0) {
            mode = EditionWizardSettings.Mode.NEVER;
        }
        this.source = EditionWizardSettings.Mode.NEVER.equals((Object)mode) ? null : settings.getSource();
        this.isReceipt = isReceipt;
    }

    @Override
    protected Double getValue(Transaction transaction) {
        if (this.source == null || this.isReceipt != transaction.getAmount() > 0.0) {
            return null;
        }
        if (EditionWizardSettings.Source.MOST_PROBABLE.equals((Object)this.source)) {
            return transaction.getAmount();
        }
        if (this.lastDate < transaction.getDateAsInteger()) {
            this.lastAmount = transaction.getAmount();
        }
        return null;
    }

    @Override
    public Double get() {
        if (this.source == null) {
            return null;
        }
        Double mostPropable = (Double)super.get();
        return EditionWizardSettings.Source.MOST_PROBABLE.equals((Object)this.source) ? mostPropable : this.lastAmount;
    }
}

