/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.recent;

import java.net.URI;
import java.util.ArrayList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import net.yapbam.data.FilteredData;
import net.yapbam.data.GlobalData;
import net.yapbam.data.event.DataEvent;
import net.yapbam.data.event.DataListener;
import net.yapbam.data.event.EverythingChangedEvent;
import net.yapbam.data.event.URIChangedEvent;
import net.yapbam.gui.AbstractPlugIn;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.YapbamState;
import net.yapbam.gui.recent.RecentFileAction;

public class RecentFilesPlugin
extends AbstractPlugIn {
    private URI lastURI = null;
    private GlobalData data;
    private ArrayList<URI> latest;
    private JMenuItem menu;

    public RecentFilesPlugin(FilteredData data, Object restart) {
        this.data = data.getGlobalData();
        this.latest = new ArrayList();
        this.menu = new JMenu(LocalizationData.get("RecentFiles.title"));
        this.menu.setToolTipText(LocalizationData.get("RecentFiles.tooltip"));
        this.menu.setEnabled(false);
        this.data.addListener(new DataListener(){

            @Override
            public void processEvent(DataEvent event) {
                if (event instanceof URIChangedEvent || event instanceof EverythingChangedEvent) {
                    RecentFilesPlugin.this.updateMenu();
                }
            }
        });
    }

    private void updateMenu() {
        URI currentUri = this.data.getURI();
        if (currentUri != null && !currentUri.equals(this.lastURI) && this.isValid(currentUri)) {
            this.latest.remove(currentUri);
            this.latest.add(0, currentUri);
            while (this.latest.size() > this.getSizeLimit() + 1) {
                this.latest.remove(this.latest.size() - 1);
            }
        }
        this.menu.removeAll();
        boolean empty = true;
        for (URI uri : this.latest) {
            if (uri.equals(currentUri)) continue;
            this.menu.add(new JMenuItem(new RecentFileAction(this, uri, this.data)));
            empty = false;
        }
        this.menu.setEnabled(!empty);
    }

    private boolean isValid(URI uri) {
        return !uri.getScheme().equals("classpath");
    }

    private int getSizeLimit() {
        return 5;
    }

    @Override
    public JMenuItem[] getMenuItem(int part) {
        if (part == 1) {
            return new JMenuItem[]{this.menu};
        }
        return super.getMenuItem(part);
    }

    @Override
    public void saveState() {
        YapbamState.INSTANCE.save(this.getStateKey(), this.latest);
    }

    private String getStateKey() {
        return this.getClass().getCanonicalName() + ".data";
    }

    @Override
    public void restoreState() {
        ArrayList obj = (ArrayList)YapbamState.INSTANCE.restore(this.getStateKey());
        if (obj != null) {
            this.latest = obj;
            this.updateMenu();
        }
    }

    public void remove(URI uri) {
        this.latest.remove(uri);
        this.updateMenu();
    }
}

