/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.statementview;

import com.fathzer.soft.ajlib.swing.widget.date.DateWidget;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Date;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.widget.AutoSelectFocusListener;

public class CheckModePanel
extends JPanel {
    public static final String IS_OK_PROPERTY = "isOk";
    private static final long serialVersionUID = 1L;
    private JCheckBox valueDateLabel;
    private DateWidget valueDate;
    private JCheckBox checkModeBox;
    private boolean ok;

    public CheckModePanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        this.checkModeBox = new JCheckBox(LocalizationData.get("CheckModePanel.title"));
        this.checkModeBox.setToolTipText(LocalizationData.get("CheckModePanel.title.tooltip"));
        this.checkModeBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                CheckModePanel.this.refresh();
            }
        });
        GridBagConstraints gbcCheckModeBox = new GridBagConstraints();
        gbcCheckModeBox.anchor = 17;
        gbcCheckModeBox.insets = new Insets(0, 0, 0, 5);
        gbcCheckModeBox.gridx = 0;
        gbcCheckModeBox.gridy = 0;
        this.add((Component)this.checkModeBox, gbcCheckModeBox);
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbcPanel = new GridBagConstraints();
        gbcPanel.gridwidth = 0;
        gbcPanel.insets = new Insets(0, 0, 0, 5);
        gbcPanel.anchor = 11;
        gbcPanel.fill = 2;
        gbcPanel.gridx = 0;
        gbcPanel.gridy = 1;
        this.add((Component)panel, gbcPanel);
        this.valueDateLabel = new JCheckBox(LocalizationData.get("CheckModePanel.valueDateEnabled"));
        GridBagConstraints gbcValueDateLabel = new GridBagConstraints();
        gbcValueDateLabel.anchor = 17;
        gbcValueDateLabel.insets = new Insets(0, 0, 0, 5);
        gbcValueDateLabel.gridx = 0;
        gbcValueDateLabel.gridy = 0;
        panel.add((Component)this.valueDateLabel, gbcValueDateLabel);
        this.valueDateLabel.setToolTipText(LocalizationData.get("CheckModePanel.valueDateEnabled.toolTip"));
        this.valueDate = new DateWidget();
        this.valueDate.getDateField().setMinimumSize(this.valueDate.getDateField().getPreferredSize());
        GridBagConstraints gbcValueDate = new GridBagConstraints();
        gbcValueDate.gridx = 1;
        gbcValueDate.gridy = 0;
        panel.add((Component)this.valueDate, gbcValueDate);
        this.valueDate.setDate(null);
        this.valueDate.setLocale(LocalizationData.getLocale());
        this.valueDate.setToolTipText(LocalizationData.get("CheckModePanel.valueDate.tooltip"));
        this.valueDate.addPropertyChangeListener("date", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                CheckModePanel.this.valueDateLabel.setSelected(true);
                CheckModePanel.this.refreshOk();
            }
        });
        this.valueDate.getDateField().addFocusListener(AutoSelectFocusListener.INSTANCE);
        this.valueDateLabel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                CheckModePanel.this.refreshOk();
            }
        });
        this.refresh();
    }

    private void refresh() {
        boolean selected = this.checkModeBox.isSelected();
        this.valueDateLabel.setVisible(selected);
        this.valueDate.setVisible(selected);
        this.refreshOk();
    }

    private void refreshOk() {
        boolean old = this.ok;
        if (this.isVisible()) {
            boolean selected = this.checkModeBox.isSelected();
            boolean dateOk = !this.valueDateLabel.isSelected() || this.valueDate.getDate() != null;
            this.valueDateLabel.setForeground(!selected || dateOk ? Color.black : Color.red);
            this.ok = selected && dateOk;
        } else {
            this.ok = false;
        }
        if (old != this.ok) {
            this.firePropertyChange(IS_OK_PROPERTY, old, this.ok);
        }
    }

    public boolean isSelected() {
        return this.checkModeBox.isSelected();
    }

    public void setSelected(boolean selected) {
        this.checkModeBox.setSelected(selected);
    }

    public Date getValueDate() {
        return this.valueDateLabel.isSelected() ? this.valueDate.getDate() : null;
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.refreshOk();
    }

    public boolean isOk() {
        return this.ok;
    }
}

