/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.statistics;

import java.awt.Color;
import java.awt.GradientPaint;
import java.util.Map;
import net.yapbam.data.Category;
import net.yapbam.data.GlobalData;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.statistics.Summary;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.data.category.DefaultCategoryDataset;

class BarChartPanel
extends ChartPanel {
    private DefaultCategoryDataset dataset;
    private Map<Category, Summary> categoryToAmount;
    private boolean netValues;

    BarChartPanel(Map<Category, Summary> map) {
        super((JFreeChart)null);
        super.setPopupMenu(this.createPopupMenu(true, false, false, true, false));
        this.netValues = false;
        this.categoryToAmount = map;
        this.dataset = new DefaultCategoryDataset();
        this.updateDataSet();
        JFreeChart chart = ChartFactory.createStackedBarChart(LocalizationData.get("StatisticsPlugin.bar.title"), null, null, this.dataset, PlotOrientation.VERTICAL, true, true, false);
        CategoryPlot plot = (CategoryPlot)chart.getPlot();
        plot.setNoDataMessage(LocalizationData.get("StatisticsPlugin.bar.empty"));
        BarRenderer renderer = (BarRenderer)plot.getRenderer();
        renderer.setDrawBarOutline(false);
        GradientPaint gp0 = new GradientPaint(0.0f, 0.0f, Color.green, 0.0f, 0.0f, new Color(0, 64, 0));
        GradientPaint gp1 = new GradientPaint(0.0f, 0.0f, Color.red, 0.0f, 0.0f, new Color(64, 0, 0));
        renderer.setSeriesPaint(0, gp0);
        renderer.setSeriesPaint(1, gp1);
        CategoryAxis domainAxis = plot.getDomainAxis();
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.createUpRotationLabelPositions(0.5235987755982988));
        this.setChart(chart);
    }

    void updateDataSet() {
        this.dataset.clear();
        for (Category category : this.categoryToAmount.keySet()) {
            String title;
            Summary summary = this.categoryToAmount.get(category);
            String string = title = category.equals(Category.UNDEFINED) ? LocalizationData.get("Category.undefined") : category.getName();
            if (this.netValues) {
                double balance = summary.getReceipts() + summary.getDebts();
                if (GlobalData.AMOUNT_COMPARATOR.compare(balance, 0.0) == 0) continue;
                this.dataset.addValue(balance > 0.0 ? balance : 0.0, (Comparable)((Object)LocalizationData.get("StatisticsPlugin.bar.receipt")), (Comparable)((Object)title));
                this.dataset.addValue(balance > 0.0 ? 0.0 : balance, (Comparable)((Object)LocalizationData.get("StatisticsPlugin.bar.debts")), (Comparable)((Object)title));
                continue;
            }
            if (GlobalData.AMOUNT_COMPARATOR.compare(summary.getReceipts(), 0.0) == 0 && GlobalData.AMOUNT_COMPARATOR.compare(summary.getDebts(), 0.0) == 0) continue;
            this.dataset.addValue(summary.getReceipts(), (Comparable)((Object)LocalizationData.get("StatisticsPlugin.bar.receipt")), (Comparable)((Object)title));
            this.dataset.addValue(summary.getDebts(), (Comparable)((Object)LocalizationData.get("StatisticsPlugin.bar.debts")), (Comparable)((Object)title));
        }
    }

    public void setNetValues(boolean netValues) {
        this.netValues = netValues;
        this.updateDataSet();
        ((CategoryPlot)this.getChart().getPlot()).getRenderer();
    }
}

