/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.tools.currencyconverter;

import com.fathzer.jlocal.Formatter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import net.yapbam.currency.AbstractCurrencyConverter;
import net.yapbam.gui.IconManager;
import net.yapbam.gui.tools.Messages;
import net.yapbam.gui.tools.currencyconverter.Source;

public class DialogButtons
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final String SOURCE_PROPERTY = "CurrencySource";
    private JLabel lblMessage;
    private JRadioButton rdbtnYahoo;
    private JRadioButton rdbtnECB;
    private JPanel panel;
    private Source source;

    public DialogButtons(Source source) {
        this.source = source;
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gbcPanel = new GridBagConstraints();
        gbcPanel.anchor = 17;
        gbcPanel.fill = 3;
        gbcPanel.insets = new Insets(0, 0, 0, 5);
        gbcPanel.gridx = 0;
        gbcPanel.gridy = 0;
        this.add((Component)this.getPanel(), gbcPanel);
        GridBagConstraints gbcLblMessage = new GridBagConstraints();
        gbcLblMessage.insets = new Insets(0, 0, 0, 5);
        gbcLblMessage.anchor = 18;
        gbcLblMessage.weightx = 1.0;
        gbcLblMessage.fill = 1;
        gbcLblMessage.gridx = 1;
        gbcLblMessage.gridy = 0;
        this.add((Component)this.getLblMessage(), gbcLblMessage);
        ButtonGroup group = new ButtonGroup();
        group.add(this.getRdbtnECB());
        group.add(this.getRdbtnYahoo());
        ItemListener listener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Source old = DialogButtons.this.source;
                DialogButtons.this.source = DialogButtons.this.getRdbtnECB().isSelected() ? Source.ECB : Source.YAHOO;
                if (!old.equals((Object)DialogButtons.this.source)) {
                    DialogButtons.this.firePropertyChange(DialogButtons.SOURCE_PROPERTY, (Object)old, (Object)DialogButtons.this.source);
                }
            }
        };
        this.getRdbtnECB().addItemListener(listener);
        this.getRdbtnYahoo().addItemListener(listener);
    }

    private JLabel getLblMessage() {
        if (this.lblMessage == null) {
            this.lblMessage = new JLabel();
            this.lblMessage.setHorizontalAlignment(4);
            this.lblMessage.setVerticalAlignment(1);
        }
        return this.lblMessage;
    }

    private JRadioButton getRdbtnYahoo() {
        if (this.rdbtnYahoo == null) {
            this.rdbtnYahoo = new JRadioButton(Messages.getString("YAHOO.name"));
            this.rdbtnYahoo.setSelected(Source.YAHOO.equals((Object)this.source));
            this.rdbtnYahoo.setVisible(false);
        }
        return this.rdbtnYahoo;
    }

    private JRadioButton getRdbtnECB() {
        if (this.rdbtnECB == null) {
            this.rdbtnECB = new JRadioButton(Messages.getString("ECB.name"));
            this.rdbtnECB.setSelected(Source.ECB.equals((Object)this.source));
        }
        return this.rdbtnECB;
    }

    private JPanel getPanel() {
        if (this.panel == null) {
            this.panel = new JPanel();
            this.panel.setBorder(BorderFactory.createTitledBorder(Messages.getString("CurrencyConverterPanel.source")));
            this.panel.setLayout(new BorderLayout(5, 0));
            this.panel.add((Component)this.getRdbtnECB(), "West");
            this.panel.add((Component)this.getRdbtnYahoo(), "East");
        }
        return this.panel;
    }

    public Source getSource() {
        return this.source;
    }

    void setConverter(AbstractCurrencyConverter converter) {
        String title = Formatter.format(Messages.getString("CurrencyConverterPanel.topMessage"), new Date(converter.getTimeStamp()));
        this.getLblMessage().setText(title);
        if (!converter.isSynchronized()) {
            this.getLblMessage().setIcon(IconManager.get(IconManager.Name.ALERT));
        }
    }
}

