/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.tools.currencyconverter;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.yapbam.remote.Cache;

public class FileCache
implements Cache {
    private File cacheFile;

    public FileCache(File file) {
        this.cacheFile = file;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return new FileOutputStream(this.getTmpFile());
    }

    private File getTmpFile() {
        return new File(this.cacheFile.getAbsolutePath() + ".tmp");
    }

    @Override
    public InputStream getInputStream(boolean tmp) throws IOException {
        return new FileInputStream(tmp ? this.getTmpFile() : this.cacheFile);
    }

    @Override
    public void commit() throws IOException {
        if (this.getTmpFile().exists() && this.cacheFile.exists()) {
            this.cacheFile.delete();
        }
        if (!this.getTmpFile().renameTo(this.cacheFile)) {
            throw new IOException("Unable to commit cache");
        }
    }

    @Override
    public boolean isEmpty() {
        return !this.getTmpFile().exists() && !this.cacheFile.exists();
    }

    @Override
    public long getTimeStamp() {
        return this.cacheFile.exists() ? this.cacheFile.lastModified() : -1L;
    }
}

