/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.transactiontable;

import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.transactiontable.ObjectRenderer;

public class AmountRenderer
extends ObjectRenderer {
    private static final long serialVersionUID = 1L;

    @Override
    public void setValue(Object value) {
        String text;
        if (value == null) {
            text = "";
        } else {
            double[] amount = (double[])value;
            if (amount.length == 1) {
                text = this.toString(amount[0]);
            } else {
                StringBuilder buf = new StringBuilder("<html><body>").append(this.toString(amount[0]));
                for (int i = 1; i < amount.length; ++i) {
                    if (this.isNaN(amount[i])) {
                        buf.append("<BR>");
                        continue;
                    }
                    buf.append("<BR>[").append(this.toString(amount[i])).append("]");
                }
                buf.append("</body></html>");
                text = buf.toString().replace(" ", "&nbsp;");
            }
        }
        this.setText(text);
    }

    private String toString(double amount) {
        return this.isNaN(amount) ? "" : LocalizationData.getCurrencyInstance().format(amount);
    }

    private boolean isNaN(double value) {
        return value != value;
    }
}

