/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public abstract class Base64Encoder {
    private Base64Encoder() {
    }

    public static String encode(byte[] bytes) {
        try {
            try {
                return Base64Encoder.doJava8(bytes);
            }
            catch (ClassNotFoundException e) {
                try {
                    return Base64Encoder.doOldJava(bytes);
                }
                catch (ClassNotFoundException e1) {
                    return Base64Encoder.doAndroid(bytes);
                }
            }
        }
        catch (NoSuchMethodException e) {
            throw new UnsupportedOperationException(e);
        }
        catch (IllegalAccessException e) {
            throw new UnsupportedOperationException(e);
        }
        catch (InvocationTargetException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    private static String doJava8(byte[] bytes) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class<?> class1 = Class.forName("java.util.Base64");
        Method staticMethod = class1.getMethod("getEncoder", new Class[0]);
        Object instance = staticMethod.invoke(null, new Object[0]);
        Method method = instance.getClass().getMethod("encode", byte[].class);
        return new String((byte[])method.invoke(instance, new Object[]{bytes}));
    }

    private static String doOldJava(byte[] bytes) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class<?> class1 = Class.forName("javax.xml.bind.DatatypeConverter");
        Method method = class1.getMethod("printBase64Binary", byte[].class);
        return (String)method.invoke(null, new Object[]{bytes});
    }

    private static String doAndroid(byte[] bytes) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        try {
            Class<?> class1 = Class.forName("android.util.Base64");
            Method method = class1.getMethod("encode", byte[].class, Integer.TYPE);
            int flags = class1.getField("NO_WRAP").getInt(null);
            return new String((byte[])method.invoke(null, bytes, flags));
        }
        catch (ClassNotFoundException e1) {
            throw new UnsupportedOperationException(e1);
        }
        catch (NoSuchFieldException e1) {
            throw new UnsupportedOperationException(e1);
        }
    }
}

