/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.util;

import com.fathzer.soft.javaluator.AbstractEvaluator;
import com.fathzer.soft.javaluator.BracketPair;
import com.fathzer.soft.javaluator.DoubleEvaluator;
import com.fathzer.soft.javaluator.Operator;
import com.fathzer.soft.javaluator.Parameters;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Iterator;

public class BigDecimalEvaluator
extends AbstractEvaluator<BigDecimal> {
    private static final Parameters PARAMS = new Parameters();
    private MathContext mathContext;

    public BigDecimalEvaluator(MathContext context) {
        super(PARAMS);
        this.mathContext = context;
    }

    @Override
    protected BigDecimal toValue(String literal, Object evaluationContext) {
        try {
            return new BigDecimal(literal);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    protected BigDecimal evaluate(Operator operator, Iterator<BigDecimal> operands, Object evaluationContext) {
        if (operator.equals(DoubleEvaluator.NEGATE)) {
            return operands.next().negate();
        }
        BigDecimal ope1 = operands.next();
        BigDecimal ope2 = operands.next();
        if (operator.equals(DoubleEvaluator.MINUS)) {
            return ope1.subtract(ope2);
        }
        if (operator.equals(DoubleEvaluator.PLUS)) {
            return ope1.add(ope2);
        }
        if (operator.equals(DoubleEvaluator.MULTIPLY)) {
            return ope1.multiply(ope2);
        }
        if (operator.equals(DoubleEvaluator.DIVIDE)) {
            return ope1.divide(ope2, this.mathContext);
        }
        return super.evaluate(operator, operands, evaluationContext);
    }

    static {
        PARAMS.addExpressionBracket(BracketPair.PARENTHESES);
        PARAMS.add(DoubleEvaluator.NEGATE);
        PARAMS.add(DoubleEvaluator.MINUS);
        PARAMS.add(DoubleEvaluator.PLUS);
        PARAMS.add(DoubleEvaluator.MULTIPLY);
        PARAMS.add(DoubleEvaluator.DIVIDE);
    }
}

