/*
 * Decompiled with CFR 0.152.
 */
package ar.com.fdvs.dj.domain.chart;

import ar.com.fdvs.dj.domain.DJBaseElement;
import ar.com.fdvs.dj.domain.DynamicJasperDesign;
import ar.com.fdvs.dj.domain.StringExpression;
import ar.com.fdvs.dj.domain.constants.Font;
import ar.com.fdvs.dj.util.ExpressionUtils;
import java.awt.Color;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.design.JRDesignChart;
import net.sf.jasperreports.engine.design.JRDesignExpression;

public class DJChartOptions
extends DJBaseElement {
    private static final long serialVersionUID = 10000L;
    public static final byte POSITION_FOOTER = 1;
    public static final byte POSITION_HEADER = 2;
    public static final byte EDGE_TOP = 1;
    public static final byte EDGE_BOTTOM = 2;
    public static final byte EDGE_LEFT = 3;
    public static final byte EDGE_RIGHT = 4;
    public static final byte LINE_STYLE_SOLID = 0;
    public static final byte LINE_STYLE_DASHED = 1;
    public static final byte LINE_STYLE_DOTTED = 2;
    public static final byte LINE_STYLE_DOUBLE = 3;
    private Color backColor;
    private int height = 200;
    private int width = 200;
    private boolean centered = true;
    private byte position = 1;
    private int y = 0;
    private int x = 0;
    private Boolean showLegend = new Boolean(true);
    private Color titleColor = null;
    private Color subtitleColor = null;
    private Color legendColor = null;
    private Color legendBackgroundColor = null;
    private String theme = null;
    private Font titleFont = null;
    private Font subtitleFont = null;
    private Font legendFont = null;
    private Byte legendPosition = null;
    private Byte titlePosition = null;
    private StringExpression titleExpression = null;
    private StringExpression subtitleExpression = null;
    private Byte lineStyle = null;
    private Float lineWidth = null;
    private Color lineColor = null;
    private Integer padding = null;
    private String customizerClass = null;

    public DJChartOptions() {
        this.backColor = Color.WHITE;
        this.padding = new Integer(10);
    }

    public Color getBackColor() {
        return this.backColor;
    }

    public void setBackColor(Color backColor) {
        this.backColor = backColor;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public boolean isCentered() {
        return this.centered;
    }

    public void setCentered(boolean centered) {
        this.centered = centered;
    }

    public byte getPosition() {
        return this.position;
    }

    public void setPosition(byte position) {
        this.position = position;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public Boolean getShowLegend() {
        return this.showLegend;
    }

    public void setShowLegend(Boolean showLegend) {
        this.showLegend = showLegend;
    }

    public Color getTitleColor() {
        return this.titleColor;
    }

    public void setTitleColor(Color titleColor) {
        this.titleColor = titleColor;
    }

    public Color getSubtitleColor() {
        return this.subtitleColor;
    }

    public void setSubtitleColor(Color subtitleColor) {
        this.subtitleColor = subtitleColor;
    }

    public Color getLegendColor() {
        return this.legendColor;
    }

    public void setLegendColor(Color legendColor) {
        this.legendColor = legendColor;
    }

    public Color getLegendBackgroundColor() {
        return this.legendBackgroundColor;
    }

    public void setLegendBackgroundColor(Color legendBackgroundColor) {
        this.legendBackgroundColor = legendBackgroundColor;
    }

    public String getTheme() {
        return this.theme;
    }

    public void setTheme(String theme) {
        this.theme = theme;
    }

    public Font getTitleFont() {
        return this.titleFont;
    }

    public void setTitleFont(Font titleFont) {
        this.titleFont = titleFont;
    }

    public Font getSubtitleFont() {
        return this.subtitleFont;
    }

    public void setSubtitleFont(Font subtitleFont) {
        this.subtitleFont = subtitleFont;
    }

    public Font getLegendFont() {
        return this.legendFont;
    }

    public void setLegendFont(Font legendFont) {
        this.legendFont = legendFont;
    }

    public Byte getLegendPosition() {
        return this.legendPosition;
    }

    public void setLegendPosition(byte legendPosition) {
        this.legendPosition = new Byte(legendPosition);
    }

    public Byte getTitlePosition() {
        return this.titlePosition;
    }

    public void setTitlePosition(byte titlePosition) {
        this.titlePosition = new Byte(titlePosition);
    }

    public StringExpression getTitleExpression() {
        return this.titleExpression;
    }

    public void setTitleExpression(StringExpression titleExpression) {
        this.titleExpression = titleExpression;
    }

    public StringExpression getSubtitleExpression() {
        return this.subtitleExpression;
    }

    public void setSubtitleExpression(StringExpression subtitleExpression) {
        this.subtitleExpression = subtitleExpression;
    }

    public Byte getLineStyle() {
        return this.lineStyle;
    }

    public void setLineStyle(byte lineStyle) {
        this.lineStyle = new Byte(lineStyle);
    }

    public Float getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(Float lineWidth) {
        this.lineWidth = lineWidth;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(Color lineColor) {
        this.lineColor = lineColor;
    }

    public Integer getPadding() {
        return this.padding;
    }

    public void setPadding(Integer padding) {
        this.padding = padding;
    }

    public void setCustomizerClass(String customizerClass) {
        this.customizerClass = customizerClass;
    }

    public String getCustomizerClass() {
        return this.customizerClass;
    }

    public void transform(DynamicJasperDesign design, String name, JRDesignChart chart, int width) {
        JRDesignExpression exp;
        if (this.centered) {
            chart.setWidth(width);
        } else {
            chart.setWidth(this.width);
        }
        chart.setHeight(this.height);
        chart.setX(this.x);
        chart.setY(this.y);
        if (this.showLegend != null) {
            chart.setShowLegend(this.showLegend);
        }
        if (this.backColor != null) {
            chart.setBackcolor(this.backColor);
        }
        if (this.titleColor != null) {
            chart.setTitleColor(this.titleColor);
        }
        if (this.subtitleColor != null) {
            chart.setSubtitleColor(this.subtitleColor);
        }
        if (this.legendColor != null) {
            chart.setLegendColor(this.legendColor);
        }
        if (this.legendBackgroundColor != null) {
            chart.setLegendBackgroundColor(this.legendBackgroundColor);
        }
        if (this.theme != null) {
            chart.setTheme(this.theme);
        }
        if (this.titleFont != null) {
            chart.setTitleFont(this.titleFont.transform());
        }
        if (this.subtitleFont != null) {
            chart.setSubtitleFont(this.subtitleFont.transform());
        }
        if (this.legendFont != null) {
            chart.setLegendFont(this.legendFont.transform());
        }
        if (this.legendPosition != null) {
            chart.setLegendPosition(this.legendPosition);
        }
        if (this.titlePosition != null) {
            chart.setTitlePosition(this.titlePosition);
        }
        if (this.padding != null) {
            chart.getLineBox().setPadding(this.padding);
        }
        if (this.lineStyle != null) {
            chart.getLineBox().getPen().setLineStyle(this.lineStyle);
        }
        if (this.lineWidth != null) {
            chart.getLineBox().getPen().setLineWidth(this.lineWidth);
        }
        if (this.lineColor != null) {
            chart.getLineBox().getPen().setLineColor(this.lineColor);
        }
        if (this.titleExpression != null) {
            exp = ExpressionUtils.createAndRegisterExpression(design, "title_" + name, this.titleExpression);
            chart.setTitleExpression((JRExpression)exp);
        }
        if (this.subtitleExpression != null) {
            exp = ExpressionUtils.createAndRegisterExpression(design, "subtitle_" + name, this.subtitleExpression);
            chart.setSubtitleExpression((JRExpression)exp);
        }
        if (this.customizerClass != null) {
            chart.setCustomizerClass(this.customizerClass);
        }
    }
}

