/*
 * Decompiled with CFR 0.152.
 */
package jgnash.engine;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import jgnash.engine.AccountGroup;
import jgnash.engine.AccountProperty;
import jgnash.engine.AccountProxy;
import jgnash.engine.AccountType;
import jgnash.engine.CurrencyNode;
import jgnash.engine.InvestmentTransaction;
import jgnash.engine.ReconciledState;
import jgnash.engine.SecurityNode;
import jgnash.engine.StoredObject;
import jgnash.engine.Transaction;
import jgnash.util.DateUtils;

public class Account
extends StoredObject
implements Comparable<Account>,
Cloneable {
    private static final long serialVersionUID = 6886735664760113291L;
    private String accountType;
    private transient AccountType cachedAccountType;
    private boolean placeHolder = false;
    private boolean locked = false;
    Account parentAccount;
    private boolean visible = true;
    private boolean excludedFromBudget = false;
    private String name = "";
    private String description = "";
    private String notes = "";
    private CurrencyNode currencyNode;
    private final List<Account> children = new ArrayList<Account>();
    final List<Transaction> transactions = new ArrayList<Transaction>();
    List<SecurityNode> securities = new ArrayList<SecurityNode>();
    private BigDecimal accountBalance;
    private BigDecimal reconciledBalance;
    private String accountNumber = "";
    private String bankId;
    private final Map<String, Object> propertyMap = new HashMap<String, Object>();
    private transient ReadWriteLock transactionLock = new ReentrantReadWriteLock(true);
    private transient ReadWriteLock childLock = new ReentrantReadWriteLock(true);
    private transient AccountProxy proxy;
    private static String accountSeparator = ":";
    private static Pattern numberPattern = Pattern.compile("\\d+");
    private static final Logger logger = Logger.getLogger(Account.class.getName());

    public Account() {
    }

    public Account(AccountType type, CurrencyNode node) {
        this();
        if (type == null) {
            throw new IllegalArgumentException("Null AccountType assigned");
        }
        if (node == null) {
            throw new IllegalArgumentException("Null CurrencyNode assigned");
        }
        this.setAccountType(type);
        this.setCurrencyNode(node);
    }

    ReadWriteLock getTransactionLock() {
        return this.transactionLock;
    }

    AccountProxy getProxy() {
        if (this.proxy == null) {
            this.proxy = this.getAccountType().getProxy(this);
        }
        return this.proxy;
    }

    final void setAccountType(AccountType type) {
        if (type == null) {
            throw new RuntimeException("Null account type");
        }
        if (this.cachedAccountType != null && !this.cachedAccountType.isMutable()) {
            throw new RuntimeException("Immutable account type");
        }
        this.accountType = type.name();
        this.cachedAccountType = type;
        this.proxy = null;
    }

    public void setProperty(AccountProperty key, Object value) {
        this.propertyMap.put(key.name(), value);
    }

    boolean removeProperty(AccountProperty key) {
        return this.propertyMap.remove(key.name()) != null;
    }

    public Object getProperty(AccountProperty key) {
        return this.propertyMap.get(key.name());
    }

    public Set<AccountProperty> getProperties() {
        EnumSet<AccountProperty> properties = EnumSet.noneOf(AccountProperty.class);
        for (String propertyKey : this.propertyMap.keySet()) {
            properties.add(AccountProperty.valueOf(propertyKey));
        }
        return properties;
    }

    static void setAccountSeparator(String separator) {
        accountSeparator = separator;
    }

    private static String getAccountSeparator() {
        return accountSeparator;
    }

    void clearCachedBalances() {
        this.accountBalance = null;
        this.reconciledBalance = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean addTransaction(Transaction tran) {
        if (this.placeHolder) {
            logger.severe("Tried to add transaction to a place holder account");
            return false;
        }
        Lock l = this.transactionLock.writeLock();
        l.lock();
        try {
            boolean result = false;
            if (!this.contains(tran)) {
                int index = Collections.binarySearch(this.transactions, tran);
                if (index < 0) {
                    this.transactions.add(-index - 1, tran);
                    this.clearCachedBalances();
                    result = true;
                }
            } else {
                StringBuilder log = new StringBuilder("Account: " + this.getName() + '(' + this.hashCode() + ")\n");
                log.append("Already have transaction ID: ").append(tran.hashCode());
                logger.severe(log.toString());
            }
            boolean bl = result;
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeTransaction(Transaction tran) {
        Lock l = this.transactionLock.writeLock();
        l.lock();
        try {
            boolean result = false;
            if (this.contains(tran)) {
                this.transactions.remove(tran);
                this.clearCachedBalances();
                result = true;
            } else {
                StringBuilder log = new StringBuilder("Account: " + this.getName() + '(' + this.getUuid() + ")\n");
                log.append("Did not contain transaction ID: ").append(tran.getUuid());
                Logger.getLogger(Account.class.toString()).severe(log.toString());
            }
            boolean bl = result;
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Transaction tran) {
        Lock l = this.transactionLock.readLock();
        l.lock();
        try {
            boolean bl = this.transactions.contains(tran);
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Account account) {
        Lock l = this.childLock.readLock();
        l.lock();
        try {
            boolean bl = this.children.contains(account);
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Transaction> getTransactions() {
        Lock l = this.transactionLock.readLock();
        l.lock();
        try {
            ArrayList<Transaction> arrayList = new ArrayList<Transaction>(this.transactions);
            return arrayList;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Transaction> getReadonlyTransactionList() {
        Lock l = this.transactionLock.readLock();
        l.lock();
        try {
            List<Transaction> list = Collections.unmodifiableList(this.transactions);
            return list;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Transaction getTransactionAt(int index) throws IndexOutOfBoundsException {
        Lock l = this.transactionLock.readLock();
        l.lock();
        try {
            Transaction transaction = this.transactions.get(index);
            return transaction;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTransactionCount() {
        Lock l = this.transactionLock.readLock();
        l.lock();
        try {
            int n = this.transactions.size();
            return n;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getNextTransactionNumber() {
        Lock l = this.transactionLock.readLock();
        l.lock();
        try {
            String string;
            int number = 0;
            for (Transaction tran : this.transactions) {
                if (!numberPattern.matcher(tran.getNumber()).matches()) continue;
                try {
                    number = Math.max(number, Integer.parseInt(tran.getNumber()));
                }
                catch (NumberFormatException e) {
                    logger.log(Level.INFO, "Number regex failed", e);
                }
            }
            if (number == 0) {
                string = "";
                return string;
            }
            string = Integer.toString(number + 1);
            return string;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean addChild(Account child) {
        Lock l = this.childLock.writeLock();
        l.lock();
        try {
            boolean result = false;
            if (!this.children.contains(child) && child != this && child.setParent(this)) {
                this.children.add(child);
                this.sortChildren();
                result = true;
            }
            boolean bl = result;
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeChild(Account child) {
        Lock l = this.childLock.writeLock();
        l.lock();
        try {
            boolean result = false;
            if (this.children.remove(child)) {
                result = true;
            }
            boolean bl = result;
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sortChildren() {
        Lock l = this.childLock.writeLock();
        l.lock();
        try {
            Collections.sort(this.children);
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Account> getChildren() {
        Lock l = this.childLock.readLock();
        l.lock();
        try {
            ArrayList<Account> arrayList = new ArrayList<Account>(this.children);
            return arrayList;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int indexOf(Transaction tran) {
        Lock l = this.transactionLock.readLock();
        l.lock();
        try {
            int n = this.transactions.indexOf(tran);
            return n;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getChildCount() {
        Lock l = this.childLock.readLock();
        l.lock();
        try {
            int n = this.children.size();
            return n;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Account getParent() {
        Lock l = this.childLock.readLock();
        l.lock();
        try {
            Account account = this.parentAccount;
            return account;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setParent(Account account) {
        Lock l = this.childLock.writeLock();
        l.lock();
        try {
            boolean result = false;
            if (account != this) {
                this.parentAccount = account;
                result = true;
            }
            boolean bl = result;
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isParent() {
        Lock l = this.childLock.readLock();
        l.lock();
        try {
            boolean bl = !this.children.isEmpty();
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal getBalance() {
        Lock l = this.transactionLock.readLock();
        l.lock();
        try {
            if (this.accountBalance != null) {
                BigDecimal bigDecimal = this.accountBalance;
                return bigDecimal;
            }
            BigDecimal bigDecimal = this.accountBalance = this.getProxy().getBalance();
            return bigDecimal;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BigDecimal getBalance(CurrencyNode node) {
        Lock l = this.transactionLock.readLock();
        l.lock();
        try {
            BigDecimal bigDecimal = this.adjustForExchangeRate(this.getBalance(), node);
            return bigDecimal;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal getBalanceAt(int index) {
        Lock l = this.transactionLock.readLock();
        l.lock();
        try {
            BigDecimal bigDecimal = this.getProxy().getBalanceAt(index);
            return bigDecimal;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal getReconciledBalance() {
        Lock l = this.transactionLock.readLock();
        l.lock();
        try {
            if (this.reconciledBalance != null) {
                BigDecimal bigDecimal = this.reconciledBalance;
                return bigDecimal;
            }
            BigDecimal bigDecimal = this.reconciledBalance = this.getProxy().getReconciledBalance();
            return bigDecimal;
        }
        finally {
            l.unlock();
        }
    }

    private BigDecimal getReconciledBalance(CurrencyNode node) {
        return this.adjustForExchangeRate(this.getReconciledBalance(), node);
    }

    private BigDecimal adjustForExchangeRate(BigDecimal amount, CurrencyNode node) {
        if (node.equals(this.getCurrencyNode())) {
            return amount;
        }
        return amount.multiply(this.getCurrencyNode().getExchangeRate(node));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getFirstUnreconciledTransactionDate() {
        Lock l = this.transactionLock.readLock();
        l.lock();
        try {
            Date date = null;
            for (Transaction transaction : this.transactions) {
                if (transaction.getReconciled(this) != ReconciledState.NOT_RECONCILED) continue;
                date = transaction.getDate();
                break;
            }
            if (date == null) {
                date = this.transactions.get(this.transactions.size() - 1).getDate();
            }
            Date date2 = date;
            return date2;
        }
        finally {
            l.unlock();
        }
    }

    public BigDecimal getOpeningBalanceForReconcile() {
        return this.getProxy().getOpeningBalanceForReconcile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal getTreeBalance() {
        Lock l = this.transactionLock.readLock();
        l.lock();
        Lock cLock = this.childLock.readLock();
        cLock.lock();
        try {
            BigDecimal balance = this.getBalance();
            for (Account child : this.children) {
                balance = balance.add(child.getTreeBalance(this.getCurrencyNode()));
            }
            BigDecimal bigDecimal = balance;
            return bigDecimal;
        }
        finally {
            l.unlock();
            cLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BigDecimal getTreeBalance(CurrencyNode node) {
        Lock l = this.transactionLock.readLock();
        l.lock();
        Lock cLock = this.childLock.readLock();
        cLock.lock();
        try {
            BigDecimal balance = this.getBalance(node);
            for (Account child : this.children) {
                balance = balance.add(child.getTreeBalance(node));
            }
            BigDecimal bigDecimal = balance;
            return bigDecimal;
        }
        finally {
            l.unlock();
            cLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BigDecimal getReconciledTreeBalance(CurrencyNode node) {
        Lock l = this.transactionLock.readLock();
        l.lock();
        Lock cLock = this.childLock.readLock();
        cLock.lock();
        try {
            BigDecimal balance = this.getReconciledBalance(node);
            for (Account child : this.children) {
                balance = balance.add(child.getReconciledTreeBalance(node));
            }
            BigDecimal bigDecimal = balance;
            return bigDecimal;
        }
        finally {
            l.unlock();
            cLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal getReconciledTreeBalance() {
        Lock l = this.transactionLock.readLock();
        l.lock();
        Lock cLock = this.childLock.readLock();
        cLock.lock();
        try {
            BigDecimal balance = this.getReconciledBalance();
            for (Account child : this.children) {
                balance = balance.add(child.getReconciledTreeBalance(this.getCurrencyNode()));
            }
            BigDecimal bigDecimal = balance;
            return bigDecimal;
        }
        finally {
            l.unlock();
            cLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal getBalance(Date start, Date end) {
        assert (start != null && end != null);
        Lock l = this.transactionLock.readLock();
        l.lock();
        try {
            BigDecimal bigDecimal = this.getProxy().getBalance(start, end);
            return bigDecimal;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal getBalance(Date startDate, Date endDate, CurrencyNode node) {
        Lock l = this.transactionLock.readLock();
        l.lock();
        try {
            BigDecimal bigDecimal = this.adjustForExchangeRate(this.getBalance(startDate, endDate), node);
            return bigDecimal;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal getTreeBalance(Date start, Date end) {
        assert (start != null && end != null);
        Lock l = this.transactionLock.readLock();
        l.lock();
        Lock cLock = this.childLock.readLock();
        cLock.lock();
        try {
            BigDecimal balance = this.getBalance(start, end);
            for (Account child : this.children) {
                balance = balance.add(child.getTreeBalance(start, end, this.getCurrencyNode()));
            }
            BigDecimal bigDecimal = balance;
            return bigDecimal;
        }
        finally {
            l.unlock();
            cLock.unlock();
        }
    }

    public List<Account> getAncestors() {
        ArrayList<Account> list = new ArrayList<Account>();
        list.add(this);
        for (Account parent = this.getParent(); parent != null; parent = parent.getParent()) {
            list.add(parent);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal getTreeBalance(Date start, Date end, CurrencyNode node) {
        assert (start != null && end != null);
        Lock l = this.transactionLock.readLock();
        l.lock();
        Lock cLock = this.childLock.readLock();
        cLock.lock();
        try {
            BigDecimal returnValue = this.getBalance(start, end, node);
            for (Account child : this.children) {
                returnValue = returnValue.add(child.getTreeBalance(start, end, node));
            }
            BigDecimal bigDecimal = returnValue;
            return bigDecimal;
        }
        finally {
            l.unlock();
            cLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal getBalance(Date date) {
        Lock l = this.transactionLock.readLock();
        l.lock();
        try {
            BigDecimal bigDecimal = this.getProxy().getBalance(date);
            return bigDecimal;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal getBalance(Date date, CurrencyNode node) {
        Lock l = this.transactionLock.readLock();
        l.lock();
        try {
            BigDecimal bigDecimal = this.adjustForExchangeRate(this.getBalance(date), node);
            return bigDecimal;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Transaction> getTransactions(Date startDate, Date endDate) {
        Lock l = this.transactionLock.readLock();
        l.lock();
        try {
            ArrayList<Transaction> list = new ArrayList<Transaction>();
            for (Transaction transaction : this.transactions) {
                if (!DateUtils.after(transaction.getDate(), startDate, true) || !DateUtils.before(transaction.getDate(), endDate, true)) continue;
                list.add(transaction);
            }
            ArrayList<Transaction> arrayList = list;
            return arrayList;
        }
        finally {
            l.unlock();
        }
    }

    final void setCurrencyNode(CurrencyNode node) {
        if (node == null) {
            throw new IllegalArgumentException();
        }
        this.currencyNode = node;
    }

    public final CurrencyNode getCurrencyNode() {
        return this.currencyNode;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public boolean isPlaceHolder() {
        return this.placeHolder;
    }

    public void setPlaceHolder(boolean placeHolder) {
        this.placeHolder = placeHolder;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String desc) {
        this.description = desc;
    }

    public synchronized String getName() {
        return this.name;
    }

    public void setName(String newName) {
        if (!newName.equals(this.name)) {
            this.name = newName;
            if (this.getParent() != null) {
                this.getParent().sortChildren();
            }
        }
    }

    public synchronized String getPathName() {
        Account parent = this.getParent();
        if (parent != null && parent.getAccountType() != AccountType.ROOT) {
            return parent.getPathName() + Account.getAccountSeparator() + this.getName();
        }
        return this.getName();
    }

    public AccountType getAccountType() {
        if (this.cachedAccountType == null) {
            this.cachedAccountType = AccountType.valueOf(this.accountType);
        }
        return this.cachedAccountType;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public String getNotes() {
        return this.notes;
    }

    @Override
    public int compareTo(Account acc) {
        int result = this.getPathName().compareToIgnoreCase(acc.getPathName());
        if (result == 0) {
            return this.getUuid().compareTo(acc.getUuid());
        }
        return result;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public boolean equals(Object other) {
        return this == other || other instanceof Account && this.getUuid().equals(((Account)other).getUuid());
    }

    @Override
    public int hashCode() {
        return this.getUuid().hashCode();
    }

    public void setAccountNumber(String account) {
        this.accountNumber = account;
    }

    public String getAccountNumber() {
        return this.accountNumber;
    }

    public boolean addSecurity(SecurityNode node) {
        boolean result = false;
        if (node != null && this.memberOf(AccountGroup.INVEST) && !this.containsSecurity(node)) {
            this.securities.add(node);
            Collections.sort(this.securities);
            result = true;
        }
        return result;
    }

    boolean removeSecurity(SecurityNode node) {
        if (this.getUsedSecurities().contains(node)) {
            return false;
        }
        this.securities.remove(node);
        return true;
    }

    public boolean containsSecurity(SecurityNode node) {
        return this.securities.contains(node);
    }

    public BigDecimal getMarketValue() {
        return this.getProxy().getMarketValue();
    }

    public Set<SecurityNode> getSecurities() {
        TreeSet<SecurityNode> set = new TreeSet<SecurityNode>();
        for (SecurityNode node : this.securities) {
            set.add(node);
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<SecurityNode> getUsedSecurities() {
        TreeSet<SecurityNode> set = new TreeSet<SecurityNode>();
        Lock l = this.transactionLock.readLock();
        l.lock();
        try {
            for (Transaction t : this.transactions) {
                if (!(t instanceof InvestmentTransaction)) continue;
                set.add(((InvestmentTransaction)t).getSecurityNode());
            }
        }
        finally {
            l.unlock();
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal getCashBalance() {
        Lock l = this.transactionLock.readLock();
        l.lock();
        try {
            BigDecimal bigDecimal = this.getProxy().getCashBalance();
            return bigDecimal;
        }
        finally {
            l.unlock();
        }
    }

    public int getDepth() {
        int depth = 0;
        for (Account parent = this.getParent(); parent != null; parent = parent.getParent()) {
            ++depth;
        }
        return depth;
    }

    public final boolean instanceOf(AccountType type) {
        return this.getAccountType() == type;
    }

    public final boolean memberOf(AccountGroup group) {
        return this.getAccountType().getAccountGroup() == group;
    }

    public String getBankId() {
        return this.bankId;
    }

    public void setBankId(String bankId) {
        this.bankId = bankId;
    }

    public boolean isExcludedFromBudget() {
        return this.excludedFromBudget;
    }

    public void setExcludedFromBudget(boolean excludeFromBudget) {
        this.excludedFromBudget = excludeFromBudget;
    }

    protected Object readResolve() {
        this.transactionLock = new ReentrantReadWriteLock(true);
        this.childLock = new ReentrantReadWriteLock(true);
        return this;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        Account a = (Account)super.clone();
        a.securities = new ArrayList<SecurityNode>(this.securities);
        a.children.clear();
        a.transactions.clear();
        return a;
    }
}

