/*
 * Decompiled with CFR 0.152.
 */
package jgnash.imports.ofx;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import jgnash.util.FileMagic;

public class OfxV1ToV2 {
    private static final int READ_AHEAD_LIMIT = 2048;

    public static String convertToXML(File file) {
        String encoding = FileMagic.getOfxV1Encoding(file);
        Logger.getLogger(OfxV1ToV2.class.getName()).info("OFX Version 1 file encoding was " + encoding);
        return OfxV1ToV2.convertSgmlToXML(OfxV1ToV2.readFile(file, encoding));
    }

    public static String convertToXML(InputStream stream) {
        return OfxV1ToV2.convertSgmlToXML(OfxV1ToV2.readFile(stream, System.getProperty("file.encoding")));
    }

    private static String convertSgmlToXML(String sgml) {
        StringBuilder xml = new StringBuilder(sgml);
        int readPos = 0;
        int tagEnd = 0;
        while (readPos < xml.length() && readPos != -1) {
            readPos = xml.indexOf("<", tagEnd);
            if (readPos == -1) continue;
            tagEnd = xml.indexOf(">", readPos);
            if (tagEnd != -1) {
                String tag = xml.substring(readPos + 1, tagEnd);
                if (tag.startsWith("/") || xml.indexOf("</" + tag + ">", tagEnd) != -1) continue;
                readPos = xml.indexOf("<", tagEnd);
                xml = xml.insert(readPos, "</" + tag + ">");
                continue;
            }
            readPos = -1;
        }
        return xml.toString();
    }

    private static String concat(Collection<String> strings) {
        StringBuilder b = new StringBuilder();
        for (String s : strings) {
            b.append(s.trim());
        }
        return b.toString();
    }

    private static void consumeHeader(BufferedReader reader) throws IOException {
        block1: {
            String line;
            Logger logger = Logger.getLogger(OfxV1ToV2.class.getName());
            do {
                reader.mark(2048);
                line = reader.readLine();
                if (line == null) break block1;
            } while (!(line = line.trim()).contains("<") && !line.contains(">") && !line.contains("</"));
            reader.reset();
            logger.info("readHeader() Complete");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readFile(InputStream stream, String characterSet) {
        Logger logger = Logger.getLogger(OfxV1ToV2.class.getName());
        if (stream == null) {
            logger.severe("InputStream was null");
            return null;
        }
        ArrayList<String> strings = new ArrayList<String>();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(stream, characterSet));
            OfxV1ToV2.consumeHeader(reader);
            String line = reader.readLine();
            while (line != null) {
                if ((line = line.trim()).length() > 0) {
                    strings.add(line);
                }
                line = reader.readLine();
            }
        }
        catch (FileNotFoundException e) {
            logger.log(Level.SEVERE, e.toString(), e);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.toString(), e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    logger.log(Level.SEVERE, e.toString(), e);
                }
            }
        }
        return OfxV1ToV2.concat(strings);
    }

    private static String readFile(File file, String characterSet) {
        try {
            return OfxV1ToV2.readFile(new FileInputStream(file), characterSet);
        }
        catch (FileNotFoundException e) {
            Logger logger = Logger.getLogger(OfxV1ToV2.class.getName());
            logger.log(Level.SEVERE, e.toString(), e);
            return "";
        }
    }

    private OfxV1ToV2() {
    }
}

