/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.account;

import java.util.Enumeration;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import jgnash.engine.Account;
import jgnash.engine.AccountType;
import jgnash.engine.EngineFactory;
import jgnash.engine.RootAccount;

public class AccountTreeModel
extends DefaultTreeModel {
    private static final long serialVersionUID = 5396760949185898321L;
    private boolean incomeVisible = true;
    private boolean expenseVisible = true;
    private boolean accountVisible = true;
    private boolean hiddenVisible = true;
    private final Object lock = new Object();

    public AccountTreeModel() {
        super(null);
        this.loadAccountTree();
    }

    @Override
    public synchronized void reload() {
        this.loadAccountTree();
    }

    private synchronized void loadAccountTree() {
        if (EngineFactory.getEngine("default") != null) {
            RootAccount r = EngineFactory.getEngine("default").getRootAccount();
            DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode(r);
            this.setRoot(rootNode);
            this.loadChildren(rootNode);
            this.nodeStructureChanged(rootNode);
        } else {
            this.setRoot(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void loadChildren(DefaultMutableTreeNode parentNode) {
        Object object = this.lock;
        synchronized (object) {
            Account parent = (Account)parentNode.getUserObject();
            for (Account child : parent.getChildren()) {
                if (!this.isAccountVisible(child)) continue;
                DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(child);
                this.insertNodeInto(childNode, parentNode, parentNode.getChildCount());
                if (child.getChildCount() <= 0) continue;
                this.loadChildren(childNode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized DefaultMutableTreeNode findAccountNode(Account account) {
        DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)this.getRoot();
        Object object = this.lock;
        synchronized (object) {
            Enumeration<TreeNode> e = rootNode.depthFirstEnumeration();
            while (e.hasMoreElements()) {
                DefaultMutableTreeNode tAccount = (DefaultMutableTreeNode)e.nextElement();
                if (!tAccount.getUserObject().equals(account)) continue;
                return tAccount;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void removeAccount(Account account) {
        Object object = this.lock;
        synchronized (object) {
            DefaultMutableTreeNode child = this.findAccountNode(account);
            if (child != null) {
                this.removeNodeFromParent(child);
            }
        }
    }

    private synchronized boolean isAccountVisible(Account a) {
        AccountType type = a.getAccountType();
        return type == AccountType.INCOME && this.incomeVisible ? !a.isVisible() && this.hiddenVisible || a.isVisible() : (type == AccountType.EXPENSE && this.expenseVisible ? !a.isVisible() && this.hiddenVisible || a.isVisible() : type != AccountType.INCOME && type != AccountType.EXPENSE && this.accountVisible && (!a.isVisible() && this.hiddenVisible || a.isVisible()));
    }

    public synchronized void setHiddenVisible(boolean visible) {
        if (this.hiddenVisible != visible) {
            this.hiddenVisible = visible;
            this.reload();
        }
    }

    public synchronized void setIncomeVisible(boolean visible) {
        if (this.incomeVisible != visible) {
            this.incomeVisible = visible;
            this.reload();
        }
    }

    public synchronized void setExpenseVisible(boolean visible) {
        if (this.expenseVisible != visible) {
            this.expenseVisible = visible;
            this.reload();
        }
    }

    public synchronized void setAccountVisible(boolean visible) {
        if (this.accountVisible != visible) {
            this.accountVisible = visible;
            this.reload();
        }
    }

    public synchronized boolean getAccountVisible() {
        return this.accountVisible;
    }

    public synchronized boolean getExpenseVisible() {
        return this.expenseVisible;
    }

    public synchronized boolean getHiddenVisible() {
        return this.hiddenVisible;
    }

    public synchronized boolean getIncomeVisible() {
        return this.incomeVisible;
    }
}

