/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.account;

import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.math.BigDecimal;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import jgnash.engine.Account;
import jgnash.ui.account.ExpandingAccountTableModel;
import jgnash.ui.actions.ReconcileAccountAction;
import jgnash.ui.components.expandingtable.ExpandingTable;
import jgnash.ui.register.AccountBalanceDisplayManager;

class ExpandingAccountTablePane
extends JScrollPane {
    ExpandingAccountTableModel model = new ExpandingAccountTableModel();
    JTable accountTable = new ExpandingAccountTable(this.model);

    public ExpandingAccountTablePane() {
        this.setViewportView(this.accountTable);
    }

    public Account getSelectedAccount() {
        return (Account)((ExpandingAccountTable)this.accountTable).getSelectedObject();
    }

    Account getSelectedAccount(Point p) {
        return (Account)((ExpandingAccountTable)this.accountTable).getSelectedObject(p);
    }

    void setSelectedAccount(Account account) {
        ((ExpandingAccountTable)this.accountTable).setSelectedObject(account);
    }

    void reconcileAccount() {
        ReconcileAccountAction.reconcileAccount(this.getSelectedAccount());
    }

    private final class ExpandingAccountTable
    extends ExpandingTable<Account> {
        public ExpandingAccountTable(ExpandingAccountTableModel model) {
            super(model);
        }

        @Override
        public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
            Component c = super.prepareRenderer(renderer, row, column);
            if (c instanceof JLabel) {
                Account account = (Account)ExpandingAccountTablePane.this.model.get(row);
                switch (column) {
                    case 0: {
                        break;
                    }
                    case 2: {
                        ((JLabel)c).setHorizontalAlignment(4);
                        BigDecimal balance = AccountBalanceDisplayManager.convertToSelectedBalanceMode(account.getAccountType(), account.getTreeBalance());
                        if (balance.signum() < 0) {
                            c.setForeground(Color.RED);
                            break;
                        }
                        c.setForeground(this.defaultForeground);
                        break;
                    }
                    case 3: {
                        ((JLabel)c).setHorizontalAlignment(4);
                        BigDecimal reconciledBalance = AccountBalanceDisplayManager.convertToSelectedBalanceMode(account.getAccountType(), account.getReconciledTreeBalance());
                        if (reconciledBalance.signum() < 0) {
                            c.setForeground(Color.RED);
                            break;
                        }
                        c.setForeground(this.defaultForeground);
                        break;
                    }
                    default: {
                        c.setForeground(this.defaultForeground);
                        ((JLabel)c).setHorizontalAlignment(this.defaultAlignment);
                        ((JLabel)c).setIcon(null);
                    }
                }
            }
            return c;
        }
    }
}

