/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.actions;

import java.awt.EventQueue;
import javax.swing.AbstractAction;
import jgnash.message.Message;
import jgnash.message.MessageBus;
import jgnash.message.MessageChannel;
import jgnash.message.MessageListener;

public abstract class AbstractEnabledAction
extends AbstractAction
implements MessageListener {
    private static final long serialVersionUID = -7931923279511599388L;

    public AbstractEnabledAction() {
        this.registerListener();
        this.setEnabled(false);
    }

    private void registerListener() {
        MessageBus.getInstance().registerListener(this, MessageChannel.SYSTEM);
    }

    @Override
    public void messagePosted(final Message event) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                switch (event.getEvent()) {
                    case FILE_CLOSING: {
                        AbstractEnabledAction.this.setEnabled(false);
                        break;
                    }
                    case FILE_NEW_SUCCESS: 
                    case FILE_LOAD_SUCCESS: 
                    case UI_RESTARTED: {
                        AbstractEnabledAction.this.setEnabled(true);
                        break;
                    }
                }
            }
        });
    }
}

