/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.JFileChooser;
import javax.swing.SwingWorker;
import javax.swing.filechooser.FileNameExtensionFilter;
import jgnash.engine.Account;
import jgnash.engine.EngineFactory;
import jgnash.imports.ofx.OfxBank;
import jgnash.imports.ofx.OfxImport;
import jgnash.imports.ofx.OfxV1ToV2;
import jgnash.imports.ofx.OfxV2Parser;
import jgnash.ui.StaticUIMethods;
import jgnash.ui.actions.AbstractEnabledAction;
import jgnash.ui.util.builder.Action;
import jgnash.ui.wizards.imports.ImportDialog;
import jgnash.util.FileMagic;
import jgnash.util.Resource;

@Action(value="ofximport-command")
public class ImportOfxAction
extends AbstractEnabledAction {
    private static final long serialVersionUID = -2360990715662934442L;
    private static final String OFX_DIR = "OfxDirectory";

    private static void importOfx() {
        Resource rb = Resource.get();
        Preferences pref = Preferences.userNodeForPackage(ImportOfxAction.class);
        if (EngineFactory.getEngine("default").getRootAccount().getChildCount() == 0) {
            StaticUIMethods.displayError(rb.getString("Message.ErrorCreateBasicAccounts"));
            return;
        }
        JFileChooser chooser = new JFileChooser(pref.get(OFX_DIR, null));
        chooser.setMultiSelectionEnabled(false);
        chooser.addChoosableFileFilter(new FileNameExtensionFilter("Ofx Files (*.ofx,*.qfx)", "ofx", "qfx"));
        if (chooser.showOpenDialog(null) == 0) {
            pref.put(OFX_DIR, chooser.getCurrentDirectory().getAbsolutePath());
            File file = chooser.getSelectedFile();
            if (file.exists()) {
                new Import(file).execute();
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ImportOfxAction.importOfx();
    }

    static final class Import
    extends SwingWorker<OfxV2Parser, Void> {
        private File file;
        private Account match = null;

        Import(File file) {
            this.file = file;
        }

        @Override
        protected OfxV2Parser doInBackground() throws Exception {
            Logger logger = Logger.getLogger(ImportOfxAction.class.getName());
            OfxV2Parser parser = new OfxV2Parser();
            if (FileMagic.isOfxV1(this.file)) {
                logger.info("Parsing OFX Version 1 file");
                String encoding = FileMagic.getOfxV1Encoding(this.file);
                parser.parse(OfxV1ToV2.convertToXML(this.file), encoding);
            } else if (FileMagic.isOfxV2(this.file)) {
                logger.info("Parsing OFX Version 2 file");
                parser.parse(this.file);
            } else {
                logger.info("Unknown OFX Version");
            }
            if (parser.getBank() == null) {
                throw new Exception("Bank import failed");
            }
            String accountNumber = parser.getBank().accountId;
            if (accountNumber != null && accountNumber.length() > 0) {
                this.match = OfxImport.matchAccount(parser.getBank());
            }
            return parser;
        }

        @Override
        protected void done() {
            try {
                OfxV2Parser parser = (OfxV2Parser)this.get();
                ImportDialog d = new ImportDialog();
                d.setSetting(ImportDialog.Settings.BANK, parser.getBank());
                if (this.match != null) {
                    d.setSetting(ImportDialog.Settings.ACCOUNT, this.match);
                }
                d.setVisible(true);
                if (d.isWizardValid()) {
                    final Account account = (Account)d.getSetting(ImportDialog.Settings.ACCOUNT);
                    final OfxBank bank = parser.getBank();
                    final List transactions = (List)d.getSetting(ImportDialog.Settings.TRANSACTIONS);
                    new Thread(){

                        @Override
                        public void run() {
                            String accountNumber = bank.accountId;
                            if (accountNumber != null && !accountNumber.equals(account.getAccountNumber())) {
                                EngineFactory.getEngine("default").setAccountNumber(account, accountNumber);
                            }
                            OfxImport.importTransactions(transactions, account);
                        }
                    }.start();
                }
            }
            catch (InterruptedException ex) {
                Logger.getLogger(ImportOfxAction.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(ImportOfxAction.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
}

