/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.budget;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.CC;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ToolTipManager;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableModel;
import jgnash.engine.Account;
import jgnash.engine.AccountGroup;
import jgnash.engine.Transaction;
import jgnash.engine.budget.BudgetPeriodResults;
import jgnash.engine.budget.BudgetResultsModel;
import jgnash.message.ChannelEvent;
import jgnash.message.Message;
import jgnash.message.MessageListener;
import jgnash.message.MessageProperty;
import jgnash.text.CommodityFormat;
import jgnash.ui.budget.AbstractResultsTable;
import jgnash.ui.budget.BudgetResultsTable;
import jgnash.ui.budget.ExpandingBudgetTableModel;
import jgnash.ui.components.ShadowBorder;
import jgnash.ui.util.JTableUtils;
import jgnash.util.Resource;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.JXTitledPanel;

public class AccountRowFooterPanel
extends JPanel {
    private ExpandingBudgetTableModel model;
    private AccountRowSummaryModel summaryModel;
    private JComponent header;
    private JComponent footer;
    private JTable table;
    private JTable footerTable;
    private final ExecutorService pool = Executors.newCachedThreadPool();
    private BudgetResultsModel resultsModel;

    public AccountRowFooterPanel(ExpandingBudgetTableModel model) {
        this.model = model;
        this.resultsModel = model.getResultsModel();
        this.summaryModel = new AccountRowSummaryModel(model);
        this.layoutMainPanel();
    }

    public void unregisterListeners() {
        this.summaryModel.unregisterListeners();
    }

    private void layoutMainPanel() {
        FormLayout layout = new FormLayout("d:g", "d");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout, (JPanel)this);
        this.setLayout((LayoutManager)layout);
        this.table = new SummaryTable(this.summaryModel);
        this.table.setAutoResizeMode(0);
        this.table.setFocusable(false);
        this.table.setCellSelectionEnabled(false);
        JTableHeader tableHeader = new JTableHeader(this.table.getColumnModel());
        tableHeader.setReorderingAllowed(false);
        tableHeader.setResizingAllowed(false);
        tableHeader.setTable(this.table);
        builder.add((Component)this.table, CC.xy((int)1, (int)1));
        this.header = this.buildHeader(tableHeader);
        this.footer = this.buildFooter();
        this.setBorder(ShadowBorder.getCompondShadowBorder());
        JTableUtils.packTables(this.table, this.footerTable);
        ToolTipManager.sharedInstance().unregisterComponent(this.table);
        ToolTipManager.sharedInstance().unregisterComponent(tableHeader);
    }

    public JComponent getTableHeader() {
        return this.header;
    }

    private JComponent buildHeader(JTableHeader tableHeader) {
        Resource rb = Resource.get();
        JXTitledPanel panelHeader = new JXTitledPanel(rb.getString("Title.Summary"), (Container)tableHeader);
        panelHeader.setBorder(ShadowBorder.getCompondShadowBorder());
        return panelHeader;
    }

    protected void setRowHeight(int rowHeight) {
        this.table.setRowHeight(rowHeight);
    }

    public JComponent buildFooter() {
        FormLayout layout = new FormLayout("d:g", "d");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout, (JPanel)new JXPanel());
        NumberFormat format = CommodityFormat.getShortNumberFormat(this.resultsModel.getBaseCurrency());
        this.footerTable = new BudgetResultsTable((TableModel)new FooterModel(), format);
        this.footerTable.setAutoResizeMode(0);
        this.footerTable.setFocusable(false);
        this.footerTable.setCellSelectionEnabled(false);
        builder.add((Component)this.footerTable, CC.xy((int)1, (int)1));
        builder.setBorder(ShadowBorder.getCompondShadowBorder());
        return builder.getPanel();
    }

    public JComponent getFooter() {
        return this.footer;
    }

    private class AccountRowSummaryModel
    extends AbstractTableModel
    implements MessageListener {
        private ExpandingBudgetTableModel model;
        private transient TableModelListener listener;
        private final String[] columnNames = new String[]{Resource.get().getString("Column.Budgeted"), Resource.get().getString("Column.Change"), Resource.get().getString("Column.Remaining")};

        AccountRowSummaryModel(ExpandingBudgetTableModel model) {
            this.model = model;
            this.registerListeners();
        }

        private void registerListeners() {
            this.listener = new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent e) {
                    AccountRowSummaryModel.this.fireTableChanged(e);
                }
            };
            this.model.addTableModelListener(this.listener);
            this.model.addMessageListener(this);
        }

        protected void unregisterListeners() {
            this.model.removeTableModelListener(this.listener);
            this.model.removeMessageListener(this);
        }

        @Override
        public int getRowCount() {
            return this.model.getRowCount();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return this.columnNames[columnIndex];
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return BigDecimal.class;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Account account = (Account)this.model.get(rowIndex);
            BudgetPeriodResults results = AccountRowFooterPanel.this.resultsModel.getResults(account);
            switch (columnIndex) {
                case 0: {
                    return results.getBudgeted();
                }
                case 1: {
                    return results.getChange();
                }
                case 2: {
                    return results.getRemaining();
                }
            }
            return BigDecimal.ZERO;
        }

        @Override
        public void messagePosted(Message event) {
            if (event.getEvent() == ChannelEvent.TRANSACTION_ADD || event.getEvent() == ChannelEvent.TRANSACTION_REMOVE) {
                this.processTransactionEvent(event);
            } else if (event.getEvent() == ChannelEvent.FILE_CLOSING) {
                this.unregisterListeners();
            } else if (event.getEvent() == ChannelEvent.BUDGET_GOAL_UPDATE) {
                this.processBudgetGoalUpdate(event);
            }
        }

        private void processBudgetGoalUpdate(final Message message) {
            Runnable thread = new Runnable(){

                @Override
                public void run() {
                    List<Account> accountList = ((Account)message.getObject(MessageProperty.ACCOUNT)).getAncestors();
                    for (Account account : accountList) {
                        final int row = AccountRowSummaryModel.this.model.indexOf(account);
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                AccountRowSummaryModel.this.fireTableChanged(new TableModelEvent(AccountRowSummaryModel.this, row, row, -1, 0));
                                JTableUtils.packTables(AccountRowFooterPanel.this.table, AccountRowFooterPanel.this.footerTable);
                            }
                        });
                    }
                }
            };
            AccountRowFooterPanel.this.pool.submit(thread);
        }

        private void processTransactionEvent(final Message message) {
            Runnable thread = new Runnable(){

                @Override
                public void run() {
                    Transaction transaction = (Transaction)message.getObject(MessageProperty.TRANSACTION);
                    HashSet<Account> accounts = new HashSet<Account>();
                    for (Account account : transaction.getAccounts()) {
                        accounts.addAll(account.getAncestors());
                    }
                    for (Account account : accounts) {
                        final int row = AccountRowSummaryModel.this.model.indexOf(account);
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                AccountRowSummaryModel.this.fireTableChanged(new TableModelEvent(AccountRowSummaryModel.this, row, row, -1, 0));
                                JTableUtils.packTables(AccountRowFooterPanel.this.table, AccountRowFooterPanel.this.footerTable);
                            }
                        });
                    }
                }
            };
            AccountRowFooterPanel.this.pool.submit(thread);
        }
    }

    private class FooterModel
    extends AbstractTableModel
    implements MessageListener {
        private List<AccountGroup> groups;

        FooterModel() {
            this.groups = AccountRowFooterPanel.this.model.getAccountGroups();
            this.registerListeners();
        }

        private void registerListeners() {
            AccountRowFooterPanel.this.summaryModel.addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent e) {
                    FooterModel.this.fireTableDataChanged();
                }
            });
            AccountRowFooterPanel.this.model.addMessageListener(this);
        }

        @Override
        public int getRowCount() {
            return this.groups.size();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return BigDecimal.class;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            AccountGroup group = AccountRowFooterPanel.this.resultsModel.getAccountGroupList().get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return AccountRowFooterPanel.this.resultsModel.getResults(group).getBudgeted();
                }
                case 1: {
                    return AccountRowFooterPanel.this.resultsModel.getResults(group).getChange();
                }
                case 2: {
                    return AccountRowFooterPanel.this.resultsModel.getResults(group).getRemaining();
                }
            }
            return BigDecimal.ZERO;
        }

        @Override
        public void messagePosted(Message event) {
            switch (event.getEvent()) {
                case ACCOUNT_ADD: 
                case ACCOUNT_REMOVE: 
                case ACCOUNT_MODIFY: 
                case BUDGET_UPDATE: {
                    this.groups = AccountRowFooterPanel.this.model.getAccountGroups();
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            FooterModel.this.fireTableDataChanged();
                        }
                    });
                }
            }
        }
    }

    private class SummaryTable
    extends AbstractResultsTable {
        public SummaryTable(TableModel model) {
            super(model);
        }

        @Override
        protected NumberFormat getNumberFormat(int row) {
            Account account = (Account)AccountRowFooterPanel.this.model.get(row);
            return CommodityFormat.getShortNumberFormat(account.getCurrencyNode());
        }
    }
}

