/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.budget;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.CC;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import jgnash.engine.Account;
import jgnash.engine.AccountGroup;
import jgnash.engine.EngineFactory;
import jgnash.engine.budget.Budget;
import jgnash.engine.budget.BudgetGoal;
import jgnash.ui.budget.BudgetGoalDialog;
import jgnash.ui.budget.ExpandingBudgetTableModel;
import jgnash.ui.components.ShadowBorder;
import jgnash.ui.components.expandingtable.ExpandingTable;
import org.jdesktop.swingx.JXTitledPanel;

final class AccountRowHeaderPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final ExpandingBudgetTableModel tableModel;
    private Budget budget;
    private JTable table;

    AccountRowHeaderPanel(Budget budget, ExpandingBudgetTableModel model) {
        this.tableModel = model;
        this.budget = budget;
        this.layoutMainPanel();
    }

    public JPanel getTableHeader() {
        JTableHeader header = this.table.getTableHeader();
        header.setReorderingAllowed(false);
        header.setResizingAllowed(false);
        JXTitledPanel panel = new JXTitledPanel("  ", (Container)header);
        panel.setBorder(ShadowBorder.getCompondShadowBorder());
        return panel;
    }

    protected JTable getTable() {
        return this.table;
    }

    protected int getRowHeight() {
        return this.table.getRowHeight();
    }

    private void layoutMainPanel() {
        FormLayout layout = new FormLayout("pref:g", "t:d:g");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout, (JPanel)this);
        this.setLayout((LayoutManager)layout);
        this.table = new AccountTable(this.tableModel);
        this.table.setAutoResizeMode(0);
        this.table.getSelectionModel().setSelectionMode(0);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    int rowIndex = ((JTable)e.getSource()).getSelectedRow();
                    Account account = (Account)AccountRowHeaderPanel.this.tableModel.get(rowIndex);
                    if (!account.isLocked() && !account.isPlaceHolder()) {
                        AccountRowHeaderPanel.this.showBudgetGoalDialog(account);
                    }
                }
            }
        });
        builder.add((Component)this.table, CC.xy((int)1, (int)1));
        this.setBorder(ShadowBorder.getCompondShadowBorder());
    }

    @Override
    public void setPreferredSize(Dimension preferredSize) {
        this.table.setPreferredSize(new Dimension(preferredSize.width, this.table.getRowCount() * this.table.getRowHeight()));
        this.table.doLayout();
    }

    private void showBudgetGoalDialog(Account account) {
        BudgetGoal newGoal;
        BudgetGoal oldGoal = this.budget.getBudgetGoal(account);
        BudgetGoalDialog d = new BudgetGoalDialog(account, oldGoal, this.budget.getWorkingYear());
        d.setVisible(true);
        if (d.getResult() && !(newGoal = d.getBudgetGoal()).equals(oldGoal)) {
            EngineFactory.getEngine("default").updateBudgetGoals(this.budget, account, newGoal);
        }
    }

    public JComponent getFooter() {
        FormLayout layout = new FormLayout("d:g", "d");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout, new JPanel());
        JTable table = new JTable(new GroupTableModel());
        table.setAutoResizeMode(0);
        table.setFocusable(false);
        table.setCellSelectionEnabled(false);
        builder.add((Component)table, CC.xy((int)1, (int)1));
        builder.setBorder(ShadowBorder.getCompondShadowBorder());
        return builder.getPanel();
    }

    private class GroupTableModel
    extends AbstractTableModel {
        private List<AccountGroup> groups;

        GroupTableModel() {
            this.groups = AccountRowHeaderPanel.this.tableModel.getAccountGroups();
            AccountRowHeaderPanel.this.tableModel.addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent e) {
                    GroupTableModel.this.groups = AccountRowHeaderPanel.this.tableModel.getAccountGroups();
                    GroupTableModel.this.fireTableDataChanged();
                }
            });
        }

        @Override
        public int getRowCount() {
            return this.groups.size();
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.groups.get(rowIndex).toString();
        }
    }

    private static class AccountTable
    extends ExpandingTable<Account> {
        public AccountTable(ExpandingBudgetTableModel model) {
            super(model);
        }

        @Override
        public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
            Component c = super.prepareRenderer(renderer, row, column);
            Account account = (Account)((ExpandingBudgetTableModel)this.getModel()).get(row);
            c.setEnabled(!account.isPlaceHolder());
            return c;
        }
    }
}

