/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.budget;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;
import jgnash.engine.EngineFactory;
import jgnash.engine.budget.Budget;
import jgnash.engine.budget.BudgetPeriod;
import jgnash.ui.UIApplication;
import jgnash.ui.util.DialogUtils;
import jgnash.util.Resource;
import org.jdesktop.swingx.combobox.EnumComboBoxModel;

public final class BudgetPropertiesDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private final Resource rb = Resource.get();
    private JComboBox budgetPeriodCombo;
    private JButton okButton;
    private JButton cancelButton;
    private JTextField descriptionField;
    private JCheckBox assetGroupCheckBox;
    private JCheckBox expenseGroupCheckBox;
    private JCheckBox incomeGroupCheckBox;
    private JCheckBox liabilityGroupCheckBox;
    private Budget budget;

    public BudgetPropertiesDialog(Budget budget) {
        super((Frame)UIApplication.getFrame(), true);
        this.setTitle(this.rb.getString("Title.BudgetProperties"));
        this.setIconImage(Resource.getImage("/jgnash/resource/gnome-money.png"));
        this.setDefaultCloseOperation(2);
        this.budget = budget;
        this.layoutMainPanel();
        this.setSelectedPeriod(budget.getBudgetPeriod());
        this.descriptionField.setText(budget.getDescription());
    }

    private void setSelectedPeriod(BudgetPeriod period) {
        this.budgetPeriodCombo.setSelectedItem((Object)period);
    }

    private BudgetPeriod getSelectedPeriod() {
        return (BudgetPeriod)((Object)this.budgetPeriodCombo.getSelectedItem());
    }

    private void initComponents() {
        this.budgetPeriodCombo = new JComboBox();
        this.budgetPeriodCombo.setModel(new EnumComboBoxModel(BudgetPeriod.class));
        this.descriptionField = new JTextField();
        this.assetGroupCheckBox = new JCheckBox(this.rb.getString("Button.AssetAccounts"));
        this.incomeGroupCheckBox = new JCheckBox(this.rb.getString("Button.IncomeAccounts"));
        this.expenseGroupCheckBox = new JCheckBox(this.rb.getString("Button.ExpenseAccounts"));
        this.liabilityGroupCheckBox = new JCheckBox(this.rb.getString("Button.LiabilityAccounts"));
        this.assetGroupCheckBox.setSelected(this.budget.areAssetAccountsIncluded());
        this.incomeGroupCheckBox.setSelected(this.budget.areIncomeAccountsIncluded());
        this.expenseGroupCheckBox.setSelected(this.budget.areExpenseAccountsIncluded());
        this.liabilityGroupCheckBox.setSelected(this.budget.areLiabilityAccountsIncluded());
        this.okButton = new JButton(this.rb.getString("Button.Ok"));
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(this.rb.getString("Button.Cancel"));
        this.cancelButton.addActionListener(this);
    }

    private void layoutMainPanel() {
        this.initComponents();
        FormLayout layout = new FormLayout("p, $lcgap, f:max(90dlu;p)", "f:p, $rgap, f:p, $ugap, f:p, $rgap, f:p, $rgap, f:p, $rgap, f:p, $rgap, f:p, $ugap, p");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setDefaultDialogBorder();
        CellConstraints cc = new CellConstraints();
        builder.add((Component)new JLabel(this.rb.getString("Label.Description")), cc.xy(1, 1));
        builder.add((Component)this.descriptionField, cc.xy(3, 1));
        builder.add((Component)new JLabel(this.rb.getString("Label.Period")), cc.xy(1, 3));
        builder.add((Component)this.budgetPeriodCombo, cc.xy(3, 3));
        builder.addSeparator(this.rb.getString("Title.AccountGroups"), cc.xyw(1, 5, 3));
        builder.add((Component)this.incomeGroupCheckBox, cc.xyw(1, 7, 3));
        builder.add((Component)this.expenseGroupCheckBox, cc.xyw(1, 9, 3));
        builder.add((Component)this.assetGroupCheckBox, cc.xyw(1, 11, 3));
        builder.add((Component)this.liabilityGroupCheckBox, cc.xyw(1, 13, 3));
        builder.add((Component)ButtonBarFactory.buildOKCancelBar((JButton)this.okButton, (JButton)this.cancelButton), cc.xyw(1, 15, 3));
        this.getContentPane().add((Component)builder.getPanel(), "Center");
        this.pack();
        this.setResizable(false);
        DialogUtils.addBoundsListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            boolean modified = false;
            if (this.budget.getBudgetPeriod() != this.getSelectedPeriod()) {
                modified = true;
                this.budget.setBudgetPeriod(this.getSelectedPeriod());
            }
            if (this.descriptionField.getText().length() > 0 && !this.budget.getDescription().equals(this.descriptionField.getText())) {
                modified = true;
                this.budget.setDescription(this.descriptionField.getText());
            }
            if (this.assetGroupCheckBox.isSelected() != this.budget.areAssetAccountsIncluded()) {
                modified = true;
                this.budget.setAssetAccountsIncluded(this.assetGroupCheckBox.isSelected());
            }
            if (this.incomeGroupCheckBox.isSelected() != this.budget.areIncomeAccountsIncluded()) {
                modified = true;
                this.budget.setIncomeAccountsIncluded(this.incomeGroupCheckBox.isSelected());
            }
            if (this.expenseGroupCheckBox.isSelected() != this.budget.areExpenseAccountsIncluded()) {
                modified = true;
                this.budget.setExpenseAccountsIncluded(this.expenseGroupCheckBox.isSelected());
            }
            if (this.liabilityGroupCheckBox.isSelected() != this.budget.areLiabilityAccountsIncluded()) {
                modified = true;
                this.budget.setLiabilityAccountsIncluded(this.liabilityGroupCheckBox.isSelected());
            }
            if (modified) {
                Thread thread = new Thread(){

                    @Override
                    public void run() {
                        EngineFactory.getEngine("default").updateBudget(BudgetPropertiesDialog.this.budget);
                    }
                };
                thread.start();
            }
            this.dispatchEvent(new WindowEvent(this, 201));
        } else if (e.getSource() == this.cancelButton) {
            this.dispatchEvent(new WindowEvent(this, 201));
        }
    }
}

