/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.budget;

import java.awt.Color;
import java.awt.Paint;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.encoders.ImageEncoder;
import org.jfree.chart.encoders.ImageEncoderFactory;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.renderer.category.BarPainter;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.StandardBarPainter;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.ui.RectangleInsets;

final class BudgetSparkline {
    private static final String CATEGORY = "amount";
    private static final int DEFAULT_WIDTH = 120;
    private static final int DEFAULT_HEIGHT = 24;
    private static final Icon EMPTY_ICON = new ImageIcon(new BufferedImage(120, 24, 1));
    private static final ImageEncoder ENCODER = ImageEncoderFactory.newInstance((String)"png", (boolean)true);
    private static final Color CLEAR = new Color(0, 0, 0, 0);
    private static final RectangleInsets INSETS = new RectangleInsets(-1.0, -1.0, 0.0, 0.0);

    private BudgetSparkline() {
    }

    public static Icon getSparklineImage(List<BigDecimal> amounts) {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        final boolean[] negate = new boolean[amounts.size()];
        for (int i = 0; i < amounts.size(); ++i) {
            dataset.addValue((Number)amounts.get(i), (Comparable)((Object)CATEGORY), (Comparable)Integer.valueOf(i));
            negate[i] = amounts.get(i).signum() == -1;
        }
        CategoryAxis xAxis = new CategoryAxis();
        xAxis.setTickLabelsVisible(false);
        xAxis.setTickMarksVisible(false);
        xAxis.setAxisLineVisible(false);
        xAxis.setVisible(false);
        NumberAxis yAxis = new NumberAxis();
        yAxis.setTickLabelsVisible(false);
        yAxis.setTickMarksVisible(false);
        yAxis.setAxisLineVisible(false);
        yAxis.setNegativeArrowVisible(false);
        yAxis.setPositiveArrowVisible(false);
        yAxis.setAutoRangeIncludesZero(true);
        yAxis.setAutoRange(true);
        yAxis.setVisible(false);
        BarRenderer renderer = new BarRenderer(){

            public Paint getItemPaint(int row, int column) {
                return negate[column] ? Color.RED : Color.BLACK;
            }
        };
        renderer.setShadowVisible(false);
        renderer.setBarPainter((BarPainter)new StandardBarPainter());
        CategoryPlot plot = new CategoryPlot((CategoryDataset)dataset, xAxis, (ValueAxis)yAxis, (CategoryItemRenderer)renderer);
        plot.setInsets(INSETS);
        plot.setDomainGridlinesVisible(false);
        plot.setDomainCrosshairVisible(false);
        plot.setRangeGridlinesVisible(false);
        plot.setRangeCrosshairVisible(false);
        plot.setBackgroundPaint((Paint)CLEAR);
        JFreeChart chart = new JFreeChart(null, JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, false);
        chart.setBorderVisible(false);
        chart.setBackgroundPaint((Paint)CLEAR);
        Icon icon = EMPTY_ICON;
        try {
            byte[] image = ENCODER.encode(chart.createBufferedImage(120, 24, 2, null));
            icon = new ImageIcon(image);
        }
        catch (IOException ex) {
            Logger.getLogger(BudgetSparkline.class.getName()).log(Level.SEVERE, null, ex);
        }
        return icon;
    }
}

