/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.checks;

import java.awt.EventQueue;
import java.util.List;
import jgnash.engine.Engine;
import jgnash.engine.EngineFactory;
import jgnash.engine.Transaction;
import jgnash.engine.checks.CheckLayout;
import jgnash.ui.checks.PrintCheckDialog;
import jgnash.ui.checks.PrintableCheckLayout;
import jgnash.ui.checks.TransactionListDialog;

public class PrintCheckFactory {
    private PrintCheckFactory() {
    }

    public static void showDialog() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                TransactionListDialog tld = new TransactionListDialog();
                tld.setVisible(true);
                if (!tld.getReturnStatus() || tld.getPrintableTransactions().isEmpty()) {
                    return;
                }
                PrintCheckDialog pcd = new PrintCheckDialog();
                pcd.setVisible(true);
                if (!pcd.getReturnStatus()) {
                    return;
                }
                CheckLayout checkLayout = pcd.getCheckLayout();
                int numChecks = checkLayout.getNumberOfChecks();
                int startPosition = pcd.getStartPosition();
                List<Transaction> trans = tld.getPrintableTransactions();
                boolean checkNum = pcd.incrementCheckNumbers();
                int i = 0;
                while (i < trans.size()) {
                    Transaction[] pTrans = new Transaction[numChecks];
                    for (int j = startPosition; j < numChecks && i < trans.size(); ++i, ++j) {
                        if (checkNum) {
                            trans.set(i, PrintCheckFactory.changeTransNum(trans.get(i)));
                        }
                        pTrans[j] = trans.get(i);
                    }
                    startPosition = 0;
                    PrintableCheckLayout layout = new PrintableCheckLayout(checkLayout);
                    layout.print(pTrans);
                }
            }
        });
    }

    private static String getNextTransactionNum(Transaction t) {
        String number = t.getTransactionEntries().size() > 1 ? t.getCommonAccount().getNextTransactionNumber() : t.getTransactionEntries().get(0).getDebitAccount().getNextTransactionNumber();
        return number;
    }

    private static Transaction changeTransNum(Transaction transaction) {
        Engine engine = EngineFactory.getEngine("default");
        try {
            Transaction clone = (Transaction)transaction.clone();
            clone.setNumber(PrintCheckFactory.getNextTransactionNum(transaction));
            if (engine.removeTransaction(transaction)) {
                engine.addTransaction(clone);
                return clone;
            }
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return transaction;
    }
}

