/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.commodity;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jgnash.engine.CommodityNode;
import jgnash.engine.CurrencyNode;
import jgnash.engine.Engine;
import jgnash.engine.EngineFactory;
import jgnash.message.Message;
import jgnash.message.MessageBus;
import jgnash.message.MessageChannel;
import jgnash.message.MessageListener;
import jgnash.message.MessageProperty;
import jgnash.ui.UIApplication;
import jgnash.ui.components.JIntegerField;
import jgnash.ui.components.JTextFieldEx;
import jgnash.ui.components.SortedListModel;
import jgnash.ui.util.DialogUtils;
import jgnash.util.Resource;

public class CurrencyModifyDialog
extends JDialog
implements MessageListener,
ListSelectionListener,
ActionListener {
    private final Resource rb = Resource.get();
    private SortedListModel<CurrencyNode> model;
    private CurrencyNode currentCurrency;
    private JTextField suffixField;
    private JList sourceList;
    private JTextField symbolField;
    private JTextField prefixField;
    private JTextField descriptionField;
    private JTextField scaleField;
    private JButton clearButton;
    private JButton applyButton;
    private JButton closeButton;

    public static void showDialog() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                CurrencyModifyDialog d = new CurrencyModifyDialog();
                DialogUtils.addBoundsListener(d);
                d.setVisible(true);
            }
        });
    }

    private CurrencyModifyDialog() {
        super((Frame)UIApplication.getFrame(), true);
        this.setTitle(this.rb.getString("Title.ModifyCurrencies"));
        this.setDefaultCloseOperation(2);
        this.layoutMainPanel();
        this.buildLists();
        this.registerListeners();
    }

    private void registerListeners() {
        MessageBus.getInstance().registerListener(this, MessageChannel.COMMODITY);
    }

    private void unregisterListeners() {
        MessageBus.getInstance().unregisterListener(this, MessageChannel.COMMODITY);
        this.currentCurrency = null;
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == 201) {
            this.unregisterListeners();
        }
    }

    private static Engine getEngine() {
        return EngineFactory.getEngine("default");
    }

    private void initComponents() {
        this.closeButton = new JButton(this.rb.getString("Button.Close"));
        this.sourceList = new JList();
        this.sourceList.setSelectionMode(0);
        this.symbolField = new JTextFieldEx();
        this.descriptionField = new JTextFieldEx();
        this.scaleField = new JIntegerField();
        this.prefixField = new JTextFieldEx();
        this.suffixField = new JTextFieldEx();
        this.clearButton = new JButton(this.rb.getString("Button.Clear"));
        this.applyButton = new JButton(this.rb.getString("Button.Apply"));
        this.applyButton.addActionListener(this);
        this.clearButton.addActionListener(this);
        this.closeButton.addActionListener(this);
    }

    private void layoutMainPanel() {
        this.initComponents();
        FormLayout layout = new FormLayout("f:p:g", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setDefaultDialogBorder();
        builder.appendSeparator(this.rb.getString("Title.Currencies"));
        builder.nextLine();
        builder.appendRelatedComponentsGapRow();
        builder.nextLine();
        builder.appendRow(RowSpec.decode((String)"f:max(65dlu;p):g"));
        builder.append((Component)this.layoutTopPanel());
        builder.nextLine();
        builder.appendUnrelatedComponentsGapRow();
        builder.nextLine();
        builder.append((Component)ButtonBarFactory.buildCloseBar((JButton)this.closeButton));
        this.getContentPane().add((Component)builder.getPanel(), "Center");
        this.pack();
        this.setMinimumSize(this.getSize());
    }

    private JPanel layoutTopPanel() {
        FormLayout layout = new FormLayout("r:p, $lcgap, max(55dlu;p)", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setRowGroupingEnabled(true);
        builder.append(this.rb.getString("Label.Symbol"), (Component)this.symbolField);
        builder.append(this.rb.getString("Label.Description"), (Component)this.descriptionField);
        builder.append(this.rb.getString("Label.Scale"), (Component)this.scaleField);
        builder.append(this.rb.getString("Label.Prefix"), (Component)this.prefixField);
        builder.append(this.rb.getString("Label.Suffix"), (Component)this.suffixField);
        JPanel right = builder.getPanel();
        layout = new FormLayout("max(60dlu;p):g, 8dlu, p", "");
        builder = new DefaultFormBuilder(layout);
        JScrollPane pane = new JScrollPane(this.sourceList);
        pane.setPreferredSize(new Dimension(50, 50));
        builder.appendRow(RowSpec.decode((String)"f:max(35dlu;p):g"));
        builder.append((Component)pane, (Component)right);
        builder.appendRelatedComponentsGapRow();
        builder.nextRow();
        builder.append((Component)ButtonBarFactory.buildLeftAlignedBar((JButton[])new JButton[]{this.clearButton, this.applyButton}), 3);
        return builder.getPanel();
    }

    private void buildLists() {
        this.model = new SortedListModel<CurrencyNode>(CurrencyModifyDialog.getEngine().getCurrencies());
        this.sourceList.setModel(this.model);
        this.sourceList.addListSelectionListener(this);
    }

    private void updateForm() {
        CurrencyNode node = (CurrencyNode)this.sourceList.getSelectedValue();
        if (node != null) {
            this.symbolField.setText(node.getSymbol());
            this.symbolField.setEnabled(false);
            this.descriptionField.setText(node.getDescription());
            this.scaleField.setText(Short.toString(node.getScale()));
            this.prefixField.setText(node.getPrefix());
            this.suffixField.setText(node.getSuffix());
            this.currentCurrency = node;
        }
    }

    void clearForm() {
        this.sourceList.clearSelection();
        this.symbolField.setText(null);
        this.symbolField.setEnabled(true);
        this.descriptionField.setText(null);
        this.scaleField.setText(null);
        this.prefixField.setText(null);
        this.suffixField.setText(null);
        this.currentCurrency = null;
    }

    private boolean validateForm() {
        if (this.scaleField.getText().length() <= 0) {
            return false;
        }
        return this.symbolField.getText().length() > 0;
    }

    private CurrencyNode buildCommodityNode() {
        CurrencyNode node = new CurrencyNode();
        node.setDescription(this.descriptionField.getText());
        node.setPrefix(this.prefixField.getText());
        node.setScale(Byte.parseByte(this.scaleField.getText()));
        node.setSuffix(this.suffixField.getText());
        if (this.currentCurrency != null) {
            node.setSymbol(this.currentCurrency.getSymbol());
        } else {
            node.setSymbol(this.symbolField.getText());
        }
        return node;
    }

    private void commitCommodityNode() {
        if (this.validateForm()) {
            CurrencyNode oldNode = (CurrencyNode)this.sourceList.getSelectedValue();
            CurrencyNode newNode = this.buildCommodityNode();
            if (CurrencyModifyDialog.getEngine().getCurrency(newNode.getSymbol()) != null && oldNode != null) {
                CurrencyModifyDialog.getEngine().updateCommodity(oldNode, newNode);
            } else {
                CurrencyModifyDialog.getEngine().addCommodity(newNode);
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!listSelectionEvent.getValueIsAdjusting() && listSelectionEvent.getSource() == this.sourceList) {
            this.updateForm();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.applyButton) {
            this.commitCommodityNode();
        } else if (e.getSource() == this.clearButton) {
            this.clearForm();
        } else if (e.getSource() == this.closeButton) {
            this.dispatchEvent(new WindowEvent(this, 201));
        }
    }

    @Override
    public void messagePosted(final Message event) {
        final CommodityNode node = (CommodityNode)event.getObject(MessageProperty.COMMODITY);
        if (node instanceof CurrencyNode) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    switch (event.getEvent()) {
                        case CURRENCY_REMOVE: {
                            CurrencyModifyDialog.this.model.removeElement((CurrencyNode)node);
                            if (!CurrencyModifyDialog.this.currentCurrency.equals(node)) break;
                            CurrencyModifyDialog.this.clearForm();
                            break;
                        }
                        case CURRENCY_REMOVE_FAILED: {
                            JOptionPane.showMessageDialog(CurrencyModifyDialog.this, CurrencyModifyDialog.this.rb.getString("Message.WarnCurrencyInUse"), CurrencyModifyDialog.this.rb.getString("Title.Error"), 0);
                            break;
                        }
                        case CURRENCY_ADD: {
                            CurrencyModifyDialog.this.clearForm();
                            CurrencyModifyDialog.this.model.addElement((CurrencyNode)node);
                            break;
                        }
                        case CURRENCY_ADD_FAILED: {
                            JOptionPane.showMessageDialog(CurrencyModifyDialog.this, CurrencyModifyDialog.this.rb.getString("Message.ErrorAddCurrency"), CurrencyModifyDialog.this.rb.getString("Title.Error"), 0);
                            break;
                        }
                        case CURRENCY_MODIFY: {
                            CurrencyModifyDialog.this.model.removeElement((CurrencyNode)node);
                            CurrencyModifyDialog.this.model.addElement(CurrencyModifyDialog.getEngine().getCurrency(node.getSymbol()));
                            if (!CurrencyModifyDialog.this.currentCurrency.equals(node)) break;
                            CurrencyModifyDialog.this.updateForm();
                            break;
                        }
                        case CURRENCY_MODIFY_FAILED: {
                            JOptionPane.showMessageDialog(CurrencyModifyDialog.this, CurrencyModifyDialog.this.rb.getString("Message.ErrorModifyCurrency"), CurrencyModifyDialog.this.rb.getString("Title.Error"), 0);
                            break;
                        }
                    }
                }
            });
        }
    }
}

