/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.components;

import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import jgnash.ui.components.JTextFieldEx;

public class JIntegerField
extends JTextFieldEx {
    private static final NumberFormat formatter = NumberFormat.getNumberInstance();
    private static final String INTEGER = "0123456789";

    public JIntegerField() {
        this(0);
    }

    public JIntegerField(int columnSize) {
        super(columnSize);
        this.setInputVerifier(new IntegerVerifier());
    }

    public void setLongValue(long val) {
        this.setText(Long.toString(val));
    }

    public void setIntValue(int val) {
        this.setText(Integer.toString(val));
    }

    public long longValue() {
        try {
            return Long.parseLong(this.getText());
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    public int intValue() {
        try {
            return Integer.parseInt(this.getText());
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    @Override
    protected Document createDefaultModel() {
        return new IntegerDocument();
    }

    private static class IntegerVerifier
    extends InputVerifier {
        private IntegerVerifier() {
        }

        @Override
        public boolean verify(JComponent input) {
            if (((JTextField)input).getText().length() == 0) {
                return true;
            }
            try {
                formatter.parse(((JTextField)input).getText());
                return true;
            }
            catch (ParseException e) {
                return false;
            }
        }
    }

    static class IntegerDocument
    extends PlainDocument {
        private static final long serialVersionUID = 4630752138733958783L;

        IntegerDocument() {
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (str == null) {
                return;
            }
            for (int i = 0; i < str.length(); ++i) {
                if (JIntegerField.INTEGER.contains(String.valueOf(str.charAt(i)))) continue;
                return;
            }
            super.insertString(offs, str, a);
        }
    }
}

