/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import javax.swing.Icon;
import javax.swing.SwingConstants;
import javax.swing.UIManager;

public class VerticalTextIcon
implements Icon,
SwingConstants {
    private Font font;
    private FontMetrics fm;
    private final String text;
    private int width;
    private int height;
    private final boolean clockwise;
    private static final RenderingHints renderHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);

    public VerticalTextIcon(String text, boolean clockwise) {
        this.text = text;
        this.calculateSize();
        this.clockwise = clockwise;
    }

    private void calculateSize() {
        this.font = UIManager.getFont("Button.font");
        FontRenderContext frc = new FontRenderContext(null, true, true);
        GlyphVector glyphs = this.font.createGlyphVector(frc, this.text);
        this.width = (int)glyphs.getLogicalBounds().getWidth();
        this.height = (int)glyphs.getLogicalBounds().getHeight();
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2 = (Graphics2D)g;
        RenderingHints oldHints = g2.getRenderingHints();
        Font oldFont = g.getFont();
        Color oldColor = g.getColor();
        AffineTransform oldTransform = g2.getTransform();
        if (this.fm == null) {
            this.fm = g.getFontMetrics(this.font);
        }
        g2.setRenderingHints(renderHints);
        g.setFont(this.font);
        g.setColor(Color.black);
        if (this.clockwise) {
            g2.translate(x + this.getIconWidth(), y);
            g2.rotate(1.5707963267948966);
        } else {
            g2.translate(x, y + this.getIconHeight());
            g2.rotate(-1.5707963267948966);
        }
        g.drawString(this.text, 0, this.fm.getLeading() + this.fm.getAscent() - this.fm.getDescent() / 2);
        g.setFont(oldFont);
        g.setColor(oldColor);
        g2.setTransform(oldTransform);
        g2.setRenderingHints(oldHints);
    }

    @Override
    public int getIconWidth() {
        return this.height;
    }

    @Override
    public int getIconHeight() {
        return this.width;
    }

    public void updateUI() {
        this.fm = null;
        this.calculateSize();
    }

    static {
        renderHints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT);
    }
}

