/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.reconcile;

import java.awt.EventQueue;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.swing.table.AbstractTableModel;
import jgnash.engine.Account;
import jgnash.engine.AccountGroup;
import jgnash.engine.Engine;
import jgnash.engine.EngineFactory;
import jgnash.engine.InvestmentTransaction;
import jgnash.engine.ReconciledState;
import jgnash.engine.Transaction;
import jgnash.message.Message;
import jgnash.message.MessageBus;
import jgnash.message.MessageChannel;
import jgnash.message.MessageListener;
import jgnash.message.MessageProperty;
import jgnash.text.CommodityFormat;
import jgnash.ui.register.AccountBalanceDisplayManager;
import jgnash.ui.register.table.PackableTableModel;
import jgnash.util.DateUtils;
import jgnash.util.Resource;

public abstract class AbstractReconcileTableModel
extends AbstractTableModel
implements MessageListener,
PackableTableModel {
    private static final long serialVersionUID = 6081316944824965273L;
    final Account account;
    private final Date openingDate;
    private List<RecTransaction> list = new ArrayList<RecTransaction>();
    private final Resource rb = Resource.get();
    private String[] cNames = new String[]{this.rb.getString("Column.Clr"), this.rb.getString("Column.Date"), this.rb.getString("Column.Num"), this.rb.getString("Column.Payee"), this.rb.getString("Column.Amount")};
    private Class<?>[] cClass = new Class[]{String.class, String.class, String.class, String.class, BigDecimal.class};
    private final int[] columnWidths = new int[]{0, 0, 0, 99, 0};
    private DateFormat dateFormatter = DateUtils.getShortDateFormat();
    private NumberFormat commodityFormatter;
    private ReadWriteLock rwl = new ReentrantReadWriteLock(true);

    AbstractReconcileTableModel(Account account, Date openingDate) {
        assert (this.cNames.length == this.cClass.length);
        assert (account != null);
        this.account = account;
        this.openingDate = (Date)openingDate.clone();
        this.commodityFormatter = CommodityFormat.getShortNumberFormat(account.getCurrencyNode());
        this.loadModel();
        MessageBus.getInstance().registerListener(this, MessageChannel.TRANSACTION);
    }

    @Override
    public int[] getPreferredColumnWeights() {
        return this.columnWidths;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadModel() {
        this.rwl.writeLock().lock();
        try {
            for (Transaction t : this.account.getReadonlyTransactionList()) {
                if (!this.reconcilable(t)) continue;
                this.list.add(new RecTransaction(t));
            }
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    private boolean reconcilable(Transaction t) {
        return DateUtils.after(t.getDate(), this.openingDate) && this.isShowable(t);
    }

    abstract boolean isShowable(Transaction var1);

    @Override
    public int getColumnCount() {
        return this.cNames.length;
    }

    @Override
    public String getColumnName(int column) {
        return this.cNames[column];
    }

    @Override
    public Class<?> getColumnClass(int column) {
        return this.cClass[column];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRowCount() {
        this.rwl.readLock().lock();
        try {
            int n = this.list.size();
            return n;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        this.rwl.readLock().lock();
        try {
            RecTransaction t = this.list.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    if (t.getReconciled() == ReconciledState.RECONCILED) {
                        String string = "\u2713";
                        return string;
                    }
                    Object var4_5 = null;
                    return var4_5;
                }
                case 1: {
                    String string = this.dateFormatter.format(t.getDate());
                    return string;
                }
                case 2: {
                    String string = t.getNumber();
                    return string;
                }
                case 3: {
                    String string = t.getPayee();
                    return string;
                }
                case 4: {
                    BigDecimal amount = AccountBalanceDisplayManager.convertToSelectedBalanceMode(this.account.getAccountType(), t.getAmount(this.account));
                    String string = this.commodityFormatter.format(amount);
                    return string;
                }
            }
            Object var5_11 = null;
            return var5_11;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void messagePosted(final Message event) {
        if (event.getObject(MessageProperty.ACCOUNT).equals(this.account)) {
            this.rwl.writeLock().lock();
            try {
                final Transaction transaction = (Transaction)event.getObject(MessageProperty.TRANSACTION);
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        switch (event.getEvent()) {
                            case TRANSACTION_REMOVE: {
                                RecTransaction trans = AbstractReconcileTableModel.this.findTransaction(transaction);
                                if (trans == null) break;
                                int index = AbstractReconcileTableModel.this.list.indexOf(trans);
                                AbstractReconcileTableModel.this.list.remove(index);
                                AbstractReconcileTableModel.this.fireTableRowsDeleted(index, index);
                                break;
                            }
                            case TRANSACTION_ADD: {
                                if (!AbstractReconcileTableModel.this.isShowable(transaction)) break;
                                RecTransaction newTran = new RecTransaction(transaction);
                                int index = Collections.binarySearch(AbstractReconcileTableModel.this.list, newTran);
                                if (index >= 0) break;
                                index = -index - 1;
                                AbstractReconcileTableModel.this.list.add(index, newTran);
                                AbstractReconcileTableModel.this.fireTableRowsInserted(index, index);
                                break;
                            }
                        }
                    }
                });
            }
            finally {
                this.rwl.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal getReconciledTotal() {
        BigDecimal sum = BigDecimal.ZERO;
        this.rwl.readLock().lock();
        try {
            for (RecTransaction t : this.list) {
                if (t.getReconciled() != ReconciledState.RECONCILED) continue;
                sum = sum.add(t.getAmount(this.account));
            }
        }
        finally {
            this.rwl.readLock().unlock();
        }
        return AccountBalanceDisplayManager.convertToSelectedBalanceMode(this.account.getAccountType(), sum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized RecTransaction findTransaction(Transaction t) {
        this.rwl.readLock().lock();
        try {
            if (t != null) {
                for (RecTransaction tran : this.list) {
                    if (tran.transaction != t) continue;
                    RecTransaction recTransaction = tran;
                    return recTransaction;
                }
            }
            RecTransaction recTransaction = null;
            return recTransaction;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void toggleReconciledState(int index) {
        this.rwl.readLock().lock();
        try {
            RecTransaction t = this.list.get(index);
            if (t.getReconciled() == ReconciledState.RECONCILED) {
                t.setReconciled(ReconciledState.NOT_RECONCILED);
            } else {
                t.setReconciled(ReconciledState.RECONCILED);
            }
            this.fireTableRowsUpdated(index, index);
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void selectAll() {
        this.rwl.readLock().lock();
        try {
            for (RecTransaction tran : this.list) {
                tran.setReconciled(ReconciledState.RECONCILED);
            }
            this.fireTableRowsUpdated(0, this.list.size() - 1);
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearAll() {
        this.rwl.readLock().lock();
        try {
            for (RecTransaction tran : this.list) {
                tran.setReconciled(ReconciledState.NOT_RECONCILED);
            }
            this.fireTableRowsUpdated(0, this.list.size() - 1);
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void commitChanges() {
        Engine engine = EngineFactory.getEngine("default");
        RecTransaction[] transactions = null;
        this.rwl.readLock().lock();
        try {
            transactions = this.list.toArray(new RecTransaction[this.list.size()]);
        }
        finally {
            this.rwl.readLock().unlock();
        }
        if (transactions != null) {
            for (RecTransaction transaction : transactions) {
                if (transaction.getReconciled() == transaction.transaction.getReconciled(this.account)) continue;
                engine.setTransactionReconciled(transaction.transaction, this.account, transaction.getReconciled());
            }
        }
    }

    private class RecTransaction
    implements Comparable<RecTransaction> {
        private ReconciledState reconciled;
        Transaction transaction;

        protected RecTransaction(Transaction transaction) {
            assert (transaction != null);
            this.transaction = transaction;
            this.reconciled = transaction.getReconciled(AbstractReconcileTableModel.this.account);
        }

        public Date getDate() {
            return this.transaction.getDate();
        }

        public String getNumber() {
            return this.transaction.getNumber();
        }

        public String getPayee() {
            return this.transaction.getPayee();
        }

        public ReconciledState getReconciled() {
            return this.reconciled;
        }

        public void setReconciled(ReconciledState reconciled) {
            this.reconciled = reconciled;
        }

        BigDecimal getAmount(Account a) {
            if (this.transaction instanceof InvestmentTransaction && a.memberOf(AccountGroup.INVEST)) {
                return ((InvestmentTransaction)this.transaction).getMarketValue(this.transaction.getDate()).add(this.transaction.getAmount(a));
            }
            return this.transaction.getAmount(a);
        }

        public int hashCode() {
            return this.transaction.hashCode();
        }

        public boolean equals(Object obj) {
            boolean result = false;
            if (obj != null && obj instanceof RecTransaction) {
                RecTransaction other = (RecTransaction)obj;
                if (this.transaction != null && other.transaction != null && this.transaction.equals(other.transaction) && this.reconciled == other.reconciled) {
                    result = true;
                }
            }
            return result;
        }

        @Override
        public int compareTo(RecTransaction t) {
            return this.transaction.compareTo(t.transaction);
        }
    }
}

