/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.register.invest;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import jgnash.engine.Account;
import jgnash.engine.AccountGroup;
import jgnash.engine.Transaction;
import jgnash.message.MessageBus;
import jgnash.message.MessageChannel;
import jgnash.text.CommodityFormat;
import jgnash.ui.account.AccountSecuritiesDialog;
import jgnash.ui.components.ShadowBorder;
import jgnash.ui.register.AbstractRegisterPanel;
import jgnash.ui.register.RegisterEvent;
import jgnash.ui.register.RegisterFactory;
import jgnash.ui.register.RegisterListener;
import jgnash.ui.register.invest.InvestmentTransactionPanel;
import jgnash.ui.register.table.AbstractRegisterTableModel;
import jgnash.ui.register.table.RegisterTable;

public class InvestmentRegisterPanel
extends AbstractRegisterPanel
implements ActionListener {
    private JButton newButton;
    private JButton deleteButton;
    private JButton securitiesButton;
    private JLabel marketValue;
    private JLabel accountPath;
    private JLabel cashBalance;
    private JLabel accountBalance;
    private JPanel buttonPanel;
    private JButton duplicateButton;
    private JScrollPane jScrollPane;
    private CommodityFormat fullFormat = CommodityFormat.getFullFormat();
    private Account account;
    private AbstractRegisterTableModel model;
    private RegisterTable table;
    private InvestmentTransactionPanel transactionPanel;

    public InvestmentRegisterPanel(Account acc) {
        if (!acc.memberOf(AccountGroup.INVEST)) {
            throw new IllegalArgumentException("Not an InvestmentAccount");
        }
        this.account = acc;
        this.table = RegisterFactory.generateTable(this.account);
        this.model = (AbstractRegisterTableModel)this.table.getModel();
        this.table.addKeyListener(this);
        this.transactionPanel = new InvestmentTransactionPanel(this.account);
        this.transactionPanel.addRegisterListener(new RegisterListener(){

            @Override
            public void registerEvent(RegisterEvent e) {
                if (e.getAction() == RegisterEvent.Action.CANCEL) {
                    InvestmentRegisterPanel.this.table.clearSelection();
                }
            }
        });
        this.deleteButton = new JButton(this.rb.getString("Button.Delete"));
        this.duplicateButton = new JButton(this.rb.getString("Button.Duplicate"));
        this.newButton = new JButton(this.rb.getString("Button.New"));
        this.securitiesButton = new JButton(this.rb.getString("Button.AvailSecurities"));
        this.accountPath = new JLabel();
        this.marketValue = new JLabel();
        this.cashBalance = new JLabel();
        this.accountBalance = new JLabel();
        this.jScrollPane = new JScrollPane(this.table);
        this.jScrollPane.setBorder(new ShadowBorder());
        this.table.scrollRectToVisible(this.table.getCellRect(this.table.getRowCount() - 1, 0, true));
        this.layoutMainPanel();
        this.updateAccountState();
        this.deleteButton.addActionListener(this);
        this.duplicateButton.addActionListener(this);
        this.newButton.addActionListener(this);
        this.securitiesButton.addActionListener(this);
        this.installPopupHandler();
        this.updateAccountInfo();
        MessageBus.getInstance().registerListener(this, MessageChannel.ACCOUNT, MessageChannel.COMMODITY, MessageChannel.TRANSACTION);
    }

    private void layoutMainPanel() {
        FormLayout layout = new FormLayout("p:g", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout, (JPanel)this);
        builder.setDefaultDialogBorder();
        builder.append((Component)this.createTopPanel());
        builder.nextLine();
        builder.appendRelatedComponentsGapRow();
        builder.nextLine();
        builder.appendRow(RowSpec.decode((String)"fill:60dlu:g"));
        builder.append((Component)this.jScrollPane);
        builder.append((Component)this.createButtonPanel());
        builder.append((Component)this.transactionPanel);
    }

    private JPanel createTopPanel() {
        FormLayout layout = new FormLayout("45dlu:g, 8dlu, d, 4dlu, d, 8dlu, d, 4dlu, right:d, 8dlu, d, 4dlu, right:d", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.append((Component)this.accountPath);
        builder.append(this.rb.getString("Label.Balance"), (Component)this.accountBalance);
        builder.append(this.rb.getString("Label.MarketValue"), (Component)this.marketValue);
        builder.append(this.rb.getString("Label.CashBalance"), (Component)this.cashBalance);
        return builder.getPanel();
    }

    private JPanel createButtonPanel() {
        this.buttonPanel = ButtonBarFactory.buildLeftAlignedBar((JButton[])new JButton[]{this.newButton, this.deleteButton, this.duplicateButton, this.securitiesButton});
        return this.buttonPanel;
    }

    @Override
    public AbstractRegisterTableModel getTableModel() {
        return this.model;
    }

    @Override
    protected final void updateAccountInfo() {
        BigDecimal cash = this.account.getCashBalance().setScale((int)this.getAccountCurrencyNode().getScale(), 6);
        BigDecimal market = this.account.getMarketValue();
        this.accountPath.setText(this.account.getName());
        this.accountPath.setToolTipText(this.getAccountPath());
        this.marketValue.setText(this.fullFormat.format(market, this.getAccountCurrencyNode()));
        this.cashBalance.setText(this.fullFormat.format(cash, this.getAccountCurrencyNode()));
        this.accountBalance.setText(this.fullFormat.format(cash.add(market), this.getAccountCurrencyNode()));
    }

    @Override
    protected Account getAccount() {
        return this.account;
    }

    @Override
    protected void modifyTransaction(int index) {
        Transaction t = this.model.getTransactionAt(index);
        this.transactionPanel.modifyTransaction(t);
    }

    @Override
    protected void clear() {
        this.transactionPanel.cancelAction();
        this.table.clearSelection();
    }

    private void addRemoveSecurities() {
        AccountSecuritiesDialog.showDialog(this.getAccount(), this);
    }

    @Override
    protected final void updateAccountState() {
        this.buttonPanel.setVisible(!this.account.isLocked());
        this.transactionPanel.setVisible(!this.account.isLocked());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.deleteButton) {
            this.deleteAction();
        } else if (e.getSource() == this.newButton) {
            this.clear();
        } else if (e.getSource() == this.duplicateButton) {
            this.duplicateAction();
        } else if (e.getSource() == this.securitiesButton) {
            this.addRemoveSecurities();
        }
    }

    @Override
    public RegisterTable getTable() {
        return this.table;
    }
}

