/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.register.table;

import java.util.Date;
import javax.swing.event.TableModelListener;
import jgnash.engine.Account;
import jgnash.engine.Transaction;
import jgnash.ui.register.table.AbstractRegisterTableModel;
import jgnash.ui.register.table.ClippingModel;
import jgnash.util.DateUtils;

public final class ClippingDecorator
implements ClippingModel {
    private AbstractRegisterTableModel model;
    private Date endDate = new Date();
    private Date startDate = new Date();
    private int startIndex = 0;
    private int endIndex = 0;

    public ClippingDecorator(AbstractRegisterTableModel model) {
        this.model = model;
        if (model.getRowCount() > 0) {
            this.startDate = model.getTransactionAt(0).getDate();
            this.endIndex = model.getRowCount() - 1;
            this.endDate = this.getEndDate();
        }
    }

    @Override
    public void setStartDate(Date startDate) {
        this.findStartIndex(startDate);
    }

    @Override
    public void setStartIndex(int start) {
        this.startIndex = start;
    }

    @Override
    public Date getStartDate() {
        Date date = new Date();
        if (this.model.getRowCount() > 0) {
            date = this.model.getTransactionAt(this.startIndex).getDate();
        }
        return date;
    }

    @Override
    public void setEndDate(Date stopDate) {
        this.findStopIndex(stopDate);
    }

    @Override
    public void setEndIndex(int end) {
        this.endIndex = end;
    }

    @Override
    public Date getEndDate() {
        Date date = new Date();
        if (this.model.getRowCount() > 0) {
            date = this.model.getTransactionAt(this.endIndex).getDate();
        }
        return date;
    }

    @Override
    public void setReconcileSymbol(String reconcileSymbol) {
        this.model.setReconcileSymbol(reconcileSymbol);
    }

    @Override
    public int[] getPreferredColumnWeights() {
        return this.model.getPreferredColumnWeights();
    }

    @Override
    public Account getAccount() {
        return this.model.getAccount();
    }

    @Override
    public int getRowCount() {
        if (this.model.getAccount().getTransactionCount() == 0) {
            return 0;
        }
        if (this.endIndex == this.startIndex) {
            Transaction t = this.getAccount().getTransactionAt(this.getAccount().getTransactionCount() - 1);
            if (DateUtils.before(t.getDate(), this.startDate, false)) {
                return 0;
            }
            t = this.model.getTransactionAt(this.startIndex);
            if (DateUtils.after(t.getDate(), this.startDate, true) && DateUtils.before(t.getDate(), this.endDate, true)) {
                return 1;
            }
            return 0;
        }
        return this.endIndex - this.startIndex + 1;
    }

    @Override
    public int getColumnCount() {
        return this.model.getColumnCount();
    }

    @Override
    public String getColumnName(int col) {
        return this.model.getColumnName(col);
    }

    @Override
    public Class<?> getColumnClass(int col) {
        return this.model.getColumnClass(col);
    }

    @Override
    public boolean isCellEditable(int arg0, int arg1) {
        return this.model.isCellEditable(arg0, arg1);
    }

    @Override
    public Object getValueAt(int row, int col) {
        return this.model.getValueAt(row + this.startIndex, col);
    }

    @Override
    public void setValueAt(Object arg0, int arg1, int arg2) {
        this.model.setValueAt(arg0, arg1, arg2);
    }

    @Override
    public void addTableModelListener(TableModelListener arg0) {
        this.model.addTableModelListener(arg0);
    }

    @Override
    public void removeTableModelListener(TableModelListener arg0) {
        this.model.removeTableModelListener(arg0);
    }

    private void findStartIndex(Date date) {
        this.startDate = date;
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            Transaction t = this.model.getTransactionAt(i);
            if (!DateUtils.after(t.getDate(), date, true)) continue;
            this.startIndex = i;
            return;
        }
        this.startIndex = this.model.getRowCount() - 1;
    }

    private void findStopIndex(Date date) {
        this.endDate = date;
        for (int i = this.model.getRowCount() - 1; i >= 0; --i) {
            Transaction t = this.model.getTransactionAt(i);
            if (!DateUtils.before(t.getDate(), date, true)) continue;
            this.endIndex = i;
            return;
        }
        this.endIndex = this.model.getRowCount() - 1;
    }
}

