/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.report.compiled;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import jgnash.engine.Account;
import jgnash.engine.AccountGroup;
import jgnash.engine.AccountType;
import jgnash.engine.Comparators;
import jgnash.engine.CurrencyNode;
import jgnash.engine.Engine;
import jgnash.engine.EngineFactory;
import jgnash.ui.components.DatePanel;
import jgnash.ui.report.AbstractReportTableModel;
import jgnash.ui.report.ColumnHeaderStyle;
import jgnash.ui.report.ColumnStyle;
import jgnash.ui.report.jasper.DynamicJasperReport;
import jgnash.util.DateUtils;
import jgnash.util.Resource;
import net.sf.jasperreports.engine.JasperPrint;

abstract class AbstractCrosstabReport
extends DynamicJasperReport {
    private DatePanel startDateField;
    private DatePanel endDateField;
    private JButton refreshButton;
    private JCheckBox hideZeroBalanceAccounts;
    private final String RES_YEAR;
    private final String RES_QUARTER;
    private final String RES_MONTH;
    private final String SORT_ORDER_NAME;
    private final String SORT_ORDER_BALANCE_DESC;
    private final String SORT_ORDER_BALANCE_DESC_WITH_PERCENTILE;
    private JComboBox resolutionList;
    private JComboBox sortOrderList;
    private JCheckBox showLongNamesCheckBox;
    private Map<Account, Double> percentileMap;
    private final ArrayList<Date> startDates;
    private final ArrayList<Date> endDates;
    private final ArrayList<String> dateLabels;
    private static final String HIDE_ZERO_BALANCE = "hideZeroBalance";
    private static final String MONTHS = "months";
    private static final String USE_LONG_NAMES = "useLongNames";
    public ColumnInfo[] columns;

    public AbstractCrosstabReport() {
        this.RES_YEAR = this.rb.getString("Word.Yearly");
        this.RES_QUARTER = this.rb.getString("Word.Quarterly");
        this.RES_MONTH = this.rb.getString("Word.Monthly");
        this.SORT_ORDER_NAME = this.rb.getString("SortOrder.AccountName");
        this.SORT_ORDER_BALANCE_DESC = this.rb.getString("SortOrder.AccountBalanceDesc");
        this.SORT_ORDER_BALANCE_DESC_WITH_PERCENTILE = this.rb.getString("SortOrder.AccountBalanceDescWithPercentile");
        this.percentileMap = new HashMap<Account, Double>();
        this.startDates = new ArrayList();
        this.endDates = new ArrayList();
        this.dateLabels = new ArrayList();
        Preferences p = this.getPreferences();
        Date startDate = new Date();
        startDate = DateUtils.subtractYear(startDate);
        this.startDateField = new DatePanel();
        this.endDateField = new DatePanel();
        this.startDateField.setDate(startDate);
        this.hideZeroBalanceAccounts = new JCheckBox(Resource.get().getString("Button.HideZeroBalance"));
        this.hideZeroBalanceAccounts.setSelected(p.getBoolean(HIDE_ZERO_BALANCE, true));
        this.showLongNamesCheckBox = new JCheckBox(this.rb.getString("Button.UseLongNames"));
        this.showLongNamesCheckBox.setSelected(p.getBoolean(USE_LONG_NAMES, false));
        this.resolutionList = new JComboBox<String>(new String[]{this.RES_YEAR, this.RES_QUARTER, this.RES_MONTH});
        this.resolutionList.setSelectedIndex(1);
        this.sortOrderList = new JComboBox<String>(new String[]{this.SORT_ORDER_NAME, this.SORT_ORDER_BALANCE_DESC, this.SORT_ORDER_BALANCE_DESC_WITH_PERCENTILE});
        this.sortOrderList.setSelectedIndex(0);
        this.refreshButton = new JButton(this.rb.getString("Button.Refresh"), Resource.getIcon("/jgnash/resource/view-refresh.png"));
        this.refreshButton.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent ae) {
                AbstractCrosstabReport.this.refreshReport();
            }
        });
    }

    @Override
    public String getSubTitle() {
        MessageFormat format = new MessageFormat(this.rb.getString("Pattern.DateRange"));
        Object[] args = new Object[]{this.startDates.get(0), this.endDates.get(this.endDates.size() - 1)};
        return format.format(args);
    }

    @Override
    protected void refreshReport() {
        Preferences p = this.getPreferences();
        p.putBoolean(HIDE_ZERO_BALANCE, this.hideZeroBalanceAccounts.isSelected());
        p.putBoolean(USE_LONG_NAMES, this.showLongNamesCheckBox.isSelected());
        p.putInt(MONTHS, DateUtils.getLastDayOfTheMonths(this.startDateField.getDate(), this.endDateField.getDate()).size());
        super.refreshReport();
    }

    protected abstract List<AccountGroup> getAccountGroups();

    private void updateResolution() {
        this.startDates.clear();
        this.endDates.clear();
        this.dateLabels.clear();
        String currentResolution = (String)this.resolutionList.getSelectedItem();
        Calendar cal = Calendar.getInstance();
        Date globalStart = this.startDateField.getDate();
        Date globalEnd = this.endDateField.getDate();
        Calendar globalStartCal = Calendar.getInstance();
        globalStartCal.setTime(globalStart);
        Calendar globalEndCal = Calendar.getInstance();
        globalEndCal.setTime(globalEnd);
        Date start = new Date(globalStart.getTime());
        Date end = new Date(globalStart.getTime());
        if (this.RES_YEAR.equals(currentResolution)) {
            while (end.before(globalEnd)) {
                this.startDates.add(start);
                end = DateUtils.getLastDayOfTheYear(start);
                this.endDates.add(end);
                cal.setTime(start);
                this.dateLabels.add("    " + cal.get(1));
                start = DateUtils.addDay(end);
            }
        } else if (this.RES_QUARTER.equals(currentResolution)) {
            int i = DateUtils.getQuarterNumber(start) - 1;
            while (end.before(globalEnd)) {
                this.startDates.add(start);
                end = DateUtils.getLastDayOfTheQuarter(start);
                this.endDates.add(end);
                cal.setTime(start);
                this.dateLabels.add(" " + cal.get(1) + "-Q" + (1 + i++ % 4));
                start = DateUtils.addDay(end);
            }
        } else if (this.RES_MONTH.equals(currentResolution)) {
            while (end.before(globalEnd)) {
                this.startDates.add(start);
                end = DateUtils.getLastDayOfTheMonth(start);
                this.endDates.add(end);
                cal.setTime(start);
                int month = cal.get(2);
                this.dateLabels.add(" " + cal.get(1) + (month < 9 ? "/0" + (month + 1) : "/" + (month + 1)));
                start = DateUtils.addDay(end);
            }
        }
        assert (this.startDates.size() == this.endDates.size() && this.startDates.size() == this.dateLabels.size());
        if (this.endDates.get(this.startDates.size() - 1).compareTo(globalEnd) > 0) {
            this.endDates.set(this.endDates.size() - 1, globalEnd);
        }
    }

    private ReportModel createTableModel() {
        logger.info(this.rb.getString("Message.CollectingReportData"));
        CurrencyNode baseCurrency = EngineFactory.getEngine("default").getDefaultCurrency();
        ArrayList<Account> accounts = new ArrayList<Account>();
        String sortOrder = this.sortOrderList.getSelectedItem().toString();
        boolean needPercentiles = this.SORT_ORDER_BALANCE_DESC_WITH_PERCENTILE.equals(sortOrder);
        for (AccountGroup group : this.getAccountGroups()) {
            List<Account> list = this.getAccountList(AccountType.getAccountTypes(group));
            boolean ascendingSortOrder = true;
            if (list.size() > 0 && list.get(0).getAccountType() == AccountType.EXPENSE) {
                ascendingSortOrder = false;
            }
            if (this.SORT_ORDER_NAME.equals(sortOrder)) {
                if (!this.showLongNamesCheckBox.isSelected()) {
                    Collections.sort(list, Comparators.getAccountByName());
                } else {
                    Collections.sort(list, Comparators.getAccountByPathName());
                }
            } else if (this.SORT_ORDER_BALANCE_DESC.equals(sortOrder) || this.SORT_ORDER_BALANCE_DESC_WITH_PERCENTILE.equals(sortOrder)) {
                Collections.sort(list, Comparators.getAccountByBalance(this.startDateField.getDate(), this.endDateField.getDate(), baseCurrency, ascendingSortOrder));
            }
            if (needPercentiles) {
                BigDecimal groupTotal = BigDecimal.ZERO;
                for (Account a : list) {
                    groupTotal = groupTotal.add(a.getBalance(this.startDateField.getDate(), this.endDateField.getDate(), baseCurrency));
                }
                BigDecimal sumSoFar = BigDecimal.ZERO;
                for (Account a : list) {
                    sumSoFar = sumSoFar.add(a.getBalance(this.startDateField.getDate(), this.endDateField.getDate(), baseCurrency));
                    this.percentileMap.put(a, sumSoFar.doubleValue() / groupTotal.doubleValue());
                }
            }
            accounts.addAll(list);
        }
        this.updateResolution();
        if (this.hideZeroBalanceAccounts.isSelected()) {
            Iterator i = accounts.iterator();
            while (i.hasNext()) {
                Account account = (Account)i.next();
                boolean remove = true;
                for (int j = 0; j < this.endDates.size(); ++j) {
                    if (account.getBalance(this.startDates.get(j), this.endDates.get(j)).compareTo(BigDecimal.ZERO) == 0) continue;
                    remove = false;
                    break;
                }
                if (!remove) continue;
                i.remove();
            }
        }
        LinkedList<AccountNameColumnInfo> columnsList = new LinkedList<AccountNameColumnInfo>();
        ColumnInfo ci = new AccountNameColumnInfo(accounts);
        ci.columnName = this.rb.getString("Column.Account");
        ci.headerStyle = ColumnHeaderStyle.LEFT;
        ci.columnClass = String.class;
        ci.columnStyle = ColumnStyle.STRING;
        ci.isFixedWidth = false;
        columnsList.add((AccountNameColumnInfo)ci);
        for (int i = 0; i < this.dateLabels.size(); ++i) {
            ci = new DateRangeBalanceColumnInfo(accounts, this.startDates.get(i), this.endDates.get(i), baseCurrency);
            ci.columnName = this.dateLabels.get(i);
            ci.headerStyle = ColumnHeaderStyle.RIGHT;
            ci.columnClass = BigDecimal.class;
            ci.columnStyle = ColumnStyle.BALANCE_WITH_SUM_AND_GLOBAL;
            ci.isFixedWidth = true;
            columnsList.add((AccountNameColumnInfo)ci);
        }
        ci = new CrossTabAmountColumnInfo(accounts, baseCurrency);
        ci.columnName = "";
        ci.headerStyle = ColumnHeaderStyle.RIGHT;
        ci.columnClass = BigDecimal.class;
        ci.columnStyle = ColumnStyle.CROSSTAB_TOTAL;
        ci.isFixedWidth = true;
        columnsList.add((AccountNameColumnInfo)ci);
        if (needPercentiles) {
            ci = new PercentileColumnInfo(accounts);
            ci.columnName = "Percentile";
            ci.headerStyle = ColumnHeaderStyle.RIGHT;
            ci.columnClass = String.class;
            ci.columnStyle = ColumnStyle.CROSSTAB_TOTAL;
            ci.isFixedWidth = true;
            columnsList.add((AccountNameColumnInfo)ci);
        }
        ci = new GroupColumnInfo(accounts);
        ci.columnName = "Type";
        ci.headerStyle = ColumnHeaderStyle.CENTER;
        ci.columnClass = String.class;
        ci.columnStyle = ColumnStyle.GROUP;
        ci.isFixedWidth = false;
        columnsList.add((AccountNameColumnInfo)ci);
        this.columns = columnsList.toArray(new ColumnInfo[columnsList.size()]);
        return new ReportModel(accounts, baseCurrency);
    }

    private List<Account> getAccountList(Set<AccountType> types) {
        Engine engine = EngineFactory.getEngine("default");
        List<Account> accounts = engine.getAccountList();
        Iterator<Account> i = accounts.iterator();
        block0: while (i.hasNext()) {
            Account a = i.next();
            if (a.getTransactionCount() == 0) {
                i.remove();
                continue;
            }
            for (AccountType t : types) {
                if (a.getAccountType() != t) continue;
                continue block0;
            }
            i.remove();
        }
        return accounts;
    }

    @Override
    public JasperPrint createJasperPrint(boolean formatForCSV) {
        ReportModel model = this.createTableModel();
        return this.createJasperPrint(model, formatForCSV);
    }

    @Override
    public JPanel getReportController() {
        FormLayout layout = new FormLayout("p, 4dlu, max(p;45dlu), 8dlu, p, 4dlu, max(p;45dlu), 8dlu, p, 4dlu, p, 8dlu, p, p", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setDefaultDialogBorder();
        builder.append(this.rb.getString("Label.StartDate"), (Component)this.startDateField);
        builder.append(this.rb.getString("Label.EndDate"), (Component)this.endDateField);
        builder.append(this.rb.getString("Label.Resolution"), (Component)this.resolutionList);
        builder.append((Component)this.refreshButton);
        builder.nextLine();
        builder.append(this.rb.getString("Label.SortOrder"), (Component)this.sortOrderList);
        builder.append((Component)this.showLongNamesCheckBox, 4);
        builder.append((Component)this.hideZeroBalanceAccounts, 4);
        return builder.getPanel();
    }

    private class PercentileColumnInfo
    extends ColumnInfo {
        private final List<Account> accounts;

        public PercentileColumnInfo(List<Account> accounts) {
            this.accounts = accounts;
        }

        @Override
        public Object getValue(int rowIndex) {
            Double percentile = (Double)AbstractCrosstabReport.this.percentileMap.get(this.accounts.get(rowIndex));
            return String.format("%.2f%%", percentile * 100.0);
        }
    }

    private class DateRangeBalanceColumnInfo
    extends ColumnInfo {
        private final List<Account> accountList;
        private final Date startDate;
        private final Date endDate;
        private final CurrencyNode currency;

        public DateRangeBalanceColumnInfo(List<Account> accountList, Date startDate, Date endDate, CurrencyNode currency) {
            this.accountList = accountList;
            this.startDate = startDate;
            this.endDate = endDate;
            this.currency = currency;
        }

        @Override
        public Object getValue(int rowIndex) {
            Account a = this.accountList.get(rowIndex);
            return a.getBalance(this.startDate, this.endDate, this.currency).negate();
        }
    }

    private class GroupColumnInfo
    extends ColumnInfo {
        private final List<Account> accountList;

        public GroupColumnInfo(List<Account> accountList) {
            this.accountList = accountList;
        }

        @Override
        public Object getValue(int rowIndex) {
            Account a = this.accountList.get(rowIndex);
            return a.getAccountType().getAccountGroup().toString();
        }
    }

    private class CrossTabAmountColumnInfo
    extends ColumnInfo {
        private final List<Account> accountList;
        private final CurrencyNode currency;

        public CrossTabAmountColumnInfo(List<Account> accountList, CurrencyNode currency) {
            this.accountList = accountList;
            this.currency = currency;
        }

        @Override
        public Object getValue(int rowIndex) {
            Account a = this.accountList.get(rowIndex);
            Date startDate = (Date)AbstractCrosstabReport.this.startDates.get(0);
            Date endDate = (Date)AbstractCrosstabReport.this.endDates.get(AbstractCrosstabReport.this.endDates.size() - 1);
            return a.getBalance(startDate, endDate, this.currency).negate();
        }
    }

    private class AccountNameColumnInfo
    extends ColumnInfo {
        private final List<Account> accountList;

        public AccountNameColumnInfo(List<Account> accountList) {
            this.accountList = accountList;
        }

        @Override
        public Object getValue(int rowIndex) {
            Account a = this.accountList.get(rowIndex);
            if (AbstractCrosstabReport.this.showLongNamesCheckBox.isSelected()) {
                return a.getPathName();
            }
            return a.getName();
        }
    }

    private abstract class ColumnInfo {
        public ColumnHeaderStyle headerStyle;
        public ColumnStyle columnStyle;
        public Class<?> columnClass;
        public String columnName;
        public boolean isFixedWidth;

        private ColumnInfo() {
        }

        public abstract Object getValue(int var1);
    }

    private class ReportModel
    extends AbstractReportTableModel {
        private CurrencyNode baseCurrency;
        private List<Account> accountList = Collections.emptyList();
        private static final long serialVersionUID = -2526030825754030630L;

        protected ReportModel(List<Account> accountList, CurrencyNode currency) {
            this.accountList = accountList;
            this.baseCurrency = currency;
        }

        @Override
        public CurrencyNode getCurrency() {
            return this.baseCurrency;
        }

        @Override
        public int getRowCount() {
            return this.accountList.size();
        }

        @Override
        public int getColumnCount() {
            return AbstractCrosstabReport.this.columns.length;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return AbstractCrosstabReport.this.columns[columnIndex].columnName;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return AbstractCrosstabReport.this.columns[columnIndex].columnClass;
        }

        @Override
        public ColumnStyle getColumnStyle(int columnIndex) {
            return AbstractCrosstabReport.this.columns[columnIndex].columnStyle;
        }

        @Override
        public ColumnHeaderStyle getColumnHeaderStyle(int columnIndex) {
            return AbstractCrosstabReport.this.columns[columnIndex].headerStyle;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return AbstractCrosstabReport.this.columns[columnIndex].getValue(rowIndex);
        }

        @Override
        public boolean isColumnFixedWidth(int columnIndex) {
            return AbstractCrosstabReport.this.columns[columnIndex].isFixedWidth;
        }
    }
}

