/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.report.compiled;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.filechooser.FileNameExtensionFilter;
import jgnash.engine.Account;
import jgnash.engine.AccountType;
import jgnash.engine.CurrencyNode;
import jgnash.engine.Engine;
import jgnash.engine.EngineFactory;
import jgnash.engine.RootAccount;
import jgnash.text.CommodityFormat;
import jgnash.ui.components.JDateField;
import jgnash.ui.register.AccountBalanceDisplayManager;
import jgnash.util.DateUtils;
import jgnash.util.Resource;

public class ProfitLossTXT {
    private NumberFormat numberFormat;
    private static final boolean SHOW_EMPTY_ACCOUNT = false;
    private ArrayList<BigDecimal> balance = new ArrayList();
    private ArrayList<String> pl = new ArrayList();
    private CurrencyNode baseCommodity;
    private Date[] dates;
    private final Resource rb = Resource.get();

    public void run() {
        this.createReport();
        this.writePLFile(this.getFileName());
    }

    private void createReport() {
        Engine engine = EngineFactory.getEngine("default");
        RootAccount root = engine.getRootAccount();
        this.baseCommodity = engine.getDefaultCurrency();
        this.numberFormat = CommodityFormat.getFullNumberFormat(this.baseCommodity);
        SimpleDateFormat df = new SimpleDateFormat("dd-MMMMM-yyyy");
        this.dates = this.getDates();
        this.pl.add(this.rb.getString("Title.ProfitLoss"));
        this.pl.add("");
        this.pl.add("From " + df.format(this.dates[0]) + " To " + df.format(this.dates[1]));
        this.pl.add("");
        this.pl.add("");
        this.pl.add("Income");
        this.pl.add("------------------------------------------------------");
        this.getBalances(root, this.dates, AccountType.INCOME);
        BigDecimal total1 = BigDecimal.ZERO;
        for (BigDecimal aBalance1 : this.balance) {
            total1 = total1.add(aBalance1);
        }
        this.pl.add("------------------------------------------------------");
        this.pl.add(ProfitLossTXT.formatAcctNameOut(this.rb.getString("Word.GrossIncome")) + " " + this.formatDecimalOut(total1));
        this.pl.add("------------------------------------------------------");
        this.pl.add("");
        this.pl.add("");
        this.pl.add("Expenses");
        this.pl.add("------------------------------------------------------");
        this.balance = new ArrayList();
        this.getBalances(root, this.dates, AccountType.EXPENSE);
        BigDecimal total2 = BigDecimal.ZERO;
        for (BigDecimal aBalance : this.balance) {
            total2 = total2.add(aBalance);
        }
        this.pl.add("------------------------------------------------------");
        this.pl.add(ProfitLossTXT.formatAcctNameOut(this.rb.getString("Word.GrossExpense")) + " " + this.formatDecimalOut(total2));
        this.pl.add("------------------------------------------------------");
        this.pl.add("");
        this.pl.add("");
        this.pl.add("------------------------------------------------------");
        this.pl.add(ProfitLossTXT.formatAcctNameOut(this.rb.getString("Word.NetIncome")) + " " + this.formatDecimalOut(total1.add(total2)));
        this.pl.add("======================================================");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writePLFile(String fileName) {
        if (fileName == null || this.dates == null) {
            return;
        }
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(fileName)));
            for (String aPl : this.pl) {
                writer.write(aPl.toString());
                writer.newLine();
            }
            writer.newLine();
            writer.close();
        }
        catch (IOException e) {
            Logger.getLogger(ProfitLossTXT.class.getName()).log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException e) {
                Logger.getLogger(ProfitLossTXT.class.getName()).log(Level.SEVERE, e.getLocalizedMessage(), e);
            }
        }
    }

    private static Date[] getLastDays(Date start, Date stop) {
        ArrayList<Date> list = new ArrayList<Date>();
        Date s = DateUtils.trimDate(start);
        Date t = DateUtils.trimDate(stop);
        list.add(s);
        list.add(t);
        return list.toArray(new Date[list.size()]);
    }

    Date[] getDates() {
        Date start = new Date();
        start = DateUtils.subtractYear(start);
        JDateField startField = new JDateField();
        JDateField endField = new JDateField();
        startField.setValue(start);
        FormLayout layout = new FormLayout("right:p, 4dlu, p:g", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setRowGroupingEnabled(true);
        builder.append(this.rb.getString("Label.StartDate"), (Component)startField);
        builder.append(this.rb.getString("Label.EndDate"), (Component)endField);
        builder.nextLine();
        builder.appendUnrelatedComponentsGapRow();
        builder.nextLine();
        JPanel panel = builder.getPanel();
        int option = JOptionPane.showConfirmDialog(null, new Object[]{panel}, this.rb.getString("Message.StartEndDate"), 2, -1);
        if (option == 0) {
            return ProfitLossTXT.getLastDays(startField.dateValue(), endField.dateValue());
        }
        return null;
    }

    String getFileName() {
        JFileChooser chooser = new JFileChooser();
        chooser.setMultiSelectionEnabled(false);
        chooser.addChoosableFileFilter(new FileNameExtensionFilter(this.rb.getString("Message.TXTFile"), "txt"));
        if (chooser.showSaveDialog(null) == 0) {
            String fileName = chooser.getSelectedFile().getAbsolutePath();
            if (!fileName.endsWith(".txt")) {
                fileName = fileName + ".txt";
            }
            return fileName;
        }
        return null;
    }

    private String formatDecimalOut(BigDecimal amt) {
        int maxLen = 15;
        StringBuilder sb = new StringBuilder();
        String formattedAmt = this.numberFormat.format(amt);
        int amtLen = formattedAmt.length();
        if (amtLen < maxLen) {
            for (int ix = amtLen; ix < maxLen; ++ix) {
                sb.append(' ');
            }
        }
        sb.append(formattedAmt);
        return sb.toString();
    }

    private static String formatAcctNameOut(String acctName) {
        int nameLen;
        int maxLen = 30;
        StringBuilder sb = new StringBuilder(maxLen);
        sb.append(acctName);
        for (int ix = nameLen = acctName.length(); ix < maxLen; ++ix) {
            sb.append(' ');
        }
        sb.setLength(maxLen);
        return sb.toString();
    }

    void getBalances(Account a, Date[] dates1, AccountType type) {
        for (Account child : a.getChildren()) {
            int len = child.getTransactionCount();
            if (len > 0 && type == child.getAccountType()) {
                String acctName = child.getName();
                BigDecimal acctBal = AccountBalanceDisplayManager.convertToSelectedBalanceMode(child.getAccountType(), child.getBalance(dates1[0], dates1[1], this.baseCommodity));
                this.pl.add(ProfitLossTXT.formatAcctNameOut(acctName) + " " + this.formatDecimalOut(acctBal));
                this.balance.add(acctBal);
            }
            if (!child.isParent()) continue;
            this.getBalances(child, dates1, type);
        }
    }
}

