/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.wizards.file;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.util.Currency;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.text.StyledEditorKit;
import jgnash.engine.CurrencyNode;
import jgnash.ui.components.SortedComboBoxModel;
import jgnash.ui.components.wizard.WizardPage;
import jgnash.ui.util.TextResource;
import jgnash.ui.wizards.file.NewFileDialog;
import jgnash.util.Resource;

public class NewFileTwo
extends JPanel
implements WizardPage {
    private final Resource rb = Resource.get();
    private JComboBox currencyCombo = new JComboBox();
    private JEditorPane helpPane;

    public NewFileTwo() {
        this.layoutMainPanel();
    }

    private void initComponents() {
        this.helpPane = new JEditorPane();
        this.helpPane.setEditable(false);
        this.helpPane.setEditorKit(new StyledEditorKit());
        this.helpPane.setBackground(this.getBackground());
        this.helpPane.setText(TextResource.getString("NewFileTwo.txt"));
    }

    private void layoutMainPanel() {
        this.initComponents();
        FormLayout layout = new FormLayout("p, 8dlu, f:d:g", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout, (JPanel)this);
        builder.appendSeparator(this.rb.getString("Title.DefDefCurr"));
        builder.nextLine();
        builder.appendRelatedComponentsGapRow();
        builder.nextLine();
        builder.append((Component)this.helpPane, 3);
        builder.nextLine();
        builder.appendRelatedComponentsGapRow();
        builder.nextLine();
        builder.append(this.rb.getString("Label.DefaultCurrency"), (Component)this.currencyCombo);
    }

    @Override
    public boolean isPageValid() {
        return this.currencyCombo.getSelectedItem() != null;
    }

    @Override
    public String toString() {
        return "2. " + this.rb.getString("Title.DefDefCurr");
    }

    @Override
    public void getSettings(Map<Enum<?>, Object> map) {
        Set currencies = (Set)map.get((Object)NewFileDialog.Settings.DEFAULT_CURRENCIES);
        this.currencyCombo.setModel(new SortedComboBoxModel(currencies));
        String currencyCode = Currency.getInstance(Locale.getDefault()).getCurrencyCode();
        for (CurrencyNode node : currencies) {
            if (!currencyCode.equals(node.getSymbol())) continue;
            this.currencyCombo.setSelectedItem(node);
        }
    }

    @Override
    public void putSettings(Map<Enum<?>, Object> map) {
        map.put(NewFileDialog.Settings.DEFAULT_CURRENCY, this.currencyCombo.getSelectedItem());
    }
}

