/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.wizards.imports;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jgnash.engine.Account;
import jgnash.imports.ImportTransaction;
import jgnash.ui.components.wizard.WizardPage;
import jgnash.ui.wizards.imports.ImportDialog;
import jgnash.util.Resource;

public class ImportSummary
extends JPanel
implements WizardPage {
    private Resource rb = Resource.get();
    private JLabel destLabel;
    private JLabel transCount;
    private Account account;
    private List<ImportTransaction> transactions;

    public ImportSummary() {
        this.layoutMainPanel();
    }

    private void initComponents() {
        this.destLabel = new JLabel("Account");
        this.transCount = new JLabel("0");
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent evt) {
                ImportSummary.this.refreshInfo();
            }
        });
    }

    private void layoutMainPanel() {
        this.initComponents();
        FormLayout layout = new FormLayout("p, 8dlu, d:g", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout, (JPanel)this);
        builder.appendSeparator(this.rb.getString("Title.ImpSum"));
        builder.nextLine();
        builder.appendRelatedComponentsGapRow();
        builder.nextLine();
        builder.append(this.rb.getString("Label.DestAccount"), (Component)this.destLabel);
        builder.append(this.rb.getString("Label.NumTrans"), (Component)this.transCount);
    }

    @Override
    public boolean isPageValid() {
        return true;
    }

    void refreshInfo() {
        this.destLabel.setText(this.account.getPathName());
        int count = 0;
        for (ImportTransaction tran : this.transactions) {
            if (tran.getState() != ImportTransaction.ImportState.NEW && tran.getState() != ImportTransaction.ImportState.NOTEQUAL) continue;
            ++count;
        }
        this.transCount.setText(Integer.toString(count));
    }

    @Override
    public String toString() {
        return "3. " + this.rb.getString("Title.ImpSum");
    }

    @Override
    public void getSettings(Map<Enum<?>, Object> map) {
        this.account = (Account)map.get((Object)ImportDialog.Settings.ACCOUNT);
        this.transactions = (List)map.get((Object)ImportDialog.Settings.TRANSACTIONS);
    }

    @Override
    public void putSettings(Map<Enum<?>, Object> map) {
    }
}

