/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.ta;

import com.db4o.activation.Activator;
import com.db4o.config.Configuration;
import com.db4o.config.ConfigurationItem;
import com.db4o.events.ClassEventArgs;
import com.db4o.events.Event4;
import com.db4o.events.EventArgs;
import com.db4o.events.EventListener4;
import com.db4o.events.EventRegistry;
import com.db4o.events.EventRegistryFactory;
import com.db4o.events.ObjectEventArgs;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.InternalObjectContainer;
import com.db4o.internal.Transaction;
import com.db4o.internal.diagnostic.DiagnosticProcessor;
import com.db4o.reflect.ReflectClass;
import com.db4o.reflect.ReflectField;
import com.db4o.ta.Activatable;
import com.db4o.ta.NotTransparentActivationEnabled;

public class TransparentActivationSupport
implements ConfigurationItem {
    public void prepare(Configuration configuration) {
    }

    public void apply(InternalObjectContainer internalObjectContainer) {
        internalObjectContainer.configure().activationDepth(0);
        EventRegistry eventRegistry = EventRegistryFactory.forObjectContainer(internalObjectContainer);
        eventRegistry.instantiated().addListener(new EventListener4(){

            public void onEvent(Event4 event4, EventArgs eventArgs) {
                ObjectEventArgs objectEventArgs = (ObjectEventArgs)eventArgs;
                Object object = objectEventArgs.object();
                if (object instanceof Activatable) {
                    ((Activatable)object).bind(this.activatorForObject((Transaction)objectEventArgs.transaction(), object));
                }
            }

            private Activator activatorForObject(Transaction transaction, Object object) {
                return transaction.referenceForObject(object);
            }
        });
        final TADiagnosticProcessor tADiagnosticProcessor = new TADiagnosticProcessor(internalObjectContainer);
        eventRegistry.classRegistered().addListener(new EventListener4(){

            public void onEvent(Event4 event4, EventArgs eventArgs) {
                ClassEventArgs classEventArgs = (ClassEventArgs)eventArgs;
                tADiagnosticProcessor.onClassRegistered(classEventArgs.classMetadata());
            }
        });
    }

    private final class TADiagnosticProcessor {
        private final InternalObjectContainer _container;

        public TADiagnosticProcessor(InternalObjectContainer internalObjectContainer) {
            this._container = internalObjectContainer;
        }

        public void onClassRegistered(ClassMetadata classMetadata) {
            ReflectClass reflectClass = classMetadata.classReflector();
            if (this.activatableClass().isAssignableFrom(reflectClass)) {
                return;
            }
            if (this.hasOnlyPrimitiveFields(reflectClass)) {
                return;
            }
            NotTransparentActivationEnabled notTransparentActivationEnabled = new NotTransparentActivationEnabled(classMetadata);
            DiagnosticProcessor diagnosticProcessor = this._container.handlers()._diagnosticProcessor;
            diagnosticProcessor.onDiagnostic(notTransparentActivationEnabled);
        }

        private ReflectClass activatableClass() {
            return this._container.reflector().forClass(Activatable.class);
        }

        private boolean hasOnlyPrimitiveFields(ReflectClass reflectClass) {
            for (ReflectClass reflectClass2 = reflectClass; reflectClass2 != null; reflectClass2 = reflectClass2.getSuperclass()) {
                ReflectField[] reflectFieldArray = reflectClass2.getDeclaredFields();
                for (int i = 0; i < reflectFieldArray.length; ++i) {
                    if (reflectFieldArray[i].getFieldType().isPrimitive()) continue;
                    return false;
                }
            }
            return true;
        }
    }
}

