/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.cs.bloat.cfg;

import EDU.purdue.cs.bloat.cfg.Block;
import EDU.purdue.cs.bloat.cfg.FlowGraph;
import EDU.purdue.cs.bloat.tree.GotoStmt;
import EDU.purdue.cs.bloat.tree.IfStmt;
import EDU.purdue.cs.bloat.tree.JsrStmt;
import EDU.purdue.cs.bloat.tree.JumpStmt;
import EDU.purdue.cs.bloat.tree.RetStmt;
import EDU.purdue.cs.bloat.tree.Stmt;
import EDU.purdue.cs.bloat.tree.SwitchStmt;
import EDU.purdue.cs.bloat.tree.Tree;
import EDU.purdue.cs.bloat.tree.TreeVisitor;
import java.util.Iterator;

public class ReplaceTarget
extends TreeVisitor {
    Block oldDst;
    Block newDst;

    public ReplaceTarget(Block oldDst, Block newDst) {
        this.oldDst = oldDst;
        this.newDst = newDst;
    }

    public void visitTree(Tree tree) {
        Stmt last = tree.lastStmt();
        if (last instanceof JumpStmt) {
            JumpStmt stmt = (JumpStmt)last;
            if (FlowGraph.DEBUG) {
                System.out.println("  Replacing " + this.oldDst + " with " + this.newDst + " in " + stmt);
            }
            if (stmt.catchTargets().remove(this.oldDst)) {
                stmt.catchTargets().add(this.newDst);
            }
            stmt.visit(this);
        }
    }

    public void visitJsrStmt(JsrStmt stmt) {
        if (stmt.sub().entry() == this.oldDst) {
            if (FlowGraph.DEBUG) {
                System.out.print("  replacing " + stmt);
            }
            stmt.block().graph().setSubEntry(stmt.sub(), this.newDst);
            if (FlowGraph.DEBUG) {
                System.out.println("   with " + stmt);
            }
        }
    }

    public void visitRetStmt(RetStmt stmt) {
        Iterator paths = stmt.sub().paths().iterator();
        while (paths.hasNext()) {
            Block[] path = (Block[])paths.next();
            if (FlowGraph.DEBUG) {
                System.out.println("  path = " + path[0] + " " + path[1]);
            }
            if (path[1] != this.oldDst) continue;
            if (FlowGraph.DEBUG) {
                System.out.println("  replacing ret to " + this.oldDst + " with ret to " + this.newDst);
            }
            path[1] = this.newDst;
            ((JsrStmt)path[0].tree().lastStmt()).setFollow(this.newDst);
        }
    }

    public void visitGotoStmt(GotoStmt stmt) {
        if (stmt.target() == this.oldDst) {
            if (FlowGraph.DEBUG) {
                System.out.print("  replacing " + stmt);
            }
            stmt.setTarget(this.newDst);
            if (FlowGraph.DEBUG) {
                System.out.println("   with " + stmt);
            }
        }
    }

    public void visitSwitchStmt(SwitchStmt stmt) {
        if (stmt.defaultTarget() == this.oldDst) {
            if (FlowGraph.DEBUG) {
                System.out.print("  replacing " + stmt);
            }
            stmt.setDefaultTarget(this.newDst);
            if (FlowGraph.DEBUG) {
                System.out.println("   with " + stmt);
            }
        }
        Block[] targets = stmt.targets();
        int i = 0;
        while (i < targets.length) {
            if (targets[i] == this.oldDst) {
                if (FlowGraph.DEBUG) {
                    System.out.print("  replacing " + stmt);
                }
                targets[i] = this.newDst;
                if (FlowGraph.DEBUG) {
                    System.out.println("   with " + stmt);
                }
            }
            ++i;
        }
    }

    public void visitIfStmt(IfStmt stmt) {
        if (stmt.trueTarget() == this.oldDst) {
            if (FlowGraph.DEBUG) {
                System.out.print("  replacing " + stmt);
            }
            stmt.setTrueTarget(this.newDst);
            if (FlowGraph.DEBUG) {
                System.out.println("   with " + stmt);
            }
        }
        if (stmt.falseTarget() == this.oldDst) {
            if (FlowGraph.DEBUG) {
                System.out.print("  replacing " + stmt);
            }
            stmt.setFalseTarget(this.newDst);
            if (FlowGraph.DEBUG) {
                System.out.println("   with " + stmt);
            }
        }
    }
}

