/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.cs.bloat.diva;

import EDU.purdue.cs.bloat.cfg.Block;
import EDU.purdue.cs.bloat.cfg.FlowGraph;
import EDU.purdue.cs.bloat.ssa.ComponentVisitor;
import EDU.purdue.cs.bloat.ssa.SSAGraph;
import EDU.purdue.cs.bloat.tree.Expr;
import EDU.purdue.cs.bloat.tree.IfCmpStmt;
import EDU.purdue.cs.bloat.tree.LocalExpr;
import EDU.purdue.cs.bloat.tree.MemExpr;
import EDU.purdue.cs.bloat.tree.Node;
import EDU.purdue.cs.bloat.tree.PhiJoinStmt;
import EDU.purdue.cs.bloat.tree.SCStmt;
import EDU.purdue.cs.bloat.tree.SRStmt;
import EDU.purdue.cs.bloat.tree.StaticFieldExpr;
import EDU.purdue.cs.bloat.tree.Stmt;
import EDU.purdue.cs.bloat.tree.Swizzler;
import EDU.purdue.cs.bloat.tree.Tree;
import EDU.purdue.cs.bloat.tree.TreeVisitor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class InductionVarAnalyzer {
    public static boolean DEBUG = false;
    SSAGraph ssaGraph;
    FlowGraph CFG;
    HashMap IndStore;
    HashMap LocalStore;
    Expr ind_var = null;
    Expr ind_init = null;
    Expr ind_term = null;
    Expr ind_inc = null;
    Expr tgt = null;
    boolean changed = false;

    public Object get_swizzler(int vn) {
        Iterator iter = this.IndStore.values().iterator();
        while (iter.hasNext()) {
            Swizzler swz = (Swizzler)iter.next();
            if (swz.target().valueNumber() != vn && swz.ind_var().valueNumber() != vn) continue;
            return swz;
        }
        return null;
    }

    public MemExpr get_local(int vn) {
        Iterator iter = this.LocalStore.keySet().iterator();
        while (iter.hasNext()) {
            MemExpr le = (MemExpr)iter.next();
            if (le.valueNumber() != vn) continue;
            return le;
        }
        return null;
    }

    public void Display_store() {
        Iterator iter = this.IndStore.values().iterator();
        while (iter.hasNext()) {
            Swizzler indswz = (Swizzler)iter.next();
            System.out.println("\nIV: " + indswz.ind_var() + " tgt: " + indswz.target() + "\narray: " + indswz.array() + " init: " + indswz.init_val() + " end: " + indswz.end_val());
        }
    }

    public void displaySwizzler(Swizzler indswz) {
        System.out.println("\nIV: " + indswz.ind_var() + "vn:" + indswz.ind_var().valueNumber() + " tgt: " + indswz.target() + "vn:" + indswz.target().valueNumber() + "\narray: " + indswz.array() + " init: " + indswz.init_val() + " end: " + indswz.end_val());
    }

    public void insert_aswrange(Swizzler indswz) {
        Iterator iter = this.CFG.preds(indswz.phi_block()).iterator();
        while (iter.hasNext()) {
            Block blk = (Block)iter.next();
            if (indswz.phi_block().dominates(blk)) continue;
            SRStmt aswrange = new SRStmt((Expr)indswz.array().clone(), (Expr)indswz.init_val().clone(), (Expr)indswz.end_val().clone());
            blk.tree().addStmtBeforeJump(aswrange);
            this.changed = true;
            if (!DEBUG) continue;
            System.out.println("Inserted ASWR: " + aswrange + "\nin block: " + blk);
            System.out.println("$$$ can insert aswrange now\narray: " + indswz.array() + "\nIV: " + indswz.ind_var() + "\ninit: " + indswz.init_val() + "\nend: " + indswz.end_val());
        }
    }

    public Block isMu(PhiJoinStmt phi, FlowGraph cfg) {
        if (phi.numOperands() != 2) {
            return null;
        }
        if (cfg.blockType(phi.block()) == 1 || cfg.blockType(phi.block()) == 0) {
            return null;
        }
        Iterator iter = cfg.preds(phi.block()).iterator();
        Block pred1 = (Block)iter.next();
        Block pred2 = (Block)iter.next();
        if (pred1.dominates(phi.block()) && phi.block().dominates(pred2) && pred1 != phi.block()) {
            if (DEBUG) {
                System.out.println("Extlink = 1 pred1:" + pred1 + " pred2:" + pred2);
            }
            this.ind_var = phi.operandAt(pred2);
            this.ind_init = phi.operandAt(pred1);
            return pred1;
        }
        if (pred2.dominates(phi.block()) && phi.block().dominates(pred1) && pred2 != phi.block()) {
            if (DEBUG) {
                System.out.println("Extlink = 2 pred1:" + pred1 + " pred2:" + pred2);
            }
            this.ind_var = phi.operandAt(pred1);
            this.ind_init = phi.operandAt(pred2);
            return pred2;
        }
        return null;
    }

    public void transform(FlowGraph cfg) {
        this.ssaGraph = new SSAGraph(cfg);
        this.CFG = cfg;
        this.IndStore = new HashMap();
        this.LocalStore = new HashMap();
        this.changed = false;
        if (DEBUG) {
            System.out.println("----------Before visitComponents--------------");
            cfg.print(System.out);
        }
        this.ssaGraph.visitComponents(new ComponentVisitor(){

            public void visitComponent(List scc) {
                if (DEBUG) {
                    System.out.println("SCC =");
                }
                Iterator e = scc.iterator();
                while (e.hasNext()) {
                    Node v = (Node)e.next();
                    if (DEBUG) {
                        System.out.println(" " + v + "{" + v.key() + "} " + v.getClass());
                    }
                    v.visit(new TreeVisitor(this){
                        final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void visitPhiJoinStmt(PhiJoinStmt phi) {
                            if (1.access$0(this.this$1).isMu(phi, 1.access$0(this.this$1).CFG) != null) {
                                1.access$0(this.this$1).tgt = phi.target();
                                if (DEBUG) {
                                    System.out.println("IV:" + 1.access$0(this.this$1).ind_var + " VN:" + 1.access$0(this.this$1).ind_var.valueNumber() + "\ninit:" + 1.access$0(this.this$1).ind_init + " target: " + 1.access$0(this.this$1).tgt + " VN: " + 1.access$0(this.this$1).tgt.valueNumber());
                                }
                                Swizzler swz = new Swizzler(1.access$0(this.this$1).ind_var, 1.access$0(this.this$1).tgt, 1.access$0(this.this$1).ind_init, phi.block());
                                if (DEBUG) {
                                    System.out.println("store swizzler for " + 1.access$0(this.this$1).ind_var.def() + " & " + 1.access$0(this.this$1).tgt.def());
                                    1.access$0(this.this$1).displaySwizzler(swz);
                                }
                                if (1.access$0(this.this$1).ind_var.def() != null) {
                                    1.access$0(this.this$1).IndStore.put(1.access$0(this.this$1).ind_var.def(), swz);
                                }
                                if (1.access$0(this.this$1).tgt.def() != null) {
                                    1.access$0(this.this$1).IndStore.put(1.access$0(this.this$1).tgt.def(), swz);
                                }
                                if (DEBUG) {
                                    System.out.println(" Mu: " + phi + "{" + phi.key() + "}");
                                }
                            } else if (DEBUG) {
                                System.out.println("Phi: " + phi + "{" + phi.key() + "}");
                            }
                        }

                        public void visitLocalExpr(LocalExpr me) {
                            if (me.def() != null && 1.access$0(this.this$1).LocalStore.get(me.def()) == null) {
                                1.access$0(this.this$1).LocalStore.put(me.def(), me);
                            }
                            if (1.access$0(this.this$1).LocalStore.get(me) == null) {
                                1.access$0(this.this$1).LocalStore.put(me, me);
                            }
                            if (DEBUG) {
                                System.out.println("stored ME: " + me + " vn:  " + me.valueNumber());
                            }
                        }

                        public void visitStaticFieldExpr(StaticFieldExpr me) {
                            if (me.def() != null && 1.access$0(this.this$1).LocalStore.get(me.def()) == null) {
                                1.access$0(this.this$1).LocalStore.put(me.def(), me);
                            }
                            if (1.access$0(this.this$1).LocalStore.get(me) == null) {
                                1.access$0(this.this$1).LocalStore.put(me, me);
                            }
                            if (DEBUG) {
                                System.out.println("stored ME: " + me + " vn:  " + me.valueNumber());
                            }
                        }

                        public void visitIfCmpStmt(IfCmpStmt cmp) {
                            Swizzler indswz = null;
                            boolean set_term = false;
                            if (cmp.left().def() != null) {
                                indswz = (Swizzler)1.access$0(this.this$1).IndStore.get(cmp.left().def());
                            }
                            if (indswz != null) {
                                if (DEBUG) {
                                    1.access$0(this.this$1).displaySwizzler(indswz);
                                }
                                if (indswz.end_val() == null) {
                                    indswz.set_end_val(cmp.right());
                                    set_term = true;
                                    if (DEBUG) {
                                        System.out.println("Set end_val of " + indswz.ind_var() + " to " + cmp.right());
                                    }
                                }
                            } else {
                                if (cmp.right().def() != null) {
                                    indswz = (Swizzler)1.access$0(this.this$1).IndStore.get(cmp.right().def());
                                }
                                if (indswz != null) {
                                    if (DEBUG) {
                                        1.access$0(this.this$1).displaySwizzler(indswz);
                                    }
                                    if (indswz.end_val() == null) {
                                        indswz.set_end_val(cmp.left());
                                        set_term = true;
                                        if (DEBUG) {
                                            System.out.println("Set end_val of " + indswz.ind_var() + " to " + cmp.left());
                                        }
                                    }
                                }
                            }
                            if (set_term && indswz != null && indswz.array() != null) {
                                indswz.aswizzle().set_redundant(true);
                                1.access$0(this.this$1).insert_aswrange(indswz);
                            }
                        }

                        public void visitSCStmt(SCStmt sc) {
                            Swizzler indswz;
                            MemExpr le = null;
                            if (DEBUG) {
                                System.out.println("SC: array= " + sc.array() + " VN:" + sc.array().valueNumber() + "\nindex=" + sc.index() + " VN:" + sc.index().valueNumber());
                            }
                            if ((indswz = (Swizzler)1.access$0(this.this$1).get_swizzler(sc.index().valueNumber())) != null) {
                                if (DEBUG) {
                                    1.access$0(this.this$1).displaySwizzler(indswz);
                                }
                                if (indswz.array() == null) {
                                    le = 1.access$0(this.this$1).get_local(sc.array().valueNumber());
                                    if (le == null && sc.array().def() != null) {
                                        le = 1.access$0(this.this$1).get_local(sc.array().def().valueNumber());
                                    }
                                    if (le != null) {
                                        if (DEBUG) {
                                            System.out.println("Le: " + le);
                                        }
                                        indswz.set_array(le);
                                        indswz.set_aswizzle(sc);
                                    } else {
                                        return;
                                    }
                                }
                                if (indswz.end_val() != null) {
                                    sc.set_redundant(true);
                                    1.access$0(this.this$1).insert_aswrange(indswz);
                                }
                            }
                        }
                    });
                }
            }

            static /* synthetic */ InductionVarAnalyzer access$0(1 var0) {
                return var0.InductionVarAnalyzer.this;
            }
        });
        if (DEBUG) {
            System.out.println("------------After visitComponents---------");
            cfg.print(System.out);
        }
        if (this.changed) {
            cfg.visit(new TreeVisitor(){
                ListIterator iter;

                public void visitTree(Tree tree) {
                    this.iter = tree.stmts().listIterator();
                    while (this.iter.hasNext()) {
                        Stmt stmt = (Stmt)this.iter.next();
                        stmt.visit(this);
                    }
                }

                public void visitSCStmt(SCStmt sc) {
                    if (sc.redundant()) {
                        this.iter.remove();
                        Object dup2stmt = this.iter.previous();
                        this.iter.remove();
                        if (DEBUG) {
                            System.out.println("Removed Redundant ASW: " + sc + "\nand " + dup2stmt);
                        }
                    }
                }
            });
        }
        if (DEBUG) {
            System.out.println("----------------After cfg.visit--------------");
            cfg.print(System.out);
        }
    }
}

