/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.cs.bloat.tools;

import EDU.purdue.cs.bloat.benchmark.Times;
import EDU.purdue.cs.bloat.cfg.FlowGraph;
import EDU.purdue.cs.bloat.codegen.CodeGenerator;
import EDU.purdue.cs.bloat.codegen.Liveness;
import EDU.purdue.cs.bloat.context.BloatContext;
import EDU.purdue.cs.bloat.context.CachingBloatContext;
import EDU.purdue.cs.bloat.context.PersistentBloatContext;
import EDU.purdue.cs.bloat.editor.ClassEditor;
import EDU.purdue.cs.bloat.editor.MemberRef;
import EDU.purdue.cs.bloat.editor.MethodEditor;
import EDU.purdue.cs.bloat.editor.Type;
import EDU.purdue.cs.bloat.file.ClassFileLoader;
import EDU.purdue.cs.bloat.inline.CallGraph;
import EDU.purdue.cs.bloat.inline.Inline;
import EDU.purdue.cs.bloat.inline.InlineStats;
import EDU.purdue.cs.bloat.inline.Specialize;
import EDU.purdue.cs.bloat.optimize.Main;
import EDU.purdue.cs.bloat.reflect.MethodInfo;
import EDU.purdue.cs.bloat.trans.Peephole;
import EDU.purdue.cs.bloat.tree.Tree;
import EDU.purdue.cs.bloat.util.Assert;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class BloatBenchmark {
    public static boolean TRACE = false;
    private static boolean INLINE = false;
    private static boolean INTRA = false;
    private static boolean PEEPHOLE = false;
    private static boolean VERIFY = true;
    private static boolean SPECIALIZE = false;
    private static boolean SUN = false;
    private static boolean USE1_1 = false;
    private static boolean CHECK = true;
    private static boolean TIMES = false;
    private static final PrintWriter err = new PrintWriter(System.err, true);
    private static final Set CLASSES = new HashSet();
    private static String statsFile = null;
    private static String timesFile = null;
    private static int DEPTH = 2;
    private static int SIZE = 1000;
    private static int MORPH = -1;
    private static int CALLEE_SIZE = -1;
    private static final List SKIP = new ArrayList();

    private static void tr(String s) {
        if (TRACE) {
            System.out.println(s);
        }
    }

    private static void usage() {
        err.println("java TestSpecialize [options] classNames outputDir");
        err.println("where [options] are:");
        err.println("  -calleeSize size   Max method size to inline");
        err.println("  -classpath path    Classpath is always prepended");
        err.println("  -depth depth       Max inline depth");
        err.println("  -inline            Inline calls to static methods");
        err.println("  -intra             Intraprocedural BLOAT");
        err.println("  -lookIn dir        Look for classes here");
        err.println("  -morph morph       Max morphosity of call sites");
        err.println("  -no-verify         Don't verify CFG");
        err.println("  -no-opt-stack      Don't optimize stack usage");
        err.println("  -no-stack-vars     Don't use stack vars in CFG");
        err.println("  -no-stack-alloc    Don't try to push locals onto the operand stack");
        err.println("  -peel-loops <n|all>\n                   Peel innermost loops to enable code hoisting\n                   (n >= 0 is the maximum loop level to peel)");
        err.println("  -no-pre            Don't perform partial redundency elimination");
        err.println("  -no-dce            Don't perform dead code elimination");
        err.println("  -no-prop           Don't perform copy and constant propagation");
        err.println("  -no-color          Don't do graph coloring");
        err.println("  -peephole          Perform peephole after inter");
        err.println("  -size size         Max method size");
        err.println("  -specialize        Specialize virtual method calls");
        err.println("  -stats statsFile   Generate stats");
        err.println("  -sun               Include sun packages");
        err.println("  -times timesFile   Print timings");
        err.println("  -trace             Print trace information");
        err.println("  -no-check          Don't check that my options 'make sense'");
        err.println("  -skip <class|package.*>\n                   Skip the given class or package");
        err.println("  -1.1               BLOAT for JDK1.1");
        err.println("  -1.2               BLOAT for JDK1.2");
        err.println("");
        System.exit(1);
    }

    public static void main(String[] args) {
        String CLASSPATH = null;
        String outputDirName = null;
        String lookIn = null;
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-trace")) {
                TRACE = true;
                PersistentBloatContext.DB_COMMIT = true;
            } else if (args[i].equals("-calleeSize")) {
                if (++i >= args.length) {
                    err.println("** No callee size specified");
                    BloatBenchmark.usage();
                }
                try {
                    CALLEE_SIZE = Integer.parseInt(args[i]);
                }
                catch (NumberFormatException ex33) {
                    err.println("** Bad number: " + args[i]);
                    BloatBenchmark.usage();
                }
            } else if (args[i].startsWith("-classpath")) {
                if (++i >= args.length) {
                    err.println("** No classpath specified");
                    BloatBenchmark.usage();
                }
                CLASSPATH = CLASSPATH == null ? args[i] : String.valueOf(CLASSPATH) + File.pathSeparator + args[i];
            } else if (args[i].equals("-no-stack-alloc")) {
                Main.STACK_ALLOC = false;
            } else if (args[i].equals("-peel-loops")) {
                String n;
                if (++i >= args.length) {
                    BloatBenchmark.usage();
                }
                if ((n = args[i]).equals("all")) {
                    FlowGraph.PEEL_LOOPS_LEVEL = -1;
                } else {
                    try {
                        FlowGraph.PEEL_LOOPS_LEVEL = Integer.parseInt(n);
                        if (FlowGraph.PEEL_LOOPS_LEVEL < 0) {
                            BloatBenchmark.usage();
                        }
                    }
                    catch (NumberFormatException ex) {
                        BloatBenchmark.usage();
                    }
                }
            } else if (args[i].equals("-no-color")) {
                Liveness.UNIQUE = true;
            } else if (args[i].equals("-no-dce")) {
                Main.DCE = false;
            } else if (args[i].equals("-no-prop")) {
                Main.PROP = false;
            } else if (args[i].equals("-no-pre")) {
                Main.PRE = false;
            } else if (args[i].equals("-no-check")) {
                CHECK = false;
            } else if (args[i].equals("-depth")) {
                if (++i >= args.length) {
                    err.println("** No depth specified");
                    BloatBenchmark.usage();
                }
                try {
                    DEPTH = Integer.parseInt(args[i]);
                }
                catch (NumberFormatException ex33) {
                    err.println("** Bad number: " + args[i]);
                    BloatBenchmark.usage();
                }
            } else if (args[i].equals("-inline")) {
                INLINE = true;
            } else if (args[i].equals("-intra")) {
                INTRA = true;
            } else if (args[i].equals("-lookIn")) {
                if (++i >= args.length) {
                    err.println("** No directory specified");
                    BloatBenchmark.usage();
                }
                lookIn = lookIn != null ? String.valueOf(lookIn) + File.pathSeparator + args[i] : args[i];
            } else if (args[i].equals("-morph")) {
                if (++i >= args.length) {
                    err.println("** No morphosity specified");
                    BloatBenchmark.usage();
                }
                try {
                    MORPH = Integer.parseInt(args[i]);
                }
                catch (NumberFormatException ex33) {
                    err.println("** Bad number: " + args[i]);
                    BloatBenchmark.usage();
                }
            } else if (args[i].equals("-noinline")) {
                INLINE = false;
            } else if (args[i].equals("-peephole")) {
                PEEPHOLE = true;
            } else if (args[i].equals("-size")) {
                if (++i >= args.length) {
                    err.println("** No size specified");
                    BloatBenchmark.usage();
                }
                try {
                    SIZE = Integer.parseInt(args[i]);
                }
                catch (NumberFormatException ex33) {
                    err.println("** Bad number: " + args[i]);
                    BloatBenchmark.usage();
                }
            } else if (args[i].equals("-specialize")) {
                SPECIALIZE = true;
            } else if (args[i].equals("-stats")) {
                if (++i >= args.length) {
                    err.println("** No stats file specified");
                    BloatBenchmark.usage();
                }
                statsFile = args[i];
            } else if (args[i].equals("-sun")) {
                SUN = true;
            } else if (args[i].equals("-times")) {
                TIMES = true;
                if (++i >= args.length) {
                    err.println("** No times file specified");
                    BloatBenchmark.usage();
                }
                timesFile = args[i];
            } else if (args[i].equals("-no-verify")) {
                VERIFY = false;
            } else if (args[i].equals("-no-opt-stack")) {
                CodeGenerator.OPT_STACK = false;
            } else if (args[i].equals("-no-stack-vars")) {
                Tree.USE_STACK = false;
            } else if (args[i].equals("-skip")) {
                String pkg;
                if (++i >= args.length) {
                    BloatBenchmark.usage();
                }
                if ((pkg = args[i]).endsWith(".class")) {
                    pkg = pkg.substring(0, pkg.lastIndexOf(46));
                }
                SKIP.add(pkg.replace('.', '/'));
            } else if (args[i].equals("-1.1")) {
                USE1_1 = true;
                CallGraph.USE1_2 = false;
            } else if (args[i].equals("-1.2")) {
                CallGraph.USE1_2 = true;
                if (lookIn != null) {
                    lookIn = String.valueOf(lookIn) + File.separator + "1.2";
                }
            } else if (args[i].startsWith("-")) {
                err.println("** Unrecognized option: " + args[i]);
                BloatBenchmark.usage();
            } else if (i == args.length - 1) {
                outputDirName = args[i];
            } else {
                CLASSES.add(args[i]);
            }
            ++i;
        }
        if (CLASSES.isEmpty()) {
            err.println("** No classes specified");
            BloatBenchmark.usage();
        }
        if (outputDirName == null) {
            err.println("** No output directory specified");
            BloatBenchmark.usage();
        }
        if (CHECK) {
            BloatBenchmark.checkOptions();
        }
        if (USE1_1) {
            statsFile = null;
        }
        if (lookIn != null) {
            CLASSPATH = String.valueOf(lookIn) + File.pathSeparator + CLASSPATH;
        }
        StringBuffer sb = new StringBuffer();
        int i2 = 0;
        while (i2 < args.length) {
            sb.append(String.valueOf(args[i2]) + " ");
            ++i2;
        }
        BloatBenchmark.tr("BLOATing with command line: " + sb);
        BloatContext context = null;
        float systemStart = 0.0f;
        float systemDelta = 0.0f;
        float systemEnd = 0.0f;
        float systemTotal = 0.0f;
        float userStart = 0.0f;
        float userDelta = 0.0f;
        float userEnd = 0.0f;
        float userTotal = 0.0f;
        PrintWriter times = null;
        if (TIMES) {
            try {
                times = new PrintWriter((Writer)new FileWriter(timesFile), true);
            }
            catch (IOException ex) {
                times = new PrintWriter(System.out, true);
            }
        }
        if (INTRA) {
            BloatBenchmark.tr("Intraprocedural BLOAT");
            context = BloatBenchmark.makeContext(CLASSPATH, null);
            Collection liveMethods = BloatBenchmark.liveMethods(CLASSES, context);
            BloatBenchmark.tr(String.valueOf(liveMethods.size()) + " live methods");
            context = BloatBenchmark.makeContext(CLASSPATH, outputDirName);
            BloatBenchmark.intraBloat(liveMethods, context);
        } else {
            BloatBenchmark.tr("Interprocedural BLOAT");
            if (TIMES) {
                Times.snapshot();
                systemStart = Times.systemTime();
                userStart = Times.userTime();
            }
            context = BloatBenchmark.makeContext(CLASSPATH, outputDirName);
            BloatBenchmark.liveMethods(CLASSES, context);
            if (TIMES) {
                Times.snapshot();
                systemEnd = Times.systemTime();
                userEnd = Times.userTime();
                systemDelta = systemEnd - systemStart;
                userDelta = userEnd - userStart;
                systemStart = systemEnd;
                userStart = userEnd;
                systemTotal += systemDelta;
                userTotal += userDelta;
                times.println("Call graph construction");
                times.println("  User: " + userDelta);
                times.println("  System: " + systemDelta);
            }
            if (SPECIALIZE) {
                BloatBenchmark.specialize(context);
            }
            if (TIMES) {
                Times.snapshot();
                systemEnd = Times.systemTime();
                userEnd = Times.userTime();
                systemDelta = systemEnd - systemStart;
                userDelta = userEnd - userStart;
                systemStart = systemEnd;
                userStart = userEnd;
                systemTotal += systemDelta;
                userTotal += userDelta;
                times.println("Call site specialization");
                times.println("  User: " + userDelta);
                times.println("  System: " + systemDelta);
            }
            if (INLINE) {
                BloatBenchmark.inline(context);
            }
            if (TIMES) {
                Times.snapshot();
                systemEnd = Times.systemTime();
                userEnd = Times.userTime();
                systemDelta = systemEnd - systemStart;
                userDelta = userEnd - userStart;
                systemStart = systemEnd;
                userStart = userEnd;
                systemTotal += systemDelta;
                userTotal += userDelta;
                times.println("Method inlining");
                times.println("  User: " + userDelta);
                times.println("  System: " + systemDelta);
            }
            if (PEEPHOLE) {
                BloatBenchmark.peephole(context);
            }
        }
        BloatBenchmark.tr("Committing dirty methods");
        context.commitDirty();
        if (TIMES) {
            Times.snapshot();
            systemEnd = Times.systemTime();
            userEnd = Times.userTime();
            systemDelta = systemEnd - systemStart;
            userDelta = userEnd - userStart;
            systemStart = systemEnd;
            userStart = userEnd;
            systemTotal += systemDelta;
            userTotal += userDelta;
            times.println("Committal");
            times.println("  User: " + userDelta);
            times.println("  System: " + systemDelta);
        }
        if (TIMES) {
            times.println("Total");
            times.println("  User: " + userTotal);
            times.println("  System: " + systemTotal);
        }
        if (statsFile != null) {
            InlineStats stats = context.getInlineStats();
            PrintWriter statsOut = null;
            try {
                statsOut = new PrintWriter((Writer)new FileWriter(statsFile), true);
            }
            catch (IOException ex) {
                statsOut = new PrintWriter(System.out, true);
            }
            stats.printSummary(statsOut);
        }
        BloatBenchmark.tr("Finished");
    }

    static BloatContext makeContext(String classpath, String outputDirName) {
        ClassFileLoader loader = new ClassFileLoader();
        if (classpath != null) {
            loader.prependClassPath(classpath);
        }
        BloatBenchmark.tr("  Creating a BloatContext for CLASSPATH: " + loader.getClassPath());
        if (outputDirName != null) {
            loader.setOutputDir(new File(outputDirName));
        }
        CachingBloatContext context = new CachingBloatContext(loader, CLASSES, true);
        if (!SUN) {
            context.addIgnorePackage("sun");
        }
        context.addIgnorePackage("java.lang.ref");
        context.addIgnorePackage("org.opj.system");
        if (USE1_1) {
            context.addIgnoreClass(Type.getType("Ljava/lang/Character;"));
        }
        return context;
    }

    private static Collection liveMethods(Collection classes, BloatContext context) {
        HashSet<MemberRef> roots = new HashSet<MemberRef>();
        Iterator iter = classes.iterator();
        while (iter.hasNext()) {
            String className = (String)iter.next();
            try {
                ClassEditor ce = context.editClass(className);
                MethodInfo[] methods = ce.methods();
                int i = 0;
                while (i < methods.length) {
                    MethodEditor me = context.editMethod(methods[i]);
                    if (me.name().equals("main")) {
                        BloatBenchmark.tr("  Root " + ce.name() + "." + me.name() + me.type());
                        roots.add(me.memberRef());
                    }
                    ++i;
                }
            }
            catch (ClassNotFoundException ex1) {
                err.println("** Could not find class: " + ex1.getMessage());
                System.exit(1);
            }
        }
        if (roots.isEmpty()) {
            err.print("** No main method found in classes: ");
            iter = classes.iterator();
            while (iter.hasNext()) {
                String name = (String)iter.next();
                err.print(name);
                if (!iter.hasNext()) continue;
                err.print(", ");
            }
            err.println("");
        }
        context.setRootMethods(roots);
        CallGraph cg = context.getCallGraph();
        TreeSet liveMethods = new TreeSet(new MemberRefComparator());
        liveMethods.addAll(cg.liveMethods());
        return liveMethods;
    }

    private static void specialize(BloatContext context) {
        CallGraph cg = context.getCallGraph();
        TreeSet liveMethods = new TreeSet(new MemberRefComparator());
        liveMethods.addAll(cg.liveMethods());
        InlineStats stats = context.getInlineStats();
        if (statsFile != null) {
            Specialize.STATS = true;
            stats.setConfigName("BloatBenchmark");
        }
        if (MORPH != -1) {
            Specialize.MAX_MORPH = MORPH;
        }
        Specialize spec = new Specialize(context);
        if (Specialize.STATS) {
            stats.noteLiveMethods(liveMethods.size());
            stats.noteLiveClasses(cg.liveClasses().size());
        }
        BloatBenchmark.tr("Specializing live methods");
        Iterator iter = liveMethods.iterator();
        int count = 0;
        while (iter.hasNext()) {
            try {
                MethodEditor live = context.editMethod((MemberRef)iter.next());
                if (!context.ignoreMethod(live.memberRef())) {
                    BloatBenchmark.tr("  " + count + ") " + live.declaringClass().name() + "." + live.name() + live.type());
                    spec.specialize(live);
                }
            }
            catch (NoSuchMethodException ex2) {
                err.println("** Could not find method " + ex2.getMessage());
                System.exit(1);
            }
            ++count;
        }
    }

    private static void inline(BloatContext context) {
        TreeSet liveMethods = new TreeSet(new MemberRefComparator());
        CallGraph cg = context.getCallGraph();
        liveMethods.addAll(cg.liveMethods());
        BloatBenchmark.tr("Inlining " + liveMethods.size() + " live methods");
        if (CALLEE_SIZE != -1) {
            Inline.CALLEE_SIZE = CALLEE_SIZE;
        }
        Iterator iter = liveMethods.iterator();
        int count = 0;
        while (INLINE && iter.hasNext()) {
            try {
                MethodEditor live = context.editMethod((MemberRef)iter.next());
                if (!context.ignoreMethod(live.memberRef())) {
                    BloatBenchmark.tr("  " + count + ") " + live.declaringClass().name() + "." + live.name() + live.type());
                    Inline inline = new Inline(context, SIZE);
                    inline.setMaxCallDepth(DEPTH);
                    inline.inline(live);
                    context.commit(live.methodInfo());
                    context.release(live.methodInfo());
                }
            }
            catch (NoSuchMethodException ex3) {
                err.println("** Could not find method " + ex3.getMessage());
                System.exit(1);
            }
            ++count;
        }
    }

    private static void peephole(BloatContext context) {
        TreeSet liveMethods = new TreeSet(new MemberRefComparator());
        CallGraph cg = context.getCallGraph();
        liveMethods.addAll(cg.liveMethods());
        BloatBenchmark.tr("Performing peephole optimizations");
        Iterator iter = liveMethods.iterator();
        while (PEEPHOLE && iter.hasNext()) {
            try {
                MethodEditor live = context.editMethod((MemberRef)iter.next());
                Peephole.transform(live);
                context.commit(live.methodInfo());
                context.release(live.methodInfo());
            }
            catch (NoSuchMethodException ex314) {
                err.println("** Could not find method " + ex314.getMessage());
                ex314.printStackTrace(System.err);
                System.exit(1);
            }
        }
    }

    private static void intraBloat(Collection liveMethods, BloatContext context) {
        ClassEditor prevClass = null;
        Iterator iter = liveMethods.iterator();
        int count = 0;
        while (iter.hasNext()) {
            MethodEditor live = null;
            ClassEditor ce = null;
            try {
                live = context.editMethod((MemberRef)iter.next());
                ce = context.editClass(live.declaringClass().classInfo());
            }
            catch (NoSuchMethodException ex3) {
                err.println("** Could not find method " + ex3.getMessage());
                System.exit(1);
            }
            String name = ce.type().className();
            String qual = String.valueOf(ce.type().qualifier()) + "/*";
            boolean skip = false;
            int i = 0;
            while (i < SKIP.size()) {
                String pkg = (String)SKIP.get(i);
                if (name.equals(pkg) || qual.equals(pkg)) {
                    skip = true;
                    break;
                }
                ++i;
            }
            if (context.ignoreMethod(live.memberRef()) || skip) {
                context.release(live.methodInfo());
            } else {
                Runtime runtime = Runtime.getRuntime();
                runtime.gc();
                Date start = new Date();
                BloatBenchmark.tr("  " + count + ") " + live.declaringClass().name() + "." + live.name() + live.type());
                BloatBenchmark.tr("    Start: " + start);
                try {
                    Main.TRACE = TRACE;
                    if (!VERIFY) {
                        Main.VERIFY = false;
                    }
                    Main.bloatMethod(live, context);
                }
                catch (Exception oops) {
                    err.println("******************************************");
                    err.println("Exception while BLOATing " + live.declaringClass().name() + "." + live.name() + live.type());
                    err.println(oops.getMessage());
                    oops.printStackTrace(System.err);
                    err.println("******************************************");
                }
                context.commit(live.methodInfo());
                context.release(live.methodInfo());
                if (prevClass == null) {
                    prevClass = ce;
                } else if (!prevClass.equals(ce)) {
                    BloatBenchmark.tr(prevClass.type() + " != " + ce.type());
                    context.commit(prevClass.classInfo());
                    context.release(prevClass.classInfo());
                    prevClass = ce;
                } else {
                    context.release(ce.classInfo());
                }
                Date end = new Date();
                BloatBenchmark.tr("    Ellapsed time: " + (end.getTime() - start.getTime()) + " ms");
            }
            ++count;
        }
        context.commitDirty();
    }

    private static void checkOptions() {
        if (!(INTRA || SPECIALIZE || INLINE)) {
            err.println("** There is nothing to do!");
            BloatBenchmark.usage();
        } else if (MORPH != -1 && !SPECIALIZE) {
            err.println("** Must specialize when setting morphosity");
            BloatBenchmark.usage();
        }
    }

    private static class MemberRefComparator
    implements Comparator {
        private MemberRefComparator() {
        }

        public int compare(Object o1, Object o2) {
            Assert.isTrue(o1 instanceof MemberRef, o1 + " is not a MemberRef!");
            Assert.isTrue(o2 instanceof MemberRef, o2 + " is not a MemberRef!");
            MemberRef me1 = (MemberRef)o1;
            MemberRef me2 = (MemberRef)o2;
            String s1 = me1.declaringClass() + "." + me1.name() + me1.type();
            String s2 = me2.declaringClass() + "." + me2.name() + me2.type();
            return s1.compareTo(s2);
        }

        public boolean equals(Object other) {
            return true;
        }
    }
}

