/*
 * Decompiled with CFR 0.152.
 */
package com.lightdev.app.allday.ui;

import com.lightdev.app.allday.ui.MainFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.help.CSH;
import javax.help.HelpBroker;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class DialogShell
extends JDialog
implements ActionListener {
    protected JPanel buttonPanel;
    protected JButton okButton;
    protected JButton cancelButton;
    protected JButton helpButton;
    private int result;
    public static int RESULT_CANCEL = 1;
    public static int RESULT_OK = 0;
    protected String helpTopicId = null;
    private HelpBroker myHelpBroker;
    protected MainFrame mf;

    public DialogShell(Dialog parent, String title) {
        super(parent, title);
        this.buildDialog();
    }

    public DialogShell(Frame parent, String title) {
        super(parent, title);
        this.buildDialog();
    }

    public DialogShell(Frame parent, String title, String helpTopicId) {
        super(parent, title);
        this.helpTopicId = helpTopicId;
        this.buildDialog();
    }

    public DialogShell(Dialog parent, String title, String helpTopicId) {
        super(parent, title);
        this.helpTopicId = helpTopicId;
        this.buildDialog();
    }

    public DialogShell(Dialog parent, String title, String helpTopicId, HelpBroker broker) {
        super(parent, title);
        this.helpTopicId = helpTopicId;
        this.myHelpBroker = broker;
        this.buildDialog();
    }

    public DialogShell(Frame parent, String title, String helpTopicId, HelpBroker broker) {
        super(parent, title);
        this.helpTopicId = helpTopicId;
        this.myHelpBroker = broker;
        this.buildDialog();
    }

    private void buildDialog() {
        this.mf = (MainFrame)this.getParent();
        this.enableEvents(64L);
        this.okButton = new JButton(this.mf.getResourceString("okBtnName", "OK"));
        this.cancelButton = new JButton(this.mf.getResourceString("cancelBtnName", "Cancel"));
        this.cancelButton.addActionListener(this);
        this.okButton.addActionListener(this);
        this.buttonPanel = new JPanel(new FlowLayout());
        this.buttonPanel.add(this.okButton);
        this.buttonPanel.add(this.cancelButton);
        if (this.helpTopicId != null) {
            this.helpButton = new JButton(this.mf.getResourceString("helpLabel", "Help"));
            CSH.setHelpIDString(this.helpButton, this.helpTopicId);
            if (this.myHelpBroker == null) {
                this.helpButton.addActionListener(new CSH.DisplayHelpFromSource(((MainFrame)this.getParent()).getHelpBroker()));
            } else {
                this.helpButton.addActionListener(new CSH.DisplayHelpFromSource(this.myHelpBroker));
            }
            this.buttonPanel.add(this.helpButton);
        }
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout(5, 5));
        contentPane.add((Component)this.buttonPanel, "South");
    }

    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            this.cancel();
        }
        super.processWindowEvent(e);
    }

    protected void cancel() {
        this.result = RESULT_CANCEL;
        this.dispose();
    }

    protected void confirm() {
        this.result = RESULT_OK;
        this.dispose();
    }

    public int getResult() {
        return this.result;
    }

    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.cancelButton) {
            this.cancel();
        } else if (src == this.okButton) {
            this.confirm();
        }
    }
}

