/*
 * Decompiled with CFR 0.152.
 */
package com.lightdev.app.allday.ui;

import com.lightdev.app.allday.action.AboutAppAction;
import com.lightdev.app.allday.action.EditPrefsAction;
import com.lightdev.app.allday.action.ExitAction;
import com.lightdev.app.allday.action.HelpContentsAction;
import com.lightdev.app.allday.action.NextYearAction;
import com.lightdev.app.allday.action.PrevYearAction;
import com.lightdev.app.allday.action.SetYearAction;
import com.lightdev.app.allday.action.ThisYearAction;
import com.lightdev.app.allday.ui.ResourceMenu;
import com.lightdev.app.allday.ui.YearPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.help.HelpSetException;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class MainFrame
extends JFrame {
    private ResourceBundle resources = ResourceBundle.getBundle("com.lightdev.app.allday.ui.AllDay", Locale.getDefault());
    private ResourceMenu menu;
    private YearPanel yp;
    private HelpBroker hb;
    public static final String ACTION_EXIT_APP = "exitApp";
    public static final String ACTION_HELP_CONTENTS = "helpContents";
    public static final String ACTION_ABOUT_APP = "aboutApp";
    public static final String ACTION_SET_YEAR = "setYear";
    public static final String ACTION_PREV_YEAR = "prevYear";
    public static final String ACTION_NEXT_YEAR = "nextYear";
    public static final String ACTION_EDIT_PREFS = "editPrefs";
    public static final String ACTION_THIS_YEAR = "thisYear";
    public static final String APP_HELP_NAME = "help";
    public static final String JAVA_HELP_EXT = ".hs";
    public static final String URL_SEPARATOR = "/";

    public MainFrame() {
        this.enableEvents(64L);
        try {
            this.initComponent();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initComponent() throws Exception {
        int thisYear = new GregorianCalendar().get(1);
        this.yp = new YearPanel(thisYear);
        this.menu = new ResourceMenu();
        this.initActions();
        this.setJMenuBar(this.menu.createMenubar(this.resources, "menubar"));
        this.setSize(new Dimension(700, 500));
        this.setTitle("AllDay " + thisYear);
        this.setIconImage(Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("resources/icon.gif")));
        JPanel toolBarPanel = new JPanel(new FlowLayout(0, 0, 0));
        toolBarPanel.add(this.menu.createToolBar(this.resources, "toolBar"));
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setRequestFocusEnabled(false);
        contentPane.setFocusable(false);
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)toolBarPanel, "North");
        contentPane.add((Component)this.yp, "Center");
        this.yp.setVisible(true);
    }

    public void setYearPanel(YearPanel panel) {
        JPanel contentPane = (JPanel)this.getContentPane();
        if (this.yp != null) {
            contentPane.remove(this.yp);
        }
        this.yp = panel;
        contentPane.add((Component)this.yp, "Center");
        this.yp.setVisible(true);
    }

    public HelpBroker getHelpBroker() {
        try {
            if (this.hb == null) {
                URL url = this.getClass().getResource("help/help.hs");
                this.hb = new HelpSet(null, url).createHelpBroker();
            }
        }
        catch (HelpSetException ex) {
            ex.printStackTrace();
        }
        return this.hb;
    }

    private void initActions() {
        this.menu.addAction(ACTION_EXIT_APP, new ExitAction(this, ACTION_EXIT_APP));
        this.menu.addAction(ACTION_HELP_CONTENTS, new HelpContentsAction(this, ACTION_HELP_CONTENTS));
        this.menu.addAction(ACTION_ABOUT_APP, new AboutAppAction(this, ACTION_ABOUT_APP));
        this.menu.addAction(ACTION_EDIT_PREFS, new EditPrefsAction(this, ACTION_EDIT_PREFS));
        this.menu.addAction(ACTION_PREV_YEAR, new PrevYearAction(this, ACTION_PREV_YEAR));
        this.menu.addAction(ACTION_NEXT_YEAR, new NextYearAction(this, ACTION_NEXT_YEAR));
        this.menu.addAction(ACTION_SET_YEAR, new SetYearAction(this, ACTION_SET_YEAR));
        this.menu.addAction(ACTION_THIS_YEAR, new ThisYearAction(this, ACTION_THIS_YEAR));
    }

    protected void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == 201) {
            this.menu.getAction(ACTION_EXIT_APP).actionPerformed(null);
        }
    }

    public String getResourceString(String key, String defaultStr) {
        try {
            return this.resources.getString(key);
        }
        catch (MissingResourceException mre) {
            return defaultStr;
        }
    }

    public YearPanel getYearPanel() {
        return this.yp;
    }

    public ResourceBundle getResourceBundle() {
        return this.resources;
    }

    public ResourceMenu getResourceMenu() {
        return this.menu;
    }
}

