/*
 * Decompiled with CFR 0.152.
 */
package com.swabunga.spell.swing;

import com.swabunga.spell.engine.SpellDictionary;
import com.swabunga.spell.engine.SpellDictionaryCachedDichoDisk;
import com.swabunga.spell.engine.SpellDictionaryHashMap;
import com.swabunga.spell.event.DocumentWordTokenizer;
import com.swabunga.spell.event.SpellCheckEvent;
import com.swabunga.spell.event.SpellCheckListener;
import com.swabunga.spell.event.SpellChecker;
import com.swabunga.spell.swing.JSpellDialog;
import com.swabunga.spell.swing.autospell.AutoSpellCheckHandler;
import com.swabunga.spell.swing.autospell.AutoSpellEditorKit;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledEditorKit;

public class JTextComponentSpellChecker
implements SpellCheckListener {
    private String dialogTitle = null;
    private SpellChecker spellCheck = null;
    private JSpellDialog dlg = null;
    private JTextComponent textComp = null;
    private ResourceBundle messages;
    private SpellDictionary mainDict = null;
    private AutoSpellCheckHandler markHandler;

    public JTextComponentSpellChecker(SpellDictionary dict) {
        this(dict, null, null);
    }

    public JTextComponentSpellChecker(String dictFile) throws IOException {
        this(dictFile, null);
    }

    public JTextComponentSpellChecker(String dictFile, String title) throws IOException {
        this(new SpellDictionaryHashMap(new File(dictFile)), null, title);
    }

    public JTextComponentSpellChecker(String dictFile, String phoneticFile, String title) throws IOException {
        this(new SpellDictionaryHashMap(new File(dictFile), new File(phoneticFile)), null, title);
    }

    public JTextComponentSpellChecker(SpellDictionary dict, SpellDictionary userDict, String title) {
        this.spellCheck = new SpellChecker(dict);
        this.mainDict = dict;
        this.spellCheck.setCache();
        if (userDict != null) {
            this.spellCheck.setUserDictionary(userDict);
        }
        this.spellCheck.addSpellCheckListener(this);
        this.dialogTitle = title;
        this.messages = ResourceBundle.getBundle("com.swabunga.spell.swing.messages", Locale.getDefault());
        this.markHandler = new AutoSpellCheckHandler(this.spellCheck, this.messages);
    }

    public void setUserDictionary(SpellDictionary dictionary) {
        if (this.spellCheck != null) {
            this.spellCheck.setUserDictionary(dictionary);
        }
    }

    private void setupDialog(JTextComponent textComp) {
        Component comp = SwingUtilities.getRoot(textComp);
        if (this.dlg != null && this.dlg.getOwner() == comp) {
            return;
        }
        if (comp != null && comp instanceof Window) {
            if (comp instanceof Frame) {
                this.dlg = new JSpellDialog((Frame)comp, this.dialogTitle, true);
            }
            if (comp instanceof Dialog) {
                this.dlg = new JSpellDialog((Dialog)comp, this.dialogTitle, true);
            }
            if (this.dlg != null) {
                Window win = (Window)comp;
                int x = (int)(win.getLocation().getX() + (double)(win.getWidth() / 2) - (double)(this.dlg.getWidth() / 2));
                int y = (int)(win.getLocation().getY() + (double)(win.getHeight() / 2) - (double)(this.dlg.getHeight() / 2));
                this.dlg.setLocation(x, y);
            }
        } else {
            this.dlg = new JSpellDialog(null, this.dialogTitle, true);
        }
    }

    public synchronized int spellCheck(JTextComponent textComp) {
        this.setupDialog(textComp);
        this.textComp = textComp;
        DocumentWordTokenizer tokenizer = new DocumentWordTokenizer(textComp.getDocument());
        int exitStatus = this.spellCheck.checkSpelling(tokenizer);
        textComp.requestFocus();
        textComp.setCaretPosition(0);
        this.textComp = null;
        try {
            if (this.mainDict instanceof SpellDictionaryCachedDichoDisk) {
                ((SpellDictionaryCachedDichoDisk)this.mainDict).saveCache();
            }
        }
        catch (IOException ex) {
            System.err.println(ex.getMessage());
        }
        return exitStatus;
    }

    public void startAutoSpellCheck(JEditorPane pane) {
        Document doc = pane.getDocument();
        pane.setEditorKit(new AutoSpellEditorKit((StyledEditorKit)pane.getEditorKit()));
        pane.setDocument(doc);
        this.markHandler.addJEditorPane(pane);
    }

    public void stopAutoSpellCheck(JEditorPane pane) {
        if (pane.getEditorKit() instanceof AutoSpellEditorKit) {
            Document doc = pane.getDocument();
            StyledEditorKit kit = ((AutoSpellEditorKit)pane.getEditorKit()).getStyledEditorKit();
            pane.setEditorKit(kit);
            pane.setDocument(doc);
        }
        this.markHandler.removeJEditorPane(pane);
    }

    @Override
    public void spellingError(SpellCheckEvent event) {
        event.getSuggestions();
        int start = event.getWordContextPosition();
        int end = start + event.getInvalidWord().length();
        this.textComp.requestFocus();
        this.textComp.setCaretPosition(0);
        this.textComp.setCaretPosition(start);
        this.textComp.moveCaretPosition(end);
        this.dlg.show(event);
    }
}

