/*
 * Decompiled with CFR 0.152.
 */
package org.mydragonfly.pj.service;

import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.Hibernate;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.exception.JDBCConnectionException;
import org.jasypt.encryption.pbe.PBEStringEncryptor;
import org.jasypt.encryption.pbe.StandardPBEStringEncryptor;
import org.jasypt.hibernate.encryptor.HibernatePBEEncryptorRegistry;
import org.mydragonfly.pj.data.Entry;
import org.mydragonfly.pj.data.Journal;
import org.mydragonfly.pj.service.PJService;
import org.mydragonfly.pj.service.exception.DatabaseLockedException;
import org.mydragonfly.pj.util.StringUtil;

public class JournalService
extends PJService {
    static Logger logger = Logger.getLogger(JournalService.class);
    private static final String encPassword = "gh908th874fu3r67se57y64trf";
    protected static StandardPBEStringEncryptor encryptor = new StandardPBEStringEncryptor();
    protected static HibernatePBEEncryptorRegistry registry;

    public static void init() {
        Session session = JournalService.getSession();
    }

    public static List<Journal> getJournals() throws DatabaseLockedException {
        Session session = JournalService.getSession();
        List list = null;
        try {
            Query query = session.createQuery("from Journal as journal order by journal.title");
            list = query.list();
        }
        catch (JDBCConnectionException jDBCConnectionException) {
            throw new DatabaseLockedException();
        }
        finally {
            session.close();
        }
        return list;
    }

    public static Journal getJournal(int n) throws DatabaseLockedException {
        Journal journal = null;
        Session session = JournalService.getSession();
        try {
            Query query = session.createQuery("from Journal as journal where journal.id = :id");
            query.setInteger("id", n);
            List list = query.list();
            if (list != null && list.size() > 0) {
                journal = (Journal)list.get(0);
                Hibernate.initialize((Object)journal);
            }
        }
        catch (JDBCConnectionException jDBCConnectionException) {
            throw new DatabaseLockedException();
        }
        finally {
            session.close();
        }
        return journal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Journal validatePassword(String string, String string2) {
        string2 = StringUtil.blankNull(string2);
        Journal journal = null;
        Session session = JournalService.getSession();
        logger.debug((Object)("validate: title=" + string + " password=" + string2));
        try {
            Query query = session.createQuery("from Journal as journal where journal.title = :title");
            query.setString("title", string);
            List list = query.list();
            if (list != null && list.size() > 0) {
                journal = (Journal)list.get(0);
                logger.debug((Object)("j id=" + journal.getId()));
                if (string2.equals(encryptor.decrypt(journal.getPassword()))) {
                    Hibernate.initialize((Object)journal);
                } else {
                    journal = null;
                }
            }
        }
        finally {
            session.close();
        }
        return journal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Journal saveJournal(Journal journal) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"in saveJournal");
        }
        Session session = null;
        try {
            if (journal != null) {
                Transaction transaction = null;
                session = JournalService.getSession();
                transaction = session.beginTransaction();
                if (journal.getId() < 1) {
                    journal.setPassword(encryptor.encrypt(journal.getPassword()));
                    Integer n = (Integer)session.save((Object)journal);
                    logger.debug((Object)("save returned value=" + n.toString()));
                    journal = JournalService.getJournal(n);
                } else {
                    journal = (Journal)session.merge((Object)journal);
                    session.update((Object)journal);
                }
                transaction.commit();
            }
        }
        catch (Exception exception) {
            logger.error((Object)"Failed to save Journal! Error:", (Throwable)exception);
            Journal journal2 = null;
            return journal2;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
        return journal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean deleteJournal(Journal journal) {
        Session session = null;
        try {
            if (journal != null) {
                Transaction transaction = null;
                session = JournalService.getSession();
                transaction = session.beginTransaction();
                session.delete((Object)journal);
                transaction.commit();
            }
        }
        catch (Exception exception) {
            System.err.println("Failed to delete Journal! Error:" + exception);
            boolean bl = false;
            return bl;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Journal updatePassword(Journal journal, String string, String string2) {
        Session session = null;
        Journal journal2 = null;
        string = StringUtil.blankNull(string);
        string2 = StringUtil.blankNull(string2);
        try {
            if (journal != null) {
                Transaction transaction = null;
                session = JournalService.getSession();
                transaction = session.beginTransaction();
                journal2 = JournalService.validatePassword(journal.getTitle(), string);
                if (journal2 != null) {
                    journal2.setPassword(encryptor.encrypt(string2));
                    session.update((Object)journal2);
                }
                transaction.commit();
            }
        }
        catch (Exception exception) {
            System.err.println("Failed to delete Journal! Error:" + exception);
            Journal journal3 = null;
            return journal3;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
        return journal2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeEntry(Journal journal, Entry entry) {
        if (entry != null) {
            Session session = null;
            try {
                Transaction transaction = null;
                session = JournalService.getSession();
                transaction = session.beginTransaction();
                session.delete((Object)entry);
                transaction.commit();
            }
            finally {
                session.close();
            }
        } else {
            logger.debug((Object)"Entry provided was null, can't delete");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Entry getEntry(Journal journal, Integer n) {
        if (journal.getEntries() != null && !journal.getEntries().isEmpty()) {
            for (Entry entry : journal.getEntries()) {
                if (entry.getId() != n.intValue()) continue;
                Session session = JournalService.getSession();
                try {
                    Hibernate.initialize((Object)entry);
                    entry.getTags();
                    Entry entry2 = entry;
                    return entry2;
                }
                finally {
                    session.close();
                }
            }
            return null;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int saveNewEntry(Entry entry) {
        int n = -1;
        if (entry != null) {
            Session session = null;
            try {
                Transaction transaction = null;
                session = JournalService.getSession();
                transaction = session.beginTransaction();
                n = new Integer(session.save((Object)entry) + "");
                transaction.commit();
            }
            finally {
                session.close();
            }
        } else {
            logger.debug((Object)"Entry provided was null, can't save");
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int saveEntry(Entry entry) {
        int n = -1;
        if (entry != null) {
            Session session = null;
            try {
                Transaction transaction = null;
                session = JournalService.getSession();
                transaction = session.beginTransaction();
                if (entry.getId() > 0) {
                    session.saveOrUpdate((Object)entry);
                    n = entry.getId();
                } else {
                    n = new Integer(session.save((Object)entry) + "");
                }
                transaction.commit();
            }
            finally {
                session.close();
            }
        } else {
            logger.debug((Object)"Entry provided was null, can't save");
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void moveEntry(Entry entry, Entry entry2, boolean bl) {
        if (entry2 != null) {
            Session session = null;
            try {
                Transaction transaction = null;
                session = JournalService.getSession();
                transaction = session.beginTransaction();
                JournalService.saveNewEntry(entry2);
                transaction.commit();
            }
            finally {
                session.close();
            }
        }
    }

    static {
        encryptor.setPassword(encPassword);
        registry = HibernatePBEEncryptorRegistry.getInstance();
        registry.registerPBEStringEncryptor("hibernateStringEncryptor", (PBEStringEncryptor)encryptor);
    }
}

