/*
 * Decompiled with CFR 0.152.
 */
package org.gtdfree.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.gtdfree.ApplicationHelper;
import org.gtdfree.GTDFreeEngine;
import org.gtdfree.Messages;
import org.gtdfree.model.ConsistencyException;
import org.gtdfree.model.GTDData;
import org.gtdfree.model.GTDDataODB;
import org.gtdfree.model.GTDModel;

public class DatabaseToolsDialog {
    private JTextArea consistencyCheckText;
    private Logger consistencyCheckLogger;
    protected GTDFreeEngine engine;
    private JCheckBox repairCheckBox;
    private JLabel dbTypeLabel;
    private JDialog dialog;
    private JButton checkButton;
    private JButton changeButton;
    private boolean verifying;
    private JButton closeButton;
    private JTabbedPane mainTabs;
    private JFileChooser fileChooser;
    private JCheckBox exitBackupXmlCheckBox;
    private JCheckBox exitBackupOdbCheckBox;

    public static void main(String[] args) {
        DatabaseToolsDialog d = new DatabaseToolsDialog();
        d.showDatabaseToolsDialog(null);
    }

    private JDialog getDialog(Component c) {
        if (this.dialog == null) {
            this.dialog = new JDialog();
            this.mainTabs = new JTabbedPane();
            JPanel jp = this.getOptionsTab();
            this.mainTabs.addTab(Messages.getString("DatabaseToolsDialog.Options"), jp);
            jp = this.getToolsTab();
            this.mainTabs.addTab(Messages.getString("DatabaseToolsDialog.Verify"), jp);
            jp = this.getOdbTab();
            this.mainTabs.addTab(Messages.getString("DatabaseToolsDialog.ODB"), jp);
            this.mainTabs.setEnabledAt(2, this.getGTDDataODB() != null);
            jp = new JPanel();
            jp.setLayout(new GridBagLayout());
            int row = 0;
            jp.add((Component)this.mainTabs, new GridBagConstraints(0, row, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.closeButton = new JButton(Messages.getString("DatabaseToolsDialog.Close"));
            this.closeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DatabaseToolsDialog.this.closeDialog();
                }
            });
            jp.add((Component)this.closeButton, new GridBagConstraints(0, ++row, 1, 1, 1.0, 0.0, 13, 0, new Insets(11, 11, 11, 11), 0, 0));
            this.dialog.setContentPane(jp);
            this.dialog.setSize(500, 400);
            this.dialog.setTitle(Messages.getString("DatabaseToolsDialog.DBTools"));
            this.dialog.setModal(true);
            this.dialog.setDefaultCloseOperation(0);
            this.dialog.setLocationRelativeTo(c);
            this.dialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    DatabaseToolsDialog.this.closeDialog();
                }
            });
        }
        return this.dialog;
    }

    private JPanel getOdbTab() {
        JPanel jp = new JPanel();
        jp.setLayout(new GridBagLayout());
        int row = 0;
        JTextArea ta = new JTextArea();
        ta.setEditable(false);
        ta.setEnabled(false);
        ta.setWrapStyleWord(true);
        ta.setLineWrap(true);
        ta.setDisabledTextColor(ta.getForeground());
        ta.setBorder(null);
        ta.setFont(ta.getFont().deriveFont(2));
        ta.setText(Messages.getString("DatabaseToolsDialog.Tools.desc"));
        jp.add((Component)ta, new GridBagConstraints(0, row, 2, 1, 1.0, 1.0, 10, 1, new Insets(11, 11, 11, 11), 0, 0));
        JButton b = new JButton();
        b.setText(Messages.getString("DatabaseToolsDialog.Exp"));
        b.setToolTipText(Messages.getString("DatabaseToolsDialog.Exp.desc"));
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fc = DatabaseToolsDialog.this.getFileChooser();
                fc.showSaveDialog(DatabaseToolsDialog.this.dialog);
                File f = fc.getSelectedFile();
                if (f != null) {
                    if (!f.getName().endsWith(".odb-xml")) {
                        f = new File(f.getAbsolutePath() + ".odb-xml");
                    }
                    try {
                        DatabaseToolsDialog.this.getGTDDataODB().exportODB(f);
                        JOptionPane.showMessageDialog(DatabaseToolsDialog.this.dialog, Messages.getString("DatabaseToolsDialog.Exp.1") + f.getAbsolutePath() + Messages.getString("DatabaseToolsDialog.Exp.2"), Messages.getString("DatabaseToolsDialog.Exp.title"), 1);
                        DatabaseToolsDialog.this.engine.close(true, false);
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                        JOptionPane.showMessageDialog(DatabaseToolsDialog.this.dialog, Messages.getString("DatabaseToolsDialog.Exp.Fail.1") + " " + e1.toString(), Messages.getString("DatabaseToolsDialog.Exp.Fail.2"), 0);
                    }
                }
            }
        });
        jp.add((Component)b, new GridBagConstraints(0, ++row, 1, 1, 1.0, 0.0, 10, 0, new Insets(4, 11, 11, 4), 0, 0));
        b = new JButton();
        b.setText(Messages.getString("DatabaseToolsDialog.Load"));
        b.setToolTipText(Messages.getString("DatabaseToolsDialog.Load.desc"));
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int option = JOptionPane.showConfirmDialog(DatabaseToolsDialog.this.dialog, Messages.getString("DatabaseToolsDialog.Load.Warn"), Messages.getString("DatabaseToolsDialog.Load.Warn.title"), 2, 2);
                if (option != 0) {
                    return;
                }
                JFileChooser fc = DatabaseToolsDialog.this.getFileChooser();
                int code = fc.showOpenDialog(DatabaseToolsDialog.this.dialog);
                File f = fc.getSelectedFile();
                if (f != null && code == 0) {
                    try {
                        DatabaseToolsDialog.this.getGTDDataODB().importODB(f);
                        JOptionPane.showMessageDialog(DatabaseToolsDialog.this.dialog, Messages.getString("DatabaseToolsDialog.Load.OK"), Messages.getString("DatabaseToolsDialog.Load.OK.title"), 1);
                        DatabaseToolsDialog.this.engine.close(true, false);
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                        JOptionPane.showMessageDialog(DatabaseToolsDialog.this.dialog, Messages.getString("DatabaseToolsDialog.Load.Fail") + " " + e1.toString(), Messages.getString("DatabaseToolsDialog.Load.Fail.title"), 0);
                    }
                }
            }
        });
        jp.add((Component)b, new GridBagConstraints(1, row, 1, 1, 1.0, 0.0, 10, 0, new Insets(4, 4, 11, 11), 0, 0));
        return jp;
    }

    private JPanel getToolsTab() {
        JPanel jp = new JPanel();
        jp.setLayout(new GridBagLayout());
        int row = 0;
        this.consistencyCheckText = new JTextArea();
        this.consistencyCheckText.setEditable(false);
        jp.add((Component)new JScrollPane(this.consistencyCheckText), new GridBagConstraints(0, ++row, 2, 1, 1.0, 1.0, 10, 1, new Insets(11, 11, 4, 11), 0, 0));
        this.consistencyCheckLogger = Logger.getAnonymousLogger();
        this.consistencyCheckLogger.addHandler(new Handler(){

            @Override
            public void publish(LogRecord record) {
                DatabaseToolsDialog.this.consistencyCheckText.append(record.getMessage());
                DatabaseToolsDialog.this.consistencyCheckText.append("\n");
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() throws SecurityException {
            }
        });
        this.repairCheckBox = new JCheckBox();
        this.repairCheckBox.setText(Messages.getString("DatabaseToolsDialog.Fix"));
        jp.add((Component)this.repairCheckBox, new GridBagConstraints(0, ++row, 1, 1, 1.0, 0.0, 17, 2, new Insets(4, 11, 11, 4), 0, 0));
        this.checkButton = new JButton(Messages.getString("DatabaseToolsDialog.Check"));
        this.checkButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DatabaseToolsDialog.this.startVerify();
            }
        });
        jp.add((Component)this.checkButton, new GridBagConstraints(1, row, 1, 1, 1.0, 0.0, 10, 0, new Insets(4, 4, 11, 11), 0, 0));
        return jp;
    }

    private JPanel getOptionsTab() {
        JPanel jp = new JPanel();
        jp.setLayout(new GridBagLayout());
        int row = 0;
        JLabel l = new JLabel();
        String s = Messages.getString("DatabaseToolsDialog.Loc") + " " + (this.engine != null ? this.engine.getDataFolder() : Messages.getString("DatabaseToolsDialog.NA"));
        l.setText(s);
        l.setToolTipText(s);
        jp.add((Component)l, new GridBagConstraints(0, row, 2, 1, 1.0, 0.0, 10, 2, new Insets(11, 11, 4, 11), 0, 0));
        this.dbTypeLabel = new JLabel();
        this.dbTypeLabel.setText(Messages.getString("DatabaseToolsDialog.Type") + " " + (this.engine != null ? this.engine.getGTDModel().getDataRepository().getDatabaseType() : Messages.getString("DatabaseToolsDialog.NA")));
        jp.add((Component)this.dbTypeLabel, new GridBagConstraints(0, ++row, 1, 1, 1.0, 0.0, 17, 2, new Insets(4, 11, 4, 4), 0, 0));
        this.changeButton = new JButton();
        this.changeButton.setText(Messages.getString("DatabaseToolsDialog.Change"));
        this.changeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DatabaseToolsDialog.this.showDatabaseTypeChangeDialog(DatabaseToolsDialog.this.dialog);
            }
        });
        jp.add((Component)this.changeButton, new GridBagConstraints(1, row, 1, 1, 0.0, 0.0, 10, 0, new Insets(4, 4, 4, 11), 0, 0));
        this.exitBackupXmlCheckBox = new JCheckBox();
        s = Messages.getString("DatabaseToolsDialog.ShutdownBackupXml") + " (" + ApplicationHelper.getShutdownBackupXMLFile().toString() + ")";
        this.exitBackupXmlCheckBox.setText(s);
        this.exitBackupXmlCheckBox.setToolTipText(s);
        if (this.engine != null) {
            this.exitBackupXmlCheckBox.setSelected(this.engine.getGlobalProperties().getBoolean("shutdownBuckupXML", true));
        }
        this.exitBackupXmlCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DatabaseToolsDialog.this.engine.getGlobalProperties().putProperty("shutdownBuckupXML", DatabaseToolsDialog.this.exitBackupXmlCheckBox.isSelected());
            }
        });
        jp.add((Component)this.exitBackupXmlCheckBox, new GridBagConstraints(0, ++row, 2, 1, 1.0, 0.0, 10, 2, new Insets(4, 11, 4, 11), 0, 0));
        this.exitBackupOdbCheckBox = new JCheckBox();
        if (this.engine != null && GTDDataODB.isUsed(this.engine.getGTDModel())) {
            s = Messages.getString("DatabaseToolsDialog.ShutdownBackupOdb") + " (" + this.getGTDDataODB().getShutdownBackupFile().toString() + ")";
            this.exitBackupOdbCheckBox.setText(s);
            this.exitBackupOdbCheckBox.setToolTipText(s);
            this.exitBackupOdbCheckBox.setSelected(this.engine.getGlobalProperties().getBoolean("shutdownBuckupODB", true));
        } else {
            s = Messages.getString("DatabaseToolsDialog.ShutdownBackupOdb") + " (" + Messages.getString("DatabaseToolsDialog.NA") + ")";
            this.exitBackupOdbCheckBox.setText(s);
            this.exitBackupOdbCheckBox.setToolTipText(s);
            this.exitBackupOdbCheckBox.setEnabled(false);
        }
        this.exitBackupOdbCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DatabaseToolsDialog.this.engine.getGlobalProperties().putProperty("shutdownBuckupODB", DatabaseToolsDialog.this.exitBackupOdbCheckBox.isSelected());
            }
        });
        jp.add((Component)this.exitBackupOdbCheckBox, new GridBagConstraints(0, ++row, 2, 1, 1.0, 0.0, 10, 2, new Insets(4, 11, 4, 11), 0, 0));
        jp.add((Component)new JPanel(), new GridBagConstraints(0, ++row, 2, 1, 1.0, 1.0, 10, 2, new Insets(4, 11, 4, 11), 0, 0));
        return jp;
    }

    protected GTDDataODB getGTDDataODB() {
        if (this.engine == null) {
            return null;
        }
        GTDData d = this.engine.getGTDModel().getDataRepository();
        if (d instanceof GTDDataODB) {
            return (GTDDataODB)d;
        }
        return null;
    }

    protected JFileChooser getFileChooser() {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
            this.fileChooser.setCurrentDirectory(new File(System.getProperty("user.home", ".")));
            this.fileChooser.setFileSelectionMode(0);
            this.fileChooser.setMultiSelectionEnabled(false);
            this.fileChooser.setFileHidingEnabled(false);
            this.fileChooser.setAcceptAllFileFilterUsed(true);
            this.fileChooser.setFileFilter(new FileNameExtensionFilter(Messages.getString("DatabaseToolsDialog.ODBFile"), "odb-xml"));
        }
        return this.fileChooser;
    }

    public void showDatabaseTypeChangeDialog(Component owner) {
        Object[] options = new Object[]{Messages.getString("DatabaseToolsDialog.Sched"), Messages.getString("DatabaseToolsDialog.Cancel")};
        int o = JOptionPane.showOptionDialog(owner, Messages.getString("DatabaseToolsDialog.Sched.desc"), Messages.getString("DatabaseToolsDialog.Sched.title"), -1, 3, null, options, options[0]);
        if (o == 0) {
            this.engine.getGlobalProperties().putProperty("database", null);
        }
    }

    public void showDatabaseToolsDialog(Component owner) {
        JDialog d = this.getDialog(owner);
        d.setVisible(true);
    }

    public void setEngine(GTDFreeEngine engine) {
        this.engine = engine;
        if (this.exitBackupXmlCheckBox != null) {
            this.exitBackupXmlCheckBox.setSelected(engine.getGlobalProperties().getBoolean("shutdownBuckupXML", true));
        }
        if (this.exitBackupOdbCheckBox != null && GTDDataODB.isUsed(engine.getGTDModel())) {
            this.exitBackupOdbCheckBox.setText(Messages.getString("DatabaseToolsDialog.ShutdownBackupOdb") + " (" + this.getGTDDataODB().getShutdownBackupFile().toString() + ")");
            this.exitBackupOdbCheckBox.setSelected(engine.getGlobalProperties().getBoolean("shutdownBuckupODB", true));
        }
    }

    public void dispose() {
        if (this.dialog != null) {
            this.dialog.dispose();
        }
    }

    private void setButtonsEnabled(boolean b) {
        this.changeButton.setEnabled(b);
        this.checkButton.setEnabled(b);
        this.closeButton.setEnabled(b);
        this.repairCheckBox.setEnabled(b);
        this.mainTabs.setEnabled(b);
    }

    public synchronized boolean startVerify() {
        if (this.verifying || this.engine == null) {
            return false;
        }
        this.verifying = true;
        this.setButtonsEnabled(false);
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    boolean repair = DatabaseToolsDialog.this.repairCheckBox.isSelected();
                    DatabaseToolsDialog.this.consistencyCheckText.setText(Messages.getString("DatabaseToolsDialog.Model"));
                    int size = DatabaseToolsDialog.this.consistencyCheckText.getDocument().getLength();
                    try {
                        GTDModel.checkConsistency(DatabaseToolsDialog.this.engine.getGTDModel(), DatabaseToolsDialog.this.consistencyCheckLogger, false, repair);
                        if (size == DatabaseToolsDialog.this.consistencyCheckText.getDocument().getLength()) {
                            DatabaseToolsDialog.this.consistencyCheckText.append(Messages.getString("DatabaseToolsDialog.Model.OK"));
                        }
                    }
                    catch (ConsistencyException e1) {
                        DatabaseToolsDialog.this.consistencyCheckText.append(e1.toString());
                        DatabaseToolsDialog.this.consistencyCheckText.setCaretPosition(0);
                    }
                    DatabaseToolsDialog.this.consistencyCheckText.append(Messages.getString("DatabaseToolsDialog.Model.Done"));
                    DatabaseToolsDialog.this.consistencyCheckText.append(Messages.getString("DatabaseToolsDialog.Stor"));
                    size = DatabaseToolsDialog.this.consistencyCheckText.getDocument().getLength();
                    try {
                        DatabaseToolsDialog.this.engine.getGTDModel().getDataRepository().checkConsistency(DatabaseToolsDialog.this.consistencyCheckLogger, false, repair);
                        if (size == DatabaseToolsDialog.this.consistencyCheckText.getDocument().getLength()) {
                            DatabaseToolsDialog.this.consistencyCheckText.append(Messages.getString("DatabaseToolsDialog.Stor.OK"));
                        }
                    }
                    catch (ConsistencyException e1) {
                        DatabaseToolsDialog.this.consistencyCheckText.append(e1.toString());
                        DatabaseToolsDialog.this.consistencyCheckText.setCaretPosition(0);
                    }
                    DatabaseToolsDialog.this.consistencyCheckText.append(Messages.getString("DatabaseToolsDialog.Stor.Done"));
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    DatabaseToolsDialog.this.consistencyCheckText.append(Messages.getString("DatabaseToolsDialog.Check.Fail"));
                    DatabaseToolsDialog.this.consistencyCheckText.append(Messages.getString("DatabaseToolsDialog.Check.Err") + " ");
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    e.printStackTrace(pw);
                    pw.flush();
                    DatabaseToolsDialog.this.consistencyCheckText.append(sw.toString());
                }
                finally {
                    DatabaseToolsDialog repair = DatabaseToolsDialog.this;
                    synchronized (repair) {
                        DatabaseToolsDialog.this.verifying = false;
                        DatabaseToolsDialog.this.setButtonsEnabled(true);
                    }
                }
            }
        }.start();
        return true;
    }

    public synchronized void closeDialog() {
        if (this.verifying) {
            return;
        }
        if (this.dialog != null) {
            this.dialog.dispose();
        }
    }
}

