/*
 * Decompiled with CFR 0.152.
 */
package org.gtdfree.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import org.gtdfree.ApplicationHelper;
import org.gtdfree.Messages;

public class FoldingPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JPanel foldingBar;
    private List<FoldingButton> folds = new ArrayList<FoldingButton>();
    private JLabel titleLabel;

    public FoldingPanel() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new GridBagLayout());
        this.titleLabel = new JLabel("");
        this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(1));
        this.add((Component)this.titleLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.foldingBar = new JPanel(){
            private static final long serialVersionUID = 1L;

            @Override
            public Dimension getMinimumSize() {
                return new Dimension(super.getMinimumSize().width, super.getPreferredSize().height);
            }
        };
        this.foldingBar.setLayout(new FlowLayout(2));
        this.add((Component)this.foldingBar, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void addFold(String name, JComponent fold, boolean unfolded, boolean stretching, boolean butonVisible) {
        FoldingButton fb = new FoldingButton(name, fold);
        this.foldingBar.add(fb);
        GridBagConstraints g = new GridBagConstraints(0, this.getComponentCount(), 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 0, 0, 0), 0, 0);
        g.weighty = stretching ? 1.0 : 0.0;
        this.add((Component)fold, g);
        this.folds.add(fb);
        fb.setSelected(unfolded);
        fold.setVisible(unfolded);
        fb.setVisible(butonVisible);
        this.folds.get(this.folds.size() - 1).setVisible(butonVisible);
    }

    public void addFold(String name, JComponent fold, boolean unfolded, boolean stretching) {
        this.addFold(name, fold, unfolded, stretching, true);
    }

    public void setFoldingState(String name, boolean state) {
        for (FoldingButton fb : this.folds) {
            if (!fb.getName().equals(name)) continue;
            fb.setSelected(state);
            return;
        }
    }

    public boolean[] getFoldingStates() {
        boolean[] b = new boolean[this.folds.size()];
        for (int i = 0; i < b.length; ++i) {
            b[i] = this.folds.get(i).isSelected();
        }
        return b;
    }

    public void setTitle(String title) {
        this.titleLabel.setText(title);
    }

    public String getTitle() {
        return this.titleLabel.getText();
    }

    public void setFoldingStates(boolean[] b) {
        if (b == null || b.length == 0) {
            return;
        }
        for (int i = 0; i < b.length && i < this.folds.size(); ++i) {
            this.folds.get(i).setSelected(b[i]);
        }
    }

    class FoldingButton
    extends JToggleButton {
        private static final long serialVersionUID = 1L;
        private JComponent fold;

        public FoldingButton(String name, JComponent f) {
            this.setText(name);
            this.setName(name);
            this.fold = f;
            this.setMargin(new Insets(0, 0, 0, 0));
            this.setSelectedIcon(ApplicationHelper.getIcon(ApplicationHelper.icon_name_small_unfolded));
            this.setIcon(ApplicationHelper.getIcon(ApplicationHelper.icon_name_small_folded));
            this.setPreferredSize(new Dimension(this.getPreferredSize().width, 21));
            this.setToolTipText(Messages.getString("FoldingPanel.0") + name + Messages.getString("FoldingPanel.1"));
            this.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    FoldingButton.this.fold.setVisible(FoldingButton.this.isSelected());
                    if (FoldingPanel.this.getParent() != null) {
                        FoldingPanel.this.getParent().validate();
                    }
                }
            });
        }
    }
}

